/*
 * Decompiled with CFR 0.152.
 */
package org.apache.directory.server.factory;

import java.io.IOException;
import java.lang.annotation.Annotation;
import java.lang.reflect.Method;
import java.net.ServerSocket;
import org.apache.directory.server.annotations.CreateConsumer;
import org.apache.directory.server.annotations.CreateKdcServer;
import org.apache.directory.server.annotations.CreateLdapServer;
import org.apache.directory.server.annotations.CreateTransport;
import org.apache.directory.server.annotations.SaslMechanism;
import org.apache.directory.server.core.DirectoryService;
import org.apache.directory.server.core.annotations.AnnotationUtils;
import org.apache.directory.server.i18n.I18n;
import org.apache.directory.server.kerberos.kdc.KdcServer;
import org.apache.directory.server.ldap.ExtendedOperationHandler;
import org.apache.directory.server.ldap.LdapServer;
import org.apache.directory.server.ldap.handlers.bind.MechanismHandler;
import org.apache.directory.server.ldap.handlers.bind.ntlm.NtlmMechanismHandler;
import org.apache.directory.server.ldap.handlers.bind.ntlm.NtlmProvider;
import org.apache.directory.server.ldap.replication.ReplicationConsumer;
import org.apache.directory.server.ldap.replication.ReplicationConsumerConfig;
import org.apache.directory.server.ldap.replication.SyncReplConsumer;
import org.apache.directory.server.ldap.replication.SyncreplConfiguration;
import org.apache.directory.server.protocol.shared.transport.TcpTransport;
import org.apache.directory.server.protocol.shared.transport.Transport;
import org.apache.directory.server.protocol.shared.transport.UdpTransport;
import org.apache.directory.shared.util.Strings;
import org.apache.mina.util.AvailablePortFinder;
import org.junit.runner.Description;

public class ServerAnnotationProcessor {
    private static void createTransports(LdapServer ldapServer, CreateTransport[] transportBuilders) {
        if (transportBuilders.length != 0) {
            for (CreateTransport transportBuilder : transportBuilders) {
                String protocol = transportBuilder.protocol();
                int port = transportBuilder.port();
                int nbThreads = transportBuilder.nbThreads();
                int backlog = transportBuilder.backlog();
                String address = transportBuilder.address();
                if (port <= 0) {
                    try {
                        ServerSocket ss = new ServerSocket(0);
                        port = ss.getLocalPort();
                        ss.close();
                    }
                    catch (IOException ioe) {
                        // empty catch block
                    }
                }
                if (protocol.equalsIgnoreCase("LDAP")) {
                    TcpTransport ldap = new TcpTransport(address, port, nbThreads, backlog);
                    ldapServer.addTransports(new Transport[]{ldap});
                    continue;
                }
                if (protocol.equalsIgnoreCase("LDAPS")) {
                    TcpTransport ldaps = new TcpTransport(address, port, nbThreads, backlog);
                    ldaps.setEnableSSL(true);
                    ldapServer.addTransports(new Transport[]{ldaps});
                    continue;
                }
                throw new IllegalArgumentException(I18n.err((I18n)I18n.ERR_689, (Object[])new Object[]{protocol}));
            }
        } else {
            int port = AvailablePortFinder.getNextAvailable((int)1024);
            TcpTransport ldap = new TcpTransport(port);
            ldapServer.addTransports(new Transport[]{ldap});
            port = AvailablePortFinder.getNextAvailable((int)port);
            TcpTransport ldaps = new TcpTransport(port);
            ldaps.setEnableSSL(true);
            ldapServer.addTransports(new Transport[]{ldaps});
        }
    }

    public static LdapServer instantiateLdapServer(CreateLdapServer createLdapServer, DirectoryService directoryService) {
        if (createLdapServer != null) {
            Class<?> ntlmProviderClass;
            LdapServer ldapServer = new LdapServer();
            ldapServer.setServiceName(createLdapServer.name());
            ServerAnnotationProcessor.createTransports(ldapServer, createLdapServer.transports());
            ldapServer.setDirectoryService(directoryService);
            ldapServer.setSaslHost(createLdapServer.saslHost());
            ldapServer.setSaslPrincipal(createLdapServer.saslPrincipal());
            if (!Strings.isEmpty((String)createLdapServer.keyStore())) {
                ldapServer.setKeystoreFile(createLdapServer.keyStore());
                ldapServer.setCertificatePassword(createLdapServer.certificatePassword());
            }
            for (Class<?> extOpClass : createLdapServer.extendedOpHandlers()) {
                try {
                    ExtendedOperationHandler extOpHandler = (ExtendedOperationHandler)extOpClass.newInstance();
                    ldapServer.addExtendedOperationHandler(extOpHandler);
                }
                catch (Exception e) {
                    throw new RuntimeException(I18n.err((I18n)I18n.ERR_690, (Object[])new Object[]{extOpClass.getName()}), e);
                }
            }
            for (SaslMechanism saslMech : createLdapServer.saslMechanisms()) {
                try {
                    MechanismHandler handler = (MechanismHandler)saslMech.implClass().newInstance();
                    ldapServer.addSaslMechanismHandler(saslMech.name(), handler);
                }
                catch (Exception e) {
                    throw new RuntimeException(I18n.err((I18n)I18n.ERR_691, (Object[])new Object[]{saslMech.name(), saslMech.implClass().getName()}), e);
                }
            }
            NtlmMechanismHandler ntlmHandler = (NtlmMechanismHandler)ldapServer.getSaslMechanismHandlers().get("NTLM");
            if (ntlmHandler != null && (ntlmProviderClass = createLdapServer.ntlmProvider()) != null && ntlmProviderClass != Object.class) {
                try {
                    ntlmHandler.setNtlmProvider((NtlmProvider)ntlmProviderClass.newInstance());
                }
                catch (Exception e) {
                    throw new RuntimeException(I18n.err((I18n)I18n.ERR_692, (Object[])new Object[0]), e);
                }
            }
            return ldapServer;
        }
        return null;
    }

    public static LdapServer getLdapServer(DirectoryService directoryService) throws ClassNotFoundException {
        Object instance = AnnotationUtils.getInstance(CreateLdapServer.class);
        LdapServer ldapServer = null;
        if (instance != null) {
            CreateLdapServer createLdapServer = (CreateLdapServer)instance;
            ldapServer = ServerAnnotationProcessor.createLdapServer(createLdapServer, directoryService);
        }
        return ldapServer;
    }

    private static ReplicationConsumer createConsumer(CreateConsumer createConsumer) {
        SyncReplConsumer consumer = new SyncReplConsumer();
        SyncreplConfiguration config = new SyncreplConfiguration();
        config.setRemoteHost(createConsumer.remoteHost());
        config.setRemotePort(createConsumer.remotePort());
        config.setReplUserDn(createConsumer.replUserDn());
        config.setReplUserPassword(Strings.getBytesUtf8((String)createConsumer.replUserPassword()));
        config.setUseTls(createConsumer.useTls());
        config.setBaseDn(createConsumer.baseDn());
        config.setRefreshInterval(createConsumer.refreshInterval());
        consumer.setConfig((ReplicationConsumerConfig)config);
        return consumer;
    }

    public static ReplicationConsumer createConsumer() throws ClassNotFoundException {
        Object instance = AnnotationUtils.getInstance(CreateConsumer.class);
        ReplicationConsumer consumer = null;
        if (instance != null) {
            CreateConsumer createConsumer = (CreateConsumer)instance;
            consumer = ServerAnnotationProcessor.createConsumer(createConsumer);
        }
        return consumer;
    }

    private static LdapServer createLdapServer(CreateLdapServer createLdapServer, DirectoryService directoryService) {
        LdapServer ldapServer = ServerAnnotationProcessor.instantiateLdapServer(createLdapServer, directoryService);
        if (ldapServer == null) {
            return null;
        }
        try {
            ldapServer.start();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return ldapServer;
    }

    public static LdapServer createLdapServer(Description description, DirectoryService directoryService) throws Exception {
        CreateLdapServer createLdapServer = (CreateLdapServer)description.getAnnotation(CreateLdapServer.class);
        return ServerAnnotationProcessor.createLdapServer(createLdapServer, directoryService);
    }

    private static Annotation getAnnotation(Class annotationClass) throws Exception {
        Method[] methods;
        StackTraceElement[] stackTrace = Thread.currentThread().getStackTrace();
        int index = stackTrace[0].getMethodName().equals("dumpThreads") ? 4 : 3;
        Class<?> classCaller = Class.forName(stackTrace[index].getClassName());
        String methodCaller = stackTrace[index].getMethodName();
        for (Method method : methods = classCaller.getMethods()) {
            Object annotation;
            if (!methodCaller.equals(method.getName()) || (annotation = method.getAnnotation(annotationClass)) == null) continue;
            return annotation;
        }
        return classCaller.getAnnotation(annotationClass);
    }

    public static KdcServer getKdcServer(DirectoryService directoryService, int startPort) throws Exception {
        CreateKdcServer createKdcServer = (CreateKdcServer)ServerAnnotationProcessor.getAnnotation(CreateKdcServer.class);
        return ServerAnnotationProcessor.createKdcServer(createKdcServer, directoryService, startPort);
    }

    private static KdcServer createKdcServer(CreateKdcServer createKdcServer, DirectoryService directoryService, int startPort) {
        if (createKdcServer == null) {
            return null;
        }
        KdcServer kdcServer = new KdcServer();
        kdcServer.setServiceName(createKdcServer.name());
        kdcServer.setKdcPrincipal(createKdcServer.kdcPrincipal());
        kdcServer.setPrimaryRealm(createKdcServer.primaryRealm());
        kdcServer.setMaximumTicketLifetime(createKdcServer.maxTicketLifetime());
        kdcServer.setMaximumRenewableLifetime(createKdcServer.maxRenewableLifetime());
        CreateTransport[] transportBuilders = createKdcServer.transports();
        if (transportBuilders == null) {
            UdpTransport defaultTransport = new UdpTransport(AvailablePortFinder.getNextAvailable((int)startPort));
            kdcServer.addTransports(new Transport[]{defaultTransport});
        } else if (transportBuilders.length > 0) {
            for (CreateTransport transportBuilder : transportBuilders) {
                String protocol = transportBuilder.protocol();
                int port = transportBuilder.port();
                int nbThreads = transportBuilder.nbThreads();
                int backlog = transportBuilder.backlog();
                String address = transportBuilder.address();
                if (port == -1) {
                    port = AvailablePortFinder.getNextAvailable((int)startPort);
                    startPort = port + 1;
                }
                if (protocol.equalsIgnoreCase("TCP")) {
                    TcpTransport tcp = new TcpTransport(address, port, nbThreads, backlog);
                    kdcServer.addTransports(new Transport[]{tcp});
                    continue;
                }
                if (protocol.equalsIgnoreCase("UDP")) {
                    UdpTransport udp = new UdpTransport(address, port);
                    kdcServer.addTransports(new Transport[]{udp});
                    continue;
                }
                throw new IllegalArgumentException(I18n.err((I18n)I18n.ERR_689, (Object[])new Object[]{protocol}));
            }
        }
        kdcServer.setDirectoryService(directoryService);
        try {
            kdcServer.start();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return kdcServer;
    }

    public static KdcServer getKdcServer(Description description, DirectoryService directoryService, int startPort) throws Exception {
        CreateKdcServer createLdapServer = (CreateKdcServer)description.getAnnotation(CreateKdcServer.class);
        return ServerAnnotationProcessor.createKdcServer(createLdapServer, directoryService, startPort);
    }
}

