/*
 * Decompiled with CFR 0.152.
 */
package org.apache.directory.server.schema.registries;

import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import javax.naming.NamingException;
import org.apache.directory.server.schema.registries.DITContentRuleRegistry;
import org.apache.directory.server.schema.registries.OidRegistry;
import org.apache.directory.shared.ldap.schema.DITContentRule;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DefaultDitContentRuleRegistry
implements DITContentRuleRegistry {
    private static final Logger LOG = LoggerFactory.getLogger(DefaultDitContentRuleRegistry.class);
    private final Map<String, DITContentRule> byOid = new HashMap<String, DITContentRule>();
    private final OidRegistry oidRegistry;

    public DefaultDitContentRuleRegistry(OidRegistry oidRegistry) {
        this.oidRegistry = oidRegistry;
    }

    @Override
    public void register(DITContentRule dITContentRule) throws NamingException {
        if (this.byOid.containsKey(dITContentRule.getOid())) {
            throw new NamingException("dITContentRule w/ OID " + dITContentRule.getOid() + " has already been registered!");
        }
        this.oidRegistry.register(dITContentRule.getName(), dITContentRule.getOid());
        this.byOid.put(dITContentRule.getOid(), dITContentRule);
        if (LOG.isDebugEnabled()) {
            LOG.debug("registed dITContentRule: " + dITContentRule);
        }
    }

    @Override
    public DITContentRule lookup(String id) throws NamingException {
        if (!this.byOid.containsKey(id = this.oidRegistry.getOid(id))) {
            throw new NamingException("dITContentRule w/ OID " + id + " not registered!");
        }
        DITContentRule dITContentRule = this.byOid.get(id);
        if (LOG.isDebugEnabled()) {
            LOG.debug("lookup with id '" + id + "' of dITContentRule: " + dITContentRule);
        }
        return dITContentRule;
    }

    @Override
    public boolean hasDITContentRule(String id) {
        if (this.oidRegistry.hasOid(id)) {
            try {
                return this.byOid.containsKey(this.oidRegistry.getOid(id));
            }
            catch (NamingException e) {
                return false;
            }
        }
        return false;
    }

    @Override
    public String getSchemaName(String id) throws NamingException {
        DITContentRule dcr = this.byOid.get(id = this.oidRegistry.getOid(id));
        if (dcr != null) {
            return dcr.getSchema();
        }
        throw new NamingException("OID " + id + " not found in oid to " + "DITContentRule map!");
    }

    @Override
    public Iterator<DITContentRule> iterator() {
        return this.byOid.values().iterator();
    }

    @Override
    public void unregister(String numericOid) throws NamingException {
        if (!Character.isDigit(numericOid.charAt(0))) {
            throw new NamingException("Looks like the arg is not a numeric OID");
        }
        this.byOid.remove(numericOid);
    }
}

