
/*
 *  Licensed to the Apache Software Foundation (ASF) under one
 *  or more contributor license agreements.  See the NOTICE file
 *  distributed with this work for additional information
 *  regarding copyright ownership.  The ASF licenses this file
 *  to you under the Apache License, Version 2.0 (the
 *  "License"); you may not use this file except in compliance
 *  with the License.  You may obtain a copy of the License at
 *  
 *    http://www.apache.org/licenses/LICENSE-2.0
 *  
 *  Unless required by applicable law or agreed to in writing,
 *  software distributed under the License is distributed on an
 *  "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 *  KIND, either express or implied.  See the License for the
 *  specific language governing permissions and limitations
 *  under the License. 
 *  
 */
package org.apache.directory.server.schema.bootstrap;


import java.util.ArrayList;
import javax.naming.NamingException;
import org.apache.directory.shared.ldap.schema.ObjectClassTypeEnum;
import org.apache.directory.server.schema.registries.Registries;


/**
 * A producer of schema objectClass definations for the krb5kdc schema.  This
 * code has been automatically generated using schema files in the OpenLDAP
 * format along with the directory plugin for maven.  This has been done
 * to facilitate OpenLDAP schema interoperability.
 *
 * @author <a href="mailto:dev@directory.apache.org">Apache Directory Project</a>
 */
public class Krb5kdcObjectClassProducer extends AbstractBootstrapProducer
{

    public Krb5kdcObjectClassProducer()
    {
        super( ProducerTypeEnum.OBJECT_CLASS_PRODUCER );
    }


    // ------------------------------------------------------------------------
    // BootstrapProducer Methods
    // ------------------------------------------------------------------------


    /**
     * @see BootstrapProducer#produce(Registries, ProducerCallback)
     */
    public void produce( Registries registries, ProducerCallback cb )
        throws NamingException
    {
        ArrayList<String> array = new ArrayList<String>();
        BootstrapObjectClass objectClass;

        // --------------------------------------------------------------------
        // ObjectClass 1.3.6.1.4.1.5322.10.2.1 
        // --------------------------------------------------------------------

        objectClass = newObjectClass( "1.3.6.1.4.1.5322.10.2.1", registries );
        objectClass.setObsolete( false );

        // set the objectclass type
        objectClass.setType( ObjectClassTypeEnum.AUXILIARY );

        // set superior objectClasses
        array.clear();
        array.add( "top" );
        objectClass.setSuperClassIds( array.toArray( EMPTY ) );

        // set must list
        array.clear();
        array.add( "krb5PrincipalName" );
        objectClass.setMustListIds( array.toArray( EMPTY ) );

        // set may list
        array.clear();
        array.add( "cn" );
        array.add( "krb5PrincipalRealm" );
        objectClass.setMayListIds( array.toArray( EMPTY ) );

        // set names
        array.clear();
        array.add( "krb5Principal" );
        objectClass.setNames( array.toArray( EMPTY ) );
        cb.schemaObjectProduced( this, "1.3.6.1.4.1.5322.10.2.1", objectClass );
        // --------------------------------------------------------------------
        // ObjectClass 1.3.6.1.4.1.5322.10.2.2 
        // --------------------------------------------------------------------

        objectClass = newObjectClass( "1.3.6.1.4.1.5322.10.2.2", registries );
        objectClass.setObsolete( false );

        // set the objectclass type
        objectClass.setType( ObjectClassTypeEnum.AUXILIARY );

        // set superior objectClasses
        array.clear();
        array.add( "krb5Principal" );
        objectClass.setSuperClassIds( array.toArray( EMPTY ) );

        // set must list
        array.clear();
        array.add( "krb5KeyVersionNumber" );
        objectClass.setMustListIds( array.toArray( EMPTY ) );

        // set may list
        array.clear();
        array.add( "krb5ValidStart" );
        array.add( "krb5ValidEnd" );
        array.add( "krb5PasswordEnd" );
        array.add( "krb5MaxLife" );
        array.add( "krb5MaxRenew" );
        array.add( "krb5KDCFlags" );
        array.add( "krb5EncryptionType" );
        array.add( "krb5Key" );
        array.add( "krb5AccountDisabled" );
        array.add( "krb5AccountLockedOut" );
        array.add( "krb5AccountExpirationTime" );
        objectClass.setMayListIds( array.toArray( EMPTY ) );

        // set names
        array.clear();
        array.add( "krb5KDCEntry" );
        objectClass.setNames( array.toArray( EMPTY ) );
        cb.schemaObjectProduced( this, "1.3.6.1.4.1.5322.10.2.2", objectClass );
        // --------------------------------------------------------------------
        // ObjectClass 1.3.6.1.4.1.5322.10.2.3 
        // --------------------------------------------------------------------

        objectClass = newObjectClass( "1.3.6.1.4.1.5322.10.2.3", registries );
        objectClass.setObsolete( false );

        // set the objectclass type
        objectClass.setType( ObjectClassTypeEnum.AUXILIARY );

        // set superior objectClasses
        array.clear();
        array.add( "top" );
        objectClass.setSuperClassIds( array.toArray( EMPTY ) );

        // set must list
        array.clear();
        array.add( "krb5RealmName" );
        objectClass.setMustListIds( array.toArray( EMPTY ) );

        // set may list
        array.clear();
        objectClass.setMayListIds( array.toArray( EMPTY ) );

        // set names
        array.clear();
        array.add( "krb5Realm" );
        objectClass.setNames( array.toArray( EMPTY ) );
        cb.schemaObjectProduced( this, "1.3.6.1.4.1.5322.10.2.3", objectClass );
    }
}
