
/*
 *  Licensed to the Apache Software Foundation (ASF) under one
 *  or more contributor license agreements.  See the NOTICE file
 *  distributed with this work for additional information
 *  regarding copyright ownership.  The ASF licenses this file
 *  to you under the Apache License, Version 2.0 (the
 *  "License"); you may not use this file except in compliance
 *  with the License.  You may obtain a copy of the License at
 *  
 *    http://www.apache.org/licenses/LICENSE-2.0
 *  
 *  Unless required by applicable law or agreed to in writing,
 *  software distributed under the License is distributed on an
 *  "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 *  KIND, either express or implied.  See the License for the
 *  specific language governing permissions and limitations
 *  under the License. 
 *  
 */
package org.apache.directory.server.schema.bootstrap;


import java.util.ArrayList;
import javax.naming.NamingException;

import org.apache.directory.server.schema.registries.Registries;
import org.apache.directory.shared.ldap.schema.UsageEnum;


/**
 * A producer of schema attributeType definations for the system schema.  This
 * code has been automatically generated using schema files in the OpenLDAP
 * format along with the directory plugin for maven.  This has been done
 * to facilitate Eve<->OpenLDAP schema interoperability.
 *
 * @author <a href="mailto:dev@directory.apache.org">Apache Directory Project</a>
 */
public class SystemAttributeTypeProducer extends AbstractBootstrapProducer
{

    public SystemAttributeTypeProducer()
    {
        super( ProducerTypeEnum.ATTRIBUTE_TYPE_PRODUCER );
    }


    // ------------------------------------------------------------------------
    // BootstrapProducer Methods
    // ------------------------------------------------------------------------


    /**
     * @see BootstrapProducer#produce( Registries, ProducerCallback )
     */
    public void produce( Registries registries, ProducerCallback cb )
        throws NamingException
    {
        ArrayList<String> names = new ArrayList<String>();
        BootstrapAttributeType attributeType;


        // --------------------------------------------------------------------
        // AttributeType 2.5.4.0 
        // --------------------------------------------------------------------

        attributeType = newAttributeType( "2.5.4.0", registries );
        attributeType.setDescription( "RFC2256: object classes of the entity" );
        attributeType.setCanUserModify( ! false );
        attributeType.setSingleValue( false );
        attributeType.setCollective( false );
        attributeType.setObsolete( false );
        attributeType.setLength( 0 );
        attributeType.setUsage( UsageEnum.getUsage( "USER_APPLICATIONS" ) );
        attributeType.setEqualityId( "objectIdentifierMatch" );
        attributeType.setSyntaxId( "1.3.6.1.4.1.1466.115.121.1.38" );

        names.clear();
        names.add( "objectClass" );
        attributeType.setNames( names.toArray( EMPTY ) );
        cb.schemaObjectProduced( this, "2.5.4.0", attributeType );

        // --------------------------------------------------------------------
        // AttributeType 2.5.21.9 
        // --------------------------------------------------------------------

        attributeType = newAttributeType( "2.5.21.9", registries );
        attributeType.setDescription( "X.500(93): structural object class of entry" );
        attributeType.setCanUserModify( ! true );
        attributeType.setSingleValue( true );
        attributeType.setCollective( false );
        attributeType.setObsolete( false );
        attributeType.setLength( 0 );
        attributeType.setUsage( UsageEnum.getUsage( "DIRECTORY_OPERATION" ) );
        attributeType.setEqualityId( "objectIdentifierMatch" );
        attributeType.setSyntaxId( "1.3.6.1.4.1.1466.115.121.1.38" );

        names.clear();
        names.add( "structuralObjectClass" );
        attributeType.setNames( names.toArray( EMPTY ) );
        cb.schemaObjectProduced( this, "2.5.21.9", attributeType );

        // --------------------------------------------------------------------
        // AttributeType 2.5.18.1 
        // --------------------------------------------------------------------

        attributeType = newAttributeType( "2.5.18.1", registries );
        attributeType.setDescription( "RFC2252: time which object was created" );
        attributeType.setCanUserModify( ! true );
        attributeType.setSingleValue( true );
        attributeType.setCollective( false );
        attributeType.setObsolete( false );
        attributeType.setLength( 0 );
        attributeType.setUsage( UsageEnum.getUsage( "DIRECTORY_OPERATION" ) );
        attributeType.setEqualityId( "generalizedTimeMatch" );
        attributeType.setOrderingId( "generalizedTimeOrderingMatch" );
        attributeType.setSyntaxId( "1.3.6.1.4.1.1466.115.121.1.24" );

        names.clear();
        names.add( "createTimestamp" );
        attributeType.setNames( names.toArray( EMPTY ) );
        cb.schemaObjectProduced( this, "2.5.18.1", attributeType );

        // --------------------------------------------------------------------
        // AttributeType 2.5.18.2 
        // --------------------------------------------------------------------

        attributeType = newAttributeType( "2.5.18.2", registries );
        attributeType.setDescription( "RFC2252: time which object was last modified" );
        attributeType.setCanUserModify( ! true );
        attributeType.setSingleValue( true );
        attributeType.setCollective( false );
        attributeType.setObsolete( false );
        attributeType.setLength( 0 );
        attributeType.setUsage( UsageEnum.getUsage( "DIRECTORY_OPERATION" ) );
        attributeType.setEqualityId( "generalizedTimeMatch" );
        attributeType.setOrderingId( "generalizedTimeOrderingMatch" );
        attributeType.setSyntaxId( "1.3.6.1.4.1.1466.115.121.1.24" );

        names.clear();
        names.add( "modifyTimestamp" );
        attributeType.setNames( names.toArray( EMPTY ) );
        cb.schemaObjectProduced( this, "2.5.18.2", attributeType );

        // --------------------------------------------------------------------
        // AttributeType 2.5.18.3 
        // --------------------------------------------------------------------

        attributeType = newAttributeType( "2.5.18.3", registries );
        attributeType.setDescription( "RFC2252: name of creator" );
        attributeType.setCanUserModify( ! true );
        attributeType.setSingleValue( true );
        attributeType.setCollective( false );
        attributeType.setObsolete( false );
        attributeType.setLength( 0 );
        attributeType.setUsage( UsageEnum.getUsage( "DIRECTORY_OPERATION" ) );
        attributeType.setEqualityId( "distinguishedNameMatch" );
        attributeType.setSyntaxId( "1.3.6.1.4.1.1466.115.121.1.12" );

        names.clear();
        names.add( "creatorsName" );
        attributeType.setNames( names.toArray( EMPTY ) );
        cb.schemaObjectProduced( this, "2.5.18.3", attributeType );

        // --------------------------------------------------------------------
        // AttributeType 2.5.18.4 
        // --------------------------------------------------------------------

        attributeType = newAttributeType( "2.5.18.4", registries );
        attributeType.setDescription( "RFC2252: name of last modifier" );
        attributeType.setCanUserModify( ! true );
        attributeType.setSingleValue( true );
        attributeType.setCollective( false );
        attributeType.setObsolete( false );
        attributeType.setLength( 0 );
        attributeType.setUsage( UsageEnum.getUsage( "DIRECTORY_OPERATION" ) );
        attributeType.setEqualityId( "distinguishedNameMatch" );
        attributeType.setSyntaxId( "1.3.6.1.4.1.1466.115.121.1.12" );

        names.clear();
        names.add( "modifiersName" );
        attributeType.setNames( names.toArray( EMPTY ) );
        cb.schemaObjectProduced( this, "2.5.18.4", attributeType );

        // --------------------------------------------------------------------
        // AttributeType 2.5.18.9 
        // --------------------------------------------------------------------

        attributeType = newAttributeType( "2.5.18.9", registries );
        attributeType.setDescription( "X.501: entry has children" );
        attributeType.setCanUserModify( ! true );
        attributeType.setSingleValue( true );
        attributeType.setCollective( false );
        attributeType.setObsolete( false );
        attributeType.setLength( 0 );
        attributeType.setUsage( UsageEnum.getUsage( "DIRECTORY_OPERATION" ) );
        attributeType.setEqualityId( "booleanMatch" );
        attributeType.setSyntaxId( "1.3.6.1.4.1.1466.115.121.1.7" );

        names.clear();
        names.add( "hasSubordinates" );
        attributeType.setNames( names.toArray( EMPTY ) );
        cb.schemaObjectProduced( this, "2.5.18.9", attributeType );

        // --------------------------------------------------------------------
        // AttributeType 2.5.18.10 
        // --------------------------------------------------------------------

        attributeType = newAttributeType( "2.5.18.10", registries );
        attributeType.setDescription( "RFC2252: name of controlling subschema entry" );
        attributeType.setCanUserModify( ! true );
        attributeType.setSingleValue( true );
        attributeType.setCollective( false );
        attributeType.setObsolete( false );
        attributeType.setLength( 0 );
        attributeType.setUsage( UsageEnum.getUsage( "DIRECTORY_OPERATION" ) );
        attributeType.setEqualityId( "distinguishedNameMatch" );
        attributeType.setSyntaxId( "1.3.6.1.4.1.1466.115.121.1.12" );

        names.clear();
        names.add( "subschemaSubentry" );
        attributeType.setNames( names.toArray( EMPTY ) );
        cb.schemaObjectProduced( this, "2.5.18.10", attributeType );

        // --------------------------------------------------------------------
        // AttributeType 2.5.18.12 
        // --------------------------------------------------------------------

        attributeType = newAttributeType( "2.5.18.12", registries );
        attributeType.setCanUserModify( ! true );
        attributeType.setSingleValue( false );
        attributeType.setCollective( false );
        attributeType.setObsolete( false );
        attributeType.setLength( 0 );
        attributeType.setUsage( UsageEnum.getUsage( "DIRECTORY_OPERATION" ) );
        attributeType.setEqualityId( "distinguishedNameMatch" );
        attributeType.setSyntaxId( "1.3.6.1.4.1.1466.115.121.1.12" );

        names.clear();
        names.add( "collectiveAttributeSubentries" );
        attributeType.setNames( names.toArray( EMPTY ) );
        cb.schemaObjectProduced( this, "2.5.18.12", attributeType );

        // --------------------------------------------------------------------
        // AttributeType 2.5.18.7 
        // --------------------------------------------------------------------

        attributeType = newAttributeType( "2.5.18.7", registries );
        attributeType.setCanUserModify( ! false );
        attributeType.setSingleValue( false );
        attributeType.setCollective( false );
        attributeType.setObsolete( false );
        attributeType.setLength( 0 );
        attributeType.setUsage( UsageEnum.getUsage( "DIRECTORY_OPERATION" ) );
        attributeType.setEqualityId( "objectIdentifierMatch" );
        attributeType.setSyntaxId( "1.3.6.1.4.1.1466.115.121.1.38" );

        names.clear();
        names.add( "collectiveExclusions" );
        attributeType.setNames( names.toArray( EMPTY ) );
        cb.schemaObjectProduced( this, "2.5.18.7", attributeType );

        // --------------------------------------------------------------------
        // AttributeType 1.3.6.1.4.1.1466.101.120.6 
        // --------------------------------------------------------------------

        attributeType = newAttributeType( "1.3.6.1.4.1.1466.101.120.6", registries );
        attributeType.setDescription( "RFC2252: alternative servers" );
        attributeType.setCanUserModify( ! false );
        attributeType.setSingleValue( false );
        attributeType.setCollective( false );
        attributeType.setObsolete( false );
        attributeType.setLength( 0 );
        attributeType.setUsage( UsageEnum.getUsage( "DSA_OPERATION" ) );
        attributeType.setSyntaxId( "1.3.6.1.4.1.1466.115.121.1.26" );

        names.clear();
        names.add( "altServer" );
        attributeType.setNames( names.toArray( EMPTY ) );
        cb.schemaObjectProduced( this, "1.3.6.1.4.1.1466.101.120.6", attributeType );

        // --------------------------------------------------------------------
        // AttributeType 1.3.6.1.4.1.1466.101.120.5 
        // --------------------------------------------------------------------

        attributeType = newAttributeType( "1.3.6.1.4.1.1466.101.120.5", registries );
        attributeType.setDescription( "RFC2252: naming contexts" );
        attributeType.setCanUserModify( ! false );
        attributeType.setSingleValue( false );
        attributeType.setCollective( false );
        attributeType.setObsolete( false );
        attributeType.setLength( 0 );
        attributeType.setUsage( UsageEnum.getUsage( "DSA_OPERATION" ) );
        attributeType.setSyntaxId( "1.3.6.1.4.1.1466.115.121.1.12" );

        names.clear();
        names.add( "namingContexts" );
        attributeType.setNames( names.toArray( EMPTY ) );
        cb.schemaObjectProduced( this, "1.3.6.1.4.1.1466.101.120.5", attributeType );

        // --------------------------------------------------------------------
        // AttributeType 1.3.6.1.4.1.1466.101.120.13 
        // --------------------------------------------------------------------

        attributeType = newAttributeType( "1.3.6.1.4.1.1466.101.120.13", registries );
        attributeType.setDescription( "RFC2252: supported controls" );
        attributeType.setCanUserModify( ! false );
        attributeType.setSingleValue( false );
        attributeType.setCollective( false );
        attributeType.setObsolete( false );
        attributeType.setLength( 0 );
        attributeType.setUsage( UsageEnum.getUsage( "DSA_OPERATION" ) );
        attributeType.setSyntaxId( "1.3.6.1.4.1.1466.115.121.1.38" );

        names.clear();
        names.add( "supportedControl" );
        attributeType.setNames( names.toArray( EMPTY ) );
        cb.schemaObjectProduced( this, "1.3.6.1.4.1.1466.101.120.13", attributeType );

        // --------------------------------------------------------------------
        // AttributeType 1.3.6.1.4.1.1466.101.120.7 
        // --------------------------------------------------------------------

        attributeType = newAttributeType( "1.3.6.1.4.1.1466.101.120.7", registries );
        attributeType.setDescription( "RFC2252: supported extended operations" );
        attributeType.setCanUserModify( ! false );
        attributeType.setSingleValue( false );
        attributeType.setCollective( false );
        attributeType.setObsolete( false );
        attributeType.setLength( 0 );
        attributeType.setUsage( UsageEnum.getUsage( "DSA_OPERATION" ) );
        attributeType.setSyntaxId( "1.3.6.1.4.1.1466.115.121.1.38" );

        names.clear();
        names.add( "supportedExtension" );
        attributeType.setNames( names.toArray( EMPTY ) );
        cb.schemaObjectProduced( this, "1.3.6.1.4.1.1466.101.120.7", attributeType );

        // --------------------------------------------------------------------
        // AttributeType 1.3.6.1.4.1.1466.101.120.15 
        // --------------------------------------------------------------------

        attributeType = newAttributeType( "1.3.6.1.4.1.1466.101.120.15", registries );
        attributeType.setDescription( "RFC2252: supported LDAP versions" );
        attributeType.setCanUserModify( ! false );
        attributeType.setSingleValue( false );
        attributeType.setCollective( false );
        attributeType.setObsolete( false );
        attributeType.setLength( 0 );
        attributeType.setUsage( UsageEnum.getUsage( "DSA_OPERATION" ) );
        attributeType.setSyntaxId( "1.3.6.1.4.1.1466.115.121.1.27" );

        names.clear();
        names.add( "supportedLDAPVersion" );
        attributeType.setNames( names.toArray( EMPTY ) );
        cb.schemaObjectProduced( this, "1.3.6.1.4.1.1466.101.120.15", attributeType );

        // --------------------------------------------------------------------
        // AttributeType 1.3.6.1.4.1.1466.101.120.14 
        // --------------------------------------------------------------------

        attributeType = newAttributeType( "1.3.6.1.4.1.1466.101.120.14", registries );
        attributeType.setDescription( "RFC2252: supported SASL mechanisms" );
        attributeType.setCanUserModify( ! false );
        attributeType.setSingleValue( false );
        attributeType.setCollective( false );
        attributeType.setObsolete( false );
        attributeType.setLength( 0 );
        attributeType.setUsage( UsageEnum.getUsage( "DSA_OPERATION" ) );
        attributeType.setSyntaxId( "1.3.6.1.4.1.1466.115.121.1.15" );

        names.clear();
        names.add( "supportedSASLMechanisms" );
        attributeType.setNames( names.toArray( EMPTY ) );
        cb.schemaObjectProduced( this, "1.3.6.1.4.1.1466.101.120.14", attributeType );

        // --------------------------------------------------------------------
        // AttributeType 1.3.6.1.1.4 
        // --------------------------------------------------------------------

        attributeType = newAttributeType( "1.3.6.1.1.4", registries );
        attributeType.setDescription( "RFC3045: name of implementation vendor" );
        attributeType.setCanUserModify( ! true );
        attributeType.setSingleValue( true );
        attributeType.setCollective( false );
        attributeType.setObsolete( false );
        attributeType.setLength( 0 );
        attributeType.setUsage( UsageEnum.getUsage( "DSA_OPERATION" ) );
        attributeType.setEqualityId( "caseExactMatch" );
        attributeType.setSyntaxId( "1.3.6.1.4.1.1466.115.121.1.15" );

        names.clear();
        names.add( "vendorName" );
        attributeType.setNames( names.toArray( EMPTY ) );
        cb.schemaObjectProduced( this, "1.3.6.1.1.4", attributeType );

        // --------------------------------------------------------------------
        // AttributeType 1.3.6.1.1.5 
        // --------------------------------------------------------------------

        attributeType = newAttributeType( "1.3.6.1.1.5", registries );
        attributeType.setDescription( "RFC3045: version of implementation" );
        attributeType.setCanUserModify( ! true );
        attributeType.setSingleValue( true );
        attributeType.setCollective( false );
        attributeType.setObsolete( false );
        attributeType.setLength( 0 );
        attributeType.setUsage( UsageEnum.getUsage( "DSA_OPERATION" ) );
        attributeType.setEqualityId( "caseExactMatch" );
        attributeType.setSyntaxId( "1.3.6.1.4.1.1466.115.121.1.15" );

        names.clear();
        names.add( "vendorVersion" );
        attributeType.setNames( names.toArray( EMPTY ) );
        cb.schemaObjectProduced( this, "1.3.6.1.1.5", attributeType );

        // --------------------------------------------------------------------
        // AttributeType 2.5.18.5 
        // --------------------------------------------------------------------

        attributeType = newAttributeType( "2.5.18.5", registries );
        attributeType.setCanUserModify( ! false );
        attributeType.setSingleValue( false );
        attributeType.setCollective( false );
        attributeType.setObsolete( false );
        attributeType.setLength( 0 );
        attributeType.setUsage( UsageEnum.getUsage( "DIRECTORY_OPERATION" ) );
        attributeType.setEqualityId( "objectIdentifierMatch" );
        attributeType.setSyntaxId( "1.3.6.1.4.1.1466.115.121.1.38" );

        names.clear();
        names.add( "administrativeRole" );
        attributeType.setNames( names.toArray( EMPTY ) );
        cb.schemaObjectProduced( this, "2.5.18.5", attributeType );

        // --------------------------------------------------------------------
        // AttributeType 2.5.18.6 
        // --------------------------------------------------------------------

        attributeType = newAttributeType( "2.5.18.6", registries );
        attributeType.setCanUserModify( ! false );
        attributeType.setSingleValue( true );
        attributeType.setCollective( false );
        attributeType.setObsolete( false );
        attributeType.setLength( 0 );
        attributeType.setUsage( UsageEnum.getUsage( "DIRECTORY_OPERATION" ) );
        attributeType.setSyntaxId( "1.3.6.1.4.1.1466.115.121.1.45" );

        names.clear();
        names.add( "subtreeSpecification" );
        attributeType.setNames( names.toArray( EMPTY ) );
        cb.schemaObjectProduced( this, "2.5.18.6", attributeType );

        // --------------------------------------------------------------------
        // AttributeType 2.5.21.1 
        // --------------------------------------------------------------------

        attributeType = newAttributeType( "2.5.21.1", registries );
        attributeType.setDescription( "RFC2252: DIT structure rules" );
        attributeType.setCanUserModify( ! false );
        attributeType.setSingleValue( false );
        attributeType.setCollective( false );
        attributeType.setObsolete( false );
        attributeType.setLength( 0 );
        attributeType.setUsage( UsageEnum.getUsage( "DIRECTORY_OPERATION" ) );
        attributeType.setEqualityId( "integerFirstComponentMatch" );
        attributeType.setSyntaxId( "1.3.6.1.4.1.1466.115.121.1.17" );

        names.clear();
        names.add( "dITStructureRules" );
        attributeType.setNames( names.toArray( EMPTY ) );
        cb.schemaObjectProduced( this, "2.5.21.1", attributeType );

        // --------------------------------------------------------------------
        // AttributeType 2.5.21.2 
        // --------------------------------------------------------------------

        attributeType = newAttributeType( "2.5.21.2", registries );
        attributeType.setDescription( "RFC2252: DIT content rules" );
        attributeType.setCanUserModify( ! false );
        attributeType.setSingleValue( false );
        attributeType.setCollective( false );
        attributeType.setObsolete( false );
        attributeType.setLength( 0 );
        attributeType.setUsage( UsageEnum.getUsage( "DIRECTORY_OPERATION" ) );
        attributeType.setEqualityId( "objectIdentifierFirstComponentMatch" );
        attributeType.setSyntaxId( "1.3.6.1.4.1.1466.115.121.1.16" );

        names.clear();
        names.add( "dITContentRules" );
        attributeType.setNames( names.toArray( EMPTY ) );
        cb.schemaObjectProduced( this, "2.5.21.2", attributeType );

        // --------------------------------------------------------------------
        // AttributeType 2.5.21.4 
        // --------------------------------------------------------------------

        attributeType = newAttributeType( "2.5.21.4", registries );
        attributeType.setDescription( "RFC2252: matching rules" );
        attributeType.setCanUserModify( ! false );
        attributeType.setSingleValue( false );
        attributeType.setCollective( false );
        attributeType.setObsolete( false );
        attributeType.setLength( 0 );
        attributeType.setUsage( UsageEnum.getUsage( "DIRECTORY_OPERATION" ) );
        attributeType.setEqualityId( "objectIdentifierFirstComponentMatch" );
        attributeType.setSyntaxId( "1.3.6.1.4.1.1466.115.121.1.30" );

        names.clear();
        names.add( "matchingRules" );
        attributeType.setNames( names.toArray( EMPTY ) );
        cb.schemaObjectProduced( this, "2.5.21.4", attributeType );

        // --------------------------------------------------------------------
        // AttributeType 2.5.21.5 
        // --------------------------------------------------------------------

        attributeType = newAttributeType( "2.5.21.5", registries );
        attributeType.setDescription( "RFC2252: attribute types" );
        attributeType.setCanUserModify( ! false );
        attributeType.setSingleValue( false );
        attributeType.setCollective( false );
        attributeType.setObsolete( false );
        attributeType.setLength( 0 );
        attributeType.setUsage( UsageEnum.getUsage( "DIRECTORY_OPERATION" ) );
        attributeType.setEqualityId( "objectIdentifierFirstComponentMatch" );
        attributeType.setSyntaxId( "1.3.6.1.4.1.1466.115.121.1.3" );

        names.clear();
        names.add( "attributeTypes" );
        attributeType.setNames( names.toArray( EMPTY ) );
        cb.schemaObjectProduced( this, "2.5.21.5", attributeType );

        // --------------------------------------------------------------------
        // AttributeType 2.5.21.6 
        // --------------------------------------------------------------------

        attributeType = newAttributeType( "2.5.21.6", registries );
        attributeType.setDescription( "RFC2252: object classes" );
        attributeType.setCanUserModify( ! false );
        attributeType.setSingleValue( false );
        attributeType.setCollective( false );
        attributeType.setObsolete( false );
        attributeType.setLength( 0 );
        attributeType.setUsage( UsageEnum.getUsage( "DIRECTORY_OPERATION" ) );
        attributeType.setEqualityId( "objectIdentifierFirstComponentMatch" );
        attributeType.setSyntaxId( "1.3.6.1.4.1.1466.115.121.1.37" );

        names.clear();
        names.add( "objectClasses" );
        attributeType.setNames( names.toArray( EMPTY ) );
        cb.schemaObjectProduced( this, "2.5.21.6", attributeType );

        // --------------------------------------------------------------------
        // AttributeType 2.5.21.7 
        // --------------------------------------------------------------------

        attributeType = newAttributeType( "2.5.21.7", registries );
        attributeType.setDescription( "RFC2252: name forms " );
        attributeType.setCanUserModify( ! false );
        attributeType.setSingleValue( false );
        attributeType.setCollective( false );
        attributeType.setObsolete( false );
        attributeType.setLength( 0 );
        attributeType.setUsage( UsageEnum.getUsage( "DIRECTORY_OPERATION" ) );
        attributeType.setEqualityId( "objectIdentifierFirstComponentMatch" );
        attributeType.setSyntaxId( "1.3.6.1.4.1.1466.115.121.1.35" );

        names.clear();
        names.add( "nameForms" );
        attributeType.setNames( names.toArray( EMPTY ) );
        cb.schemaObjectProduced( this, "2.5.21.7", attributeType );

        // --------------------------------------------------------------------
        // AttributeType 2.5.21.8 
        // --------------------------------------------------------------------

        attributeType = newAttributeType( "2.5.21.8", registries );
        attributeType.setDescription( "RFC2252: matching rule uses" );
        attributeType.setCanUserModify( ! false );
        attributeType.setSingleValue( false );
        attributeType.setCollective( false );
        attributeType.setObsolete( false );
        attributeType.setLength( 0 );
        attributeType.setUsage( UsageEnum.getUsage( "DIRECTORY_OPERATION" ) );
        attributeType.setEqualityId( "objectIdentifierFirstComponentMatch" );
        attributeType.setSyntaxId( "1.3.6.1.4.1.1466.115.121.1.31" );

        names.clear();
        names.add( "matchingRuleUse" );
        attributeType.setNames( names.toArray( EMPTY ) );
        cb.schemaObjectProduced( this, "2.5.21.8", attributeType );

        // --------------------------------------------------------------------
        // AttributeType 1.3.6.1.4.1.1466.101.120.16 
        // --------------------------------------------------------------------

        attributeType = newAttributeType( "1.3.6.1.4.1.1466.101.120.16", registries );
        attributeType.setDescription( "RFC2252: LDAP syntaxes" );
        attributeType.setCanUserModify( ! false );
        attributeType.setSingleValue( false );
        attributeType.setCollective( false );
        attributeType.setObsolete( false );
        attributeType.setLength( 0 );
        attributeType.setUsage( UsageEnum.getUsage( "DIRECTORY_OPERATION" ) );
        attributeType.setEqualityId( "objectIdentifierFirstComponentMatch" );
        attributeType.setSyntaxId( "1.3.6.1.4.1.1466.115.121.1.54" );

        names.clear();
        names.add( "ldapSyntaxes" );
        attributeType.setNames( names.toArray( EMPTY ) );
        cb.schemaObjectProduced( this, "1.3.6.1.4.1.1466.101.120.16", attributeType );

        // --------------------------------------------------------------------
        // AttributeType 2.5.4.1 
        // --------------------------------------------------------------------

        attributeType = newAttributeType( "2.5.4.1", registries );
        attributeType.setDescription( "RFC2256: name of aliased object" );
        attributeType.setCanUserModify( ! false );
        attributeType.setSingleValue( true );
        attributeType.setCollective( false );
        attributeType.setObsolete( false );
        attributeType.setLength( 0 );
        attributeType.setUsage( UsageEnum.getUsage( "USER_APPLICATIONS" ) );
        attributeType.setEqualityId( "distinguishedNameMatch" );
        attributeType.setSyntaxId( "1.3.6.1.4.1.1466.115.121.1.12" );

        names.clear();
        names.add( "aliasedObjectName" );
        names.add( "aliasedEntryName" );
        attributeType.setNames( names.toArray( EMPTY ) );
        cb.schemaObjectProduced( this, "2.5.4.1", attributeType );

        // --------------------------------------------------------------------
        // AttributeType 2.16.840.1.113730.3.1.34 
        // --------------------------------------------------------------------

        attributeType = newAttributeType( "2.16.840.1.113730.3.1.34", registries );
        attributeType.setDescription( "namedref: subordinate referral URL" );
        attributeType.setCanUserModify( ! false );
        attributeType.setSingleValue( false );
        attributeType.setCollective( false );
        attributeType.setObsolete( false );
        attributeType.setLength( 0 );
        attributeType.setUsage( UsageEnum.getUsage( "DISTRIBUTED_OPERATION" ) );
        attributeType.setEqualityId( "caseExactMatch" );
        attributeType.setSyntaxId( "1.3.6.1.4.1.1466.115.121.1.15" );

        names.clear();
        names.add( "ref" );
        attributeType.setNames( names.toArray( EMPTY ) );
        cb.schemaObjectProduced( this, "2.16.840.1.113730.3.1.34", attributeType );

        // --------------------------------------------------------------------
        // AttributeType 1.3.6.1.4.1.1466.101.119.3 
        // --------------------------------------------------------------------

        attributeType = newAttributeType( "1.3.6.1.4.1.1466.101.119.3", registries );
        attributeType.setDescription( "RFC2589: entry time-to-live" );
        attributeType.setCanUserModify( ! true );
        attributeType.setSingleValue( true );
        attributeType.setCollective( false );
        attributeType.setObsolete( false );
        attributeType.setLength( 0 );
        attributeType.setUsage( UsageEnum.getUsage( "DSA_OPERATION" ) );
        attributeType.setSyntaxId( "1.3.6.1.4.1.1466.115.121.1.27" );

        names.clear();
        names.add( "entryTtl" );
        attributeType.setNames( names.toArray( EMPTY ) );
        cb.schemaObjectProduced( this, "1.3.6.1.4.1.1466.101.119.3", attributeType );

        // --------------------------------------------------------------------
        // AttributeType 1.3.6.1.4.1.1466.101.119.4 
        // --------------------------------------------------------------------

        attributeType = newAttributeType( "1.3.6.1.4.1.1466.101.119.4", registries );
        attributeType.setDescription( "RFC2589: dynamic subtrees" );
        attributeType.setCanUserModify( ! true );
        attributeType.setSingleValue( false );
        attributeType.setCollective( false );
        attributeType.setObsolete( false );
        attributeType.setLength( 0 );
        attributeType.setUsage( UsageEnum.getUsage( "DSA_OPERATION" ) );
        attributeType.setSyntaxId( "1.3.6.1.4.1.1466.115.121.1.12" );

        names.clear();
        names.add( "dynamicSubtrees" );
        attributeType.setNames( names.toArray( EMPTY ) );
        cb.schemaObjectProduced( this, "1.3.6.1.4.1.1466.101.119.4", attributeType );

        // --------------------------------------------------------------------
        // AttributeType 2.5.4.49 
        // --------------------------------------------------------------------

        attributeType = newAttributeType( "2.5.4.49", registries );
        attributeType.setDescription( "RFC2256: common supertype of DN attributes" );
        attributeType.setCanUserModify( ! false );
        attributeType.setSingleValue( false );
        attributeType.setCollective( false );
        attributeType.setObsolete( false );
        attributeType.setLength( 0 );
        attributeType.setUsage( UsageEnum.getUsage( "USER_APPLICATIONS" ) );
        attributeType.setEqualityId( "distinguishedNameMatch" );
        attributeType.setSyntaxId( "1.3.6.1.4.1.1466.115.121.1.12" );

        names.clear();
        names.add( "distinguishedName" );
        attributeType.setNames( names.toArray( EMPTY ) );
        cb.schemaObjectProduced( this, "2.5.4.49", attributeType );

        // --------------------------------------------------------------------
        // AttributeType 2.5.4.41 
        // --------------------------------------------------------------------

        attributeType = newAttributeType( "2.5.4.41", registries );
        attributeType.setDescription( "RFC2256: common supertype of name attributes" );
        attributeType.setCanUserModify( ! false );
        attributeType.setSingleValue( false );
        attributeType.setCollective( false );
        attributeType.setObsolete( false );
        attributeType.setLength( 32768 );
        attributeType.setUsage( UsageEnum.getUsage( "USER_APPLICATIONS" ) );
        attributeType.setEqualityId( "caseIgnoreMatch" );
        attributeType.setSubstrId( "caseIgnoreSubstringsMatch" );
        attributeType.setSyntaxId( "1.3.6.1.4.1.1466.115.121.1.15" );

        names.clear();
        names.add( "name" );
        attributeType.setNames( names.toArray( EMPTY ) );
        cb.schemaObjectProduced( this, "2.5.4.41", attributeType );

        // --------------------------------------------------------------------
        // AttributeType 2.5.4.3 
        // --------------------------------------------------------------------

        attributeType = newAttributeType( "2.5.4.3", registries );
        attributeType.setDescription( "RFC2256: common name(s) for which the entity is known by" );
        attributeType.setCanUserModify( ! false );
        attributeType.setSingleValue( false );
        attributeType.setCollective( false );
        attributeType.setObsolete( false );
        attributeType.setLength( 0 );
        attributeType.setUsage( UsageEnum.getUsage( "USER_APPLICATIONS" ) );
        attributeType.setSuperiorId( "name" );

        names.clear();
        names.add( "cn" );
        names.add( "commonName" );
        attributeType.setNames( names.toArray( EMPTY ) );
        cb.schemaObjectProduced( this, "2.5.4.3", attributeType );

        // --------------------------------------------------------------------
        // AttributeType 2.5.4.35 
        // --------------------------------------------------------------------

        attributeType = newAttributeType( "2.5.4.35", registries );
        attributeType.setDescription( "RFC2256/2307: password of user" );
        attributeType.setCanUserModify( ! false );
        attributeType.setSingleValue( false );
        attributeType.setCollective( false );
        attributeType.setObsolete( false );
        attributeType.setLength( 128 );
        attributeType.setUsage( UsageEnum.getUsage( "USER_APPLICATIONS" ) );
        attributeType.setEqualityId( "octetStringMatch" );
        attributeType.setSyntaxId( "1.3.6.1.4.1.1466.115.121.1.40" );

        names.clear();
        names.add( "userPassword" );
        attributeType.setNames( names.toArray( EMPTY ) );
        cb.schemaObjectProduced( this, "2.5.4.35", attributeType );

        // --------------------------------------------------------------------
        // AttributeType 1.3.6.1.4.1.250.1.57 
        // --------------------------------------------------------------------

        attributeType = newAttributeType( "1.3.6.1.4.1.250.1.57", registries );
        attributeType.setDescription( "RFC2079: Uniform Resource Identifier with optional label" );
        attributeType.setCanUserModify( ! false );
        attributeType.setSingleValue( false );
        attributeType.setCollective( false );
        attributeType.setObsolete( false );
        attributeType.setLength( 0 );
        attributeType.setUsage( UsageEnum.getUsage( "USER_APPLICATIONS" ) );
        attributeType.setEqualityId( "caseExactMatch" );
        attributeType.setSyntaxId( "1.3.6.1.4.1.1466.115.121.1.15" );

        names.clear();
        names.add( "labeledURI" );
        attributeType.setNames( names.toArray( EMPTY ) );
        cb.schemaObjectProduced( this, "1.3.6.1.4.1.250.1.57", attributeType );

        // --------------------------------------------------------------------
        // AttributeType 1.3.6.1.4.1.4203.1.3.5 
        // --------------------------------------------------------------------

        attributeType = newAttributeType( "1.3.6.1.4.1.4203.1.3.5", registries );
        attributeType.setCanUserModify( ! false );
        attributeType.setSingleValue( false );
        attributeType.setCollective( false );
        attributeType.setObsolete( false );
        attributeType.setLength( 0 );
        attributeType.setUsage( UsageEnum.getUsage( "DSA_OPERATION" ) );
        attributeType.setEqualityId( "objectIdentifierMatch" );
        attributeType.setSyntaxId( "1.3.6.1.4.1.1466.115.121.1.38" );

        names.clear();
        names.add( "supportedFeatures" );
        attributeType.setNames( names.toArray( EMPTY ) );
        cb.schemaObjectProduced( this, "1.3.6.1.4.1.4203.1.3.5", attributeType );
    }
}
