/*
 * Decompiled with CFR 0.152.
 */
package org.apache.directory.server.ldap.handlers.bind.ntlm;

import javax.naming.InvalidNameException;
import javax.security.sasl.SaslException;
import org.apache.directory.api.ldap.model.constants.AuthenticationLevel;
import org.apache.directory.api.ldap.model.message.BindRequest;
import org.apache.directory.api.ldap.model.name.Dn;
import org.apache.directory.api.util.Strings;
import org.apache.directory.server.core.api.CoreSession;
import org.apache.directory.server.core.api.LdapPrincipal;
import org.apache.directory.server.core.api.interceptor.context.BindOperationContext;
import org.apache.directory.server.i18n.I18n;
import org.apache.directory.server.ldap.LdapSession;
import org.apache.directory.server.ldap.handlers.bind.AbstractSaslServer;
import org.apache.directory.server.ldap.handlers.bind.ntlm.NtlmProvider;

public class NtlmSaslServer
extends AbstractSaslServer {
    private NegotiationState state = NegotiationState.INITIALIZED;
    private final NtlmProvider provider;

    public NtlmSaslServer(NtlmProvider provider, BindRequest bindRequest, LdapSession ldapSession, CoreSession adminSession) {
        super(ldapSession, adminSession, bindRequest);
        this.provider = provider;
    }

    @Override
    public String getMechanismName() {
        return "NTLM";
    }

    protected void responseRecieved() {
        switch (this.state) {
            case INITIALIZED: {
                this.state = NegotiationState.TYPE_1_RECEIVED;
                break;
            }
            case TYPE_1_RECEIVED: {
                throw new IllegalStateException(I18n.err((I18n)I18n.ERR_660, (Object[])new Object[0]));
            }
            case TYPE_2_SENT: {
                this.state = NegotiationState.TYPE_3_RECEIVED;
                break;
            }
            case TYPE_3_RECEIVED: {
                throw new IllegalStateException(I18n.err((I18n)I18n.ERR_661, (Object[])new Object[0]));
            }
            case COMPLETED: {
                throw new IllegalStateException(I18n.err((I18n)I18n.ERR_662, (Object[])new Object[0]));
            }
        }
    }

    protected void responseSent() {
        switch (this.state) {
            case INITIALIZED: {
                throw new IllegalStateException(I18n.err((I18n)I18n.ERR_663, (Object[])new Object[0]));
            }
            case TYPE_1_RECEIVED: {
                this.state = NegotiationState.TYPE_2_SENT;
                break;
            }
            case TYPE_2_SENT: {
                throw new IllegalStateException(I18n.err((I18n)I18n.ERR_664, (Object[])new Object[0]));
            }
            case TYPE_3_RECEIVED: {
                this.state = NegotiationState.COMPLETED;
                break;
            }
            case COMPLETED: {
                throw new IllegalStateException(I18n.err((I18n)I18n.ERR_662, (Object[])new Object[0]));
            }
        }
    }

    @Override
    public byte[] evaluateResponse(byte[] response) throws SaslException {
        if (response == null) {
            throw new IllegalArgumentException(I18n.err((I18n)I18n.ERR_666, (Object[])new Object[0]));
        }
        if (response.length == 0) {
            throw new IllegalArgumentException(I18n.err((I18n)I18n.ERR_667, (Object[])new Object[0]));
        }
        this.responseRecieved();
        byte[] retval = null;
        switch (this.state) {
            case TYPE_1_RECEIVED: {
                try {
                    retval = this.provider.generateChallenge(this.getLdapSession().getIoSession(), response);
                    break;
                }
                catch (Exception e) {
                    throw new SaslException(I18n.err((I18n)I18n.ERR_668, (Object[])new Object[0]), e);
                }
            }
            case TYPE_3_RECEIVED: {
                boolean result;
                try {
                    result = this.provider.authenticate(this.getLdapSession().getIoSession(), response);
                    Dn dn = this.getBindRequest().getDn();
                    dn.apply(this.getLdapSession().getLdapServer().getDirectoryService().getSchemaManager());
                    LdapPrincipal ldapPrincipal = new LdapPrincipal(this.getAdminSession().getDirectoryService().getSchemaManager(), dn, AuthenticationLevel.STRONG);
                    this.getLdapSession().putSaslProperty("saslAuthentUser", ldapPrincipal);
                    this.getLdapSession().putSaslProperty("java.naming.security.principal", this.getBindRequest().getName().toString());
                }
                catch (Exception e) {
                    throw new SaslException(I18n.err((I18n)I18n.ERR_669, (Object[])new Object[0]), e);
                }
                if (result) break;
                throw new SaslException(I18n.err((I18n)I18n.ERR_670, (Object[])new Object[0]));
            }
        }
        this.responseSent();
        return retval;
    }

    private CoreSession authenticate(String user, String password) throws InvalidNameException, Exception {
        BindOperationContext bindContext = new BindOperationContext(this.getLdapSession().getCoreSession());
        bindContext.setDn(new Dn(new String[]{user}));
        bindContext.setCredentials(Strings.getBytesUtf8((String)password));
        this.getAdminSession().getDirectoryService().getOperationManager().bind(bindContext);
        return bindContext.getSession();
    }

    @Override
    public boolean isComplete() {
        return this.state == NegotiationState.COMPLETED;
    }

    static enum NegotiationState {
        INITIALIZED,
        TYPE_1_RECEIVED,
        TYPE_2_SENT,
        TYPE_3_RECEIVED,
        COMPLETED;

    }
}

