/*
 * Decompiled with CFR 0.152.
 */
package org.apache.directory.server.ldap.support.bind;

import java.util.Map;
import javax.security.sasl.Sasl;
import javax.security.sasl.SaslServer;
import org.apache.directory.server.core.DirectoryService;
import org.apache.directory.server.ldap.support.bind.DigestMd5CallbackHandler;
import org.apache.directory.server.ldap.support.bind.MechanismHandler;
import org.apache.directory.shared.ldap.message.BindRequest;
import org.apache.mina.common.IoSession;

public class DigestMd5MechanismHandler
implements MechanismHandler {
    private final DirectoryService directoryService;

    public DigestMd5MechanismHandler(DirectoryService directoryService) {
        this.directoryService = directoryService;
    }

    public SaslServer handleMechanism(IoSession session, BindRequest bindRequest) throws Exception {
        SaslServer ss;
        if (session.containsAttribute("saslContext")) {
            ss = (SaslServer)session.getAttribute("saslContext");
        } else {
            String saslHost = (String)session.getAttribute("saslHost");
            Map saslProps = (Map)session.getAttribute("saslProps");
            DigestMd5CallbackHandler callbackHandler = new DigestMd5CallbackHandler(this.directoryService, session, bindRequest);
            ss = Sasl.createSaslServer("DIGEST-MD5", "ldap", saslHost, saslProps, callbackHandler);
            session.setAttribute("saslContext", (Object)ss);
        }
        return ss;
    }
}

