/*
 * Decompiled with CFR 0.152.
 */
package org.apache.directory.server.ldap.support.bind;

import java.util.Hashtable;
import javax.naming.ldap.LdapContext;
import javax.security.sasl.AuthorizeCallback;
import org.apache.directory.server.core.DirectoryService;
import org.apache.directory.server.ldap.support.bind.AbstractSaslCallbackHandler;
import org.apache.directory.server.ldap.support.bind.GetBindDn;
import org.apache.directory.shared.ldap.message.BindRequest;
import org.apache.mina.common.IoSession;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CramMd5CallbackHandler
extends AbstractSaslCallbackHandler {
    private static final Logger LOG = LoggerFactory.getLogger(CramMd5CallbackHandler.class);
    private IoSession session;
    private BindRequest bindRequest;
    private String bindDn;
    private String userPassword;

    public CramMd5CallbackHandler(DirectoryService directoryService, IoSession session, BindRequest bindRequest) {
        super(directoryService);
        this.session = session;
        this.bindRequest = bindRequest;
    }

    protected String lookupPassword(String username, String realm) {
        Hashtable<String, Object> env = this.getEnvironment(this.session);
        LdapContext ctx = this.getContext(this.session, this.bindRequest, env);
        GetBindDn getDn = new GetBindDn(username);
        getDn.execute(ctx, null);
        this.bindDn = getDn.getBindDn();
        this.userPassword = getDn.getUserPassword();
        return this.userPassword;
    }

    protected void authorize(AuthorizeCallback authorizeCB) {
        if (LOG.isDebugEnabled()) {
            LOG.debug("Converted username " + this.getUsername() + " to DN " + this.bindDn + " with password " + this.userPassword);
        }
        this.session.setAttribute("java.naming.security.principal", (Object)this.bindDn);
        authorizeCB.setAuthorizedID(this.bindDn);
        authorizeCB.setAuthorized(true);
    }
}

