/*
 * Decompiled with CFR 0.152.
 */
package org.apache.directory.server.ldap.support;

import javax.naming.NamingException;
import javax.naming.ldap.LdapContext;
import org.apache.directory.server.core.jndi.ServerLdapContext;
import org.apache.directory.server.ldap.support.UnbindHandler;
import org.apache.directory.shared.ldap.message.UnbindRequest;
import org.apache.mina.common.IoSession;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DefaultUnbindHandler
extends UnbindHandler {
    private static final Logger LOG = LoggerFactory.getLogger(UnbindHandler.class);

    public void unbindMessageReceived(IoSession session, UnbindRequest request) throws Exception {
        try {
            LdapContext ctx = this.getSessionRegistry().getLdapContext(session, null, false);
            if (ctx != null) {
                if (ctx instanceof ServerLdapContext && ((ServerLdapContext)ctx).getService().isStarted()) {
                    ((ServerLdapContext)ctx).ldapUnbind();
                }
                ctx.close();
            }
            this.getSessionRegistry().terminateSession(session);
            this.getSessionRegistry().remove(session);
        }
        catch (NamingException e) {
            LOG.error("failed to unbind session properly", (Throwable)e);
        }
    }
}

