/*
 * Decompiled with CFR 0.152.
 */
package org.apache.directory.server.ldap.support;

import java.util.Collections;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import javax.naming.NamingException;
import javax.naming.directory.DirContext;
import javax.naming.ldap.Control;
import javax.naming.ldap.InitialLdapContext;
import javax.naming.ldap.LdapContext;
import javax.naming.spi.InitialContextFactory;
import javax.security.auth.Subject;
import javax.security.auth.kerberos.KerberosKey;
import javax.security.auth.kerberos.KerberosPrincipal;
import javax.security.sasl.SaslException;
import javax.security.sasl.SaslServer;
import org.apache.directory.server.core.DirectoryService;
import org.apache.directory.server.core.authn.LdapPrincipal;
import org.apache.directory.server.core.jndi.ServerLdapContext;
import org.apache.directory.server.kerberos.shared.messages.value.EncryptionKey;
import org.apache.directory.server.kerberos.shared.store.PrincipalStoreEntry;
import org.apache.directory.server.kerberos.shared.store.operations.GetPrincipal;
import org.apache.directory.server.ldap.LdapServer;
import org.apache.directory.server.ldap.SessionRegistry;
import org.apache.directory.server.ldap.support.BindHandler;
import org.apache.directory.server.ldap.support.bind.CramMd5MechanismHandler;
import org.apache.directory.server.ldap.support.bind.DigestMd5MechanismHandler;
import org.apache.directory.server.ldap.support.bind.GssapiMechanismHandler;
import org.apache.directory.server.ldap.support.bind.MechanismHandler;
import org.apache.directory.server.ldap.support.bind.SaslFilter;
import org.apache.directory.server.protocol.shared.ServiceConfigurationException;
import org.apache.directory.shared.ldap.constants.AuthenticationLevel;
import org.apache.directory.shared.ldap.exception.LdapException;
import org.apache.directory.shared.ldap.message.BindRequest;
import org.apache.directory.shared.ldap.message.BindResponse;
import org.apache.directory.shared.ldap.message.LdapResult;
import org.apache.directory.shared.ldap.message.Message;
import org.apache.directory.shared.ldap.message.MessageTypeEnum;
import org.apache.directory.shared.ldap.message.MutableControl;
import org.apache.directory.shared.ldap.message.ResultCodeEnum;
import org.apache.directory.shared.ldap.name.LdapDN;
import org.apache.directory.shared.ldap.util.ExceptionUtils;
import org.apache.mina.common.IoFilter;
import org.apache.mina.common.IoFilterChain;
import org.apache.mina.common.IoSession;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DefaultBindHandler
extends BindHandler {
    private static final Logger LOG = LoggerFactory.getLogger(BindHandler.class);
    private static final MutableControl[] EMPTY_CONTROL = new MutableControl[0];
    private DirContext ctx;
    private final Map<String, MechanismHandler> handlers;
    private final SessionRegistry registry;

    public DefaultBindHandler(DirectoryService directoryService, SessionRegistry registry) {
        HashMap<String, MechanismHandler> map = new HashMap<String, MechanismHandler>();
        map.put("CRAM-MD5", new CramMd5MechanismHandler(directoryService));
        map.put("DIGEST-MD5", new DigestMd5MechanismHandler(directoryService));
        map.put("GSSAPI", new GssapiMechanismHandler(directoryService));
        this.handlers = Collections.unmodifiableMap(map);
        this.registry = registry;
    }

    @Override
    public void setDirectoryService(DirectoryService directoryService) {
    }

    private Hashtable<String, Object> getEnvironment(BindRequest bindRequest, String authenticationLevel) {
        LdapDN principal = bindRequest.getName();
        byte[] credentials = bindRequest.getCredentials();
        if (LOG.isDebugEnabled()) {
            LOG.debug("{} {}", (Object)"java.naming.security.principal", (Object)principal);
            LOG.debug("{} {}", (Object)"java.naming.security.credentials", (Object)credentials);
            LOG.debug("{} {}", (Object)"java.naming.security.authentication", (Object)authenticationLevel);
        }
        Hashtable<String, Object> env = this.getSessionRegistry().getEnvironmentByCopy();
        env.put("java.naming.security.principal", principal);
        if (credentials != null) {
            env.put("java.naming.security.credentials", credentials);
        }
        env.put("java.naming.security.authentication", authenticationLevel);
        if (bindRequest.getControls().containsKey("2.16.840.1.113730.3.4.2")) {
            env.put("java.naming.referral", "ignore");
        } else {
            env.put("java.naming.referral", "throw");
        }
        return env;
    }

    private LdapContext getLdapContext(IoSession session, BindRequest bindRequest, Hashtable<String, Object> env) {
        LdapContext ctx;
        LdapResult result = bindRequest.getResultResponse().getLdapResult();
        try {
            if (env.containsKey("server.use.factory.instance")) {
                InitialContextFactory factory = (InitialContextFactory)env.get("server.use.factory.instance");
                if (factory == null) {
                    LOG.error("The property 'server.use.factory.instance'  was set in env but was null");
                    throw new NullPointerException("server.use.factory.instance was set in env but was null");
                }
                ctx = (LdapContext)factory.getInitialContext(env);
            } else {
                MutableControl[] connCtls = bindRequest.getControls().values().toArray(EMPTY_CONTROL);
                ctx = new InitialLdapContext(env, (Control[])connCtls);
            }
        }
        catch (NamingException e) {
            ResultCodeEnum code;
            if (e instanceof LdapException) {
                code = ((LdapException)e).getResultCode();
                result.setResultCode(code);
            } else {
                code = ResultCodeEnum.getBestEstimate((Throwable)e, (MessageTypeEnum)bindRequest.getType());
                result.setResultCode(code);
            }
            String msg = "Bind failed: " + e.getMessage();
            if (LOG.isDebugEnabled()) {
                msg = msg + ":\n" + ExceptionUtils.getStackTrace((Throwable)e);
                msg = msg + "\n\nBindRequest = \n" + bindRequest.toString();
                LOG.debug(msg);
            }
            if (e.getResolvedName() != null && (code == ResultCodeEnum.NO_SUCH_OBJECT || code == ResultCodeEnum.ALIAS_PROBLEM || code == ResultCodeEnum.INVALID_DN_SYNTAX || code == ResultCodeEnum.ALIAS_DEREFERENCING_PROBLEM)) {
                result.setMatchedDn((LdapDN)e.getResolvedName());
            }
            result.setErrorMessage(msg);
            session.write((Object)bindRequest.getResultResponse());
            ctx = null;
        }
        return ctx;
    }

    private void handleSimpleAuth(IoSession session, BindRequest bindRequest) throws NamingException {
        LdapServer ldapServer = (LdapServer)((Object)session.getAttribute(LdapServer.class.toString()));
        Set<String> supportedMechanisms = ldapServer.getSupportedMechanisms();
        LdapResult bindResult = bindRequest.getResultResponse().getLdapResult();
        if (!supportedMechanisms.contains("SIMPLE")) {
            LOG.error("Bind error : SIMPLE authentication not supported. Please check the server.xml configuration file (supportedMechanisms field)");
            bindResult.setResultCode(ResultCodeEnum.STRONG_AUTH_REQUIRED);
            bindResult.setErrorMessage("Simple binds are disabled.");
            session.write((Object)bindRequest.getResultResponse());
            return;
        }
        Hashtable<String, Object> env = this.getEnvironment(bindRequest, AuthenticationLevel.SIMPLE.toString());
        LdapContext ctx = this.getLdapContext(session, bindRequest, env);
        if (ctx != null) {
            ServerLdapContext newCtx = (ServerLdapContext)ctx.lookup("");
            this.setRequestControls((LdapContext)newCtx, (Message)bindRequest);
            this.getSessionRegistry().setLdapContext(session, (LdapContext)newCtx);
            bindResult.setResultCode(ResultCodeEnum.SUCCESS);
            BindResponse response = (BindResponse)bindRequest.getResultResponse();
            response.addAll(newCtx.getResponseControls());
            session.write((Object)response);
            LOG.debug("Returned SUCCESS message.");
        }
    }

    public void handleSaslAuth(IoSession session, Object message) throws Exception {
        LdapServer ldapServer = (LdapServer)((Object)session.getAttribute(LdapServer.class.toString()));
        HashMap<String, String> saslProps = new HashMap<String, String>();
        saslProps.put("javax.security.sasl.qop", ldapServer.getSaslQopString());
        saslProps.put("com.sun.security.sasl.digest.realm", this.getActiveRealms(ldapServer));
        session.setAttribute("saslProps", saslProps);
        session.setAttribute("saslHost", (Object)ldapServer.getSaslHost());
        session.setAttribute("baseDn", (Object)ldapServer.getSearchBaseDn());
        Set<String> activeMechanisms = ldapServer.getSupportedMechanisms();
        if (activeMechanisms.contains("GSSAPI")) {
            try {
                Subject saslSubject = this.getSubject(ldapServer);
                session.setAttribute("saslSubject", (Object)saslSubject);
            }
            catch (ServiceConfigurationException sce) {
                activeMechanisms.remove("GSSAPI");
                LOG.warn(sce.getMessage());
            }
        }
        BindRequest bindRequest = (BindRequest)message;
        if (!ldapServer.getSupportedMechanisms().contains(bindRequest.getSaslMechanism())) {
            LOG.error("Bind error : {} mechanism not supported. Please check the server.xml configuration file (supportedMechanisms field)", (Object)bindRequest.getSaslMechanism());
            LdapResult bindResult = bindRequest.getResultResponse().getLdapResult();
            bindResult.setResultCode(ResultCodeEnum.AUTH_METHOD_NOT_SUPPORTED);
            bindResult.setErrorMessage(bindRequest.getSaslMechanism() + " is not a supported mechanism.");
            session.write((Object)bindRequest.getResultResponse());
            return;
        }
        this.handleSasl(session, bindRequest);
    }

    public void handleSasl(IoSession session, BindRequest bindRequest) throws Exception {
        String sessionMechanism = bindRequest.getSaslMechanism();
        if (sessionMechanism.equals("SIMPLE")) {
            session.setAttribute("java.naming.security.principal", (Object)bindRequest.getName());
            session.setAttribute("java.naming.security.credentials", (Object)bindRequest.getCredentials());
            this.getLdapContext(session, bindRequest);
        } else {
            MechanismHandler mechanismHandler = this.handlers.get(sessionMechanism);
            if (mechanismHandler == null) {
                LOG.error("Handler unavailable for " + sessionMechanism);
                throw new IllegalArgumentException("Handler unavailable for " + sessionMechanism);
            }
            SaslServer ss = mechanismHandler.handleMechanism(session, bindRequest);
            LdapResult result = bindRequest.getResultResponse().getLdapResult();
            if (!ss.isComplete()) {
                try {
                    if (bindRequest.getCredentials() == null) {
                        bindRequest.setCredentials(new byte[0]);
                    }
                    byte[] tokenBytes = ss.evaluateResponse(bindRequest.getCredentials());
                    if (ss.isComplete()) {
                        session.setAttribute("saslCreds", (Object)tokenBytes);
                        this.getLdapContext(session, bindRequest);
                    } else {
                        LOG.info("Continuation token had length " + tokenBytes.length);
                        result.setResultCode(ResultCodeEnum.SASL_BIND_IN_PROGRESS);
                        BindResponse resp = (BindResponse)bindRequest.getResultResponse();
                        resp.setServerSaslCreds(tokenBytes);
                        session.write((Object)resp);
                        LOG.debug("Returning final authentication data to client to complete context.");
                    }
                }
                catch (SaslException se) {
                    LOG.error(se.getMessage());
                    result.setResultCode(ResultCodeEnum.INVALID_CREDENTIALS);
                    result.setErrorMessage(se.getMessage());
                    session.write((Object)bindRequest.getResultResponse());
                }
            }
        }
    }

    private String getActiveRealms(LdapServer ldapServer) {
        StringBuilder realms = new StringBuilder();
        boolean isFirst = true;
        for (String realm : ldapServer.getSaslRealms()) {
            if (isFirst) {
                isFirst = false;
            } else {
                realms.append(' ');
            }
            realms.append(realm);
        }
        return realms.toString();
    }

    private Subject getSubject(LdapServer ldapServer) throws ServiceConfigurationException {
        PrincipalStoreEntry entry;
        String servicePrincipalName = ldapServer.getSaslPrincipal();
        KerberosPrincipal servicePrincipal = new KerberosPrincipal(servicePrincipalName);
        GetPrincipal getPrincipal = new GetPrincipal(servicePrincipal);
        try {
            entry = this.findPrincipal(ldapServer, getPrincipal);
        }
        catch (Exception e) {
            String message = "Service principal " + servicePrincipalName + " not found at search base DN " + ldapServer.getSearchBaseDn() + ".";
            throw new ServiceConfigurationException(message, (Throwable)e);
        }
        if (entry == null) {
            String message = "Service principal " + servicePrincipalName + " not found at search base DN " + ldapServer.getSearchBaseDn() + ".";
            throw new ServiceConfigurationException(message);
        }
        Subject subject = new Subject();
        Iterator it = entry.getKeyMap().keySet().iterator();
        while (it.hasNext()) {
            EncryptionKey key = (EncryptionKey)entry.getKeyMap().get(it.next());
            byte[] keyBytes = key.getKeyValue();
            int type = key.getKeyType().getOrdinal();
            int kvno = key.getKeyVersion();
            KerberosKey serviceKey = new KerberosKey(servicePrincipal, keyBytes, type, kvno);
            subject.getPrivateCredentials().add(serviceKey);
        }
        return subject;
    }

    private PrincipalStoreEntry findPrincipal(LdapServer ldapServer, GetPrincipal getPrincipal) throws Exception {
        if (this.ctx == null) {
            try {
                LdapPrincipal principal = new LdapPrincipal(new LdapDN("uid=admin,ou=system"), AuthenticationLevel.SIMPLE);
                this.ctx = ldapServer.getDirectoryService().getJndiContext(principal, ldapServer.getSearchBaseDn());
            }
            catch (NamingException ne) {
                String message = "Failed to get initial context " + ldapServer.getSearchBaseDn();
                throw new ServiceConfigurationException(message, (Throwable)ne);
            }
        }
        return (PrincipalStoreEntry)getPrincipal.execute(this.ctx, null);
    }

    private Hashtable<String, Object> getEnvironment(IoSession session, BindRequest bindRequest) {
        Object principal = session.getAttribute("java.naming.security.principal");
        Object credentials = session.getAttribute("java.naming.security.credentials");
        String sessionMechanism = bindRequest.getSaslMechanism();
        String authenticationLevel = this.getAuthenticationLevel(sessionMechanism);
        LOG.debug("{} {}", (Object)"java.naming.security.principal", principal);
        LOG.debug("{} {}", (Object)"java.naming.security.credentials", credentials);
        LOG.debug("{} {}", (Object)"java.naming.security.authentication", (Object)authenticationLevel);
        Hashtable<String, Object> env = this.registry.getEnvironmentByCopy();
        env.put("java.naming.security.principal", principal);
        if (credentials != null) {
            env.put("java.naming.security.credentials", credentials);
        }
        env.put("java.naming.security.authentication", authenticationLevel);
        if (bindRequest.getControls().containsKey("2.16.840.1.113730.3.4.2")) {
            env.put("java.naming.referral", "ignore");
        } else {
            env.put("java.naming.referral", "throw");
        }
        return env;
    }

    private void getLdapContext(IoSession session, BindRequest bindRequest) throws Exception {
        Hashtable<String, Object> env = this.getEnvironment(session, bindRequest);
        LdapResult result = bindRequest.getResultResponse().getLdapResult();
        try {
            MutableControl[] connCtls = bindRequest.getControls().values().toArray(EMPTY_CONTROL);
            InitialLdapContext ctx = new InitialLdapContext(env, (Control[])connCtls);
            this.registry.setLdapContext(session, ctx);
            bindRequest.getResultResponse().addAll(ctx.getResponseControls());
            this.returnSuccess(session, bindRequest);
        }
        catch (NamingException e) {
            ResultCodeEnum code;
            if (e instanceof LdapException) {
                code = ((LdapException)e).getResultCode();
                result.setResultCode(code);
            } else {
                code = ResultCodeEnum.getBestEstimate((Throwable)e, (MessageTypeEnum)bindRequest.getType());
                result.setResultCode(code);
            }
            String msg = "Bind failed: " + e.getMessage();
            if (LOG.isDebugEnabled()) {
                msg = msg + ":\n" + ExceptionUtils.getStackTrace((Throwable)e);
                msg = msg + "\n\nBindRequest = \n" + bindRequest.toString();
            }
            if (e.getResolvedName() != null && (code == ResultCodeEnum.NO_SUCH_OBJECT || code == ResultCodeEnum.ALIAS_PROBLEM || code == ResultCodeEnum.INVALID_DN_SYNTAX || code == ResultCodeEnum.ALIAS_DEREFERENCING_PROBLEM)) {
                result.setMatchedDn((LdapDN)e.getResolvedName());
            }
            result.setErrorMessage(msg);
            session.write((Object)bindRequest.getResultResponse());
            Object ctx = null;
        }
    }

    private void returnSuccess(IoSession session, BindRequest bindRequest) throws Exception {
        LdapResult result = bindRequest.getResultResponse().getLdapResult();
        byte[] tokenBytes = (byte[])session.getAttribute("saslCreds");
        result.setResultCode(ResultCodeEnum.SUCCESS);
        BindResponse response = (BindResponse)bindRequest.getResultResponse();
        response.setServerSaslCreds(tokenBytes);
        String sessionMechanism = bindRequest.getSaslMechanism();
        if (sessionMechanism.equals("DIGEST-MD5") || sessionMechanism.equals("GSSAPI")) {
            LOG.debug("Inserting SaslFilter to engage negotiated security layer.");
            IoFilterChain chain = session.getFilterChain();
            if (!chain.contains("SASL")) {
                SaslServer saslContext = (SaslServer)session.getAttribute("saslContext");
                chain.addBefore("codec", "SASL", (IoFilter)new SaslFilter(saslContext));
            }
            session.setAttribute(SaslFilter.DISABLE_SECURITY_LAYER_ONCE, (Object)Boolean.TRUE);
        }
        session.write((Object)response);
        LOG.debug("Returned SUCCESS message.");
    }

    private String getAuthenticationLevel(String sessionMechanism) {
        if (sessionMechanism.equals("SIMPLE")) {
            return AuthenticationLevel.SIMPLE.toString();
        }
        return AuthenticationLevel.STRONG.toString();
    }

    @Override
    protected void bindMessageReceived(IoSession session, BindRequest bindRequest) throws Exception {
        if (LOG.isDebugEnabled()) {
            LOG.debug("User {} is binding", (Object)bindRequest.getName());
            if (bindRequest.isSimple()) {
                LOG.debug("Using simple authentication.");
            } else {
                LOG.debug("Using SASL authentication with mechanism:  {}", (Object)bindRequest.getSaslMechanism());
            }
        }
        if (!bindRequest.getVersion3()) {
            LOG.error("Bind error : Only LDAP v3 is supported.");
            LdapResult bindResult = bindRequest.getResultResponse().getLdapResult();
            bindResult.setResultCode(ResultCodeEnum.PROTOCOL_ERROR);
            bindResult.setErrorMessage("Only LDAP v3 is supported.");
            session.write((Object)bindRequest.getResultResponse());
            return;
        }
        if (bindRequest.isSimple()) {
            this.handleSimpleAuth(session, bindRequest);
        } else {
            this.handleSaslAuth(session, bindRequest);
        }
    }
}

