/*
 * Decompiled with CFR 0.152.
 */
package org.apache.directory.server.ldap;

import java.util.Collections;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.Map;
import javax.naming.NamingException;
import javax.naming.ldap.Control;
import javax.naming.ldap.InitialLdapContext;
import javax.naming.ldap.LdapContext;
import javax.naming.spi.InitialContextFactory;
import org.apache.directory.server.core.jndi.ServerLdapContext;
import org.apache.directory.server.ldap.LdapServer;
import org.apache.directory.shared.ldap.constants.AuthenticationLevel;
import org.apache.directory.shared.ldap.exception.LdapNoPermissionException;
import org.apache.directory.shared.ldap.message.AbandonableRequest;
import org.apache.directory.shared.ldap.message.Request;
import org.apache.mina.common.IoSession;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SessionRegistry {
    private final Map<IoSession, LdapContext> contexts = new HashMap<IoSession, LdapContext>();
    private final Map<IoSession, Map<Integer, Request>> requests = new HashMap<IoSession, Map<Integer, Request>>();
    private Hashtable<String, Object> env;
    private LdapServer ldapServer;

    public SessionRegistry(LdapServer ldapServer, Hashtable<String, Object> env) {
        this.ldapServer = ldapServer;
        if (env == null) {
            this.env = new Hashtable();
            this.env.put("java.naming.provider.url", "");
            this.env.put("java.naming.factory.initial", "org.apache.directory.server.jndi.ServerContextFactory");
        } else {
            this.env = env;
            this.env.put("java.naming.provider.url", "");
        }
    }

    public Hashtable<String, Object> getEnvironmentByCopy() {
        return (Hashtable)this.env.clone();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addOutstandingRequest(IoSession session, Request req) {
        Map<IoSession, Map<Integer, Request>> map = this.requests;
        synchronized (map) {
            Map<Integer, Request> reqmap = this.requests.get(session);
            if (reqmap == null) {
                reqmap = new HashMap<Integer, Request>();
                this.requests.put(session, reqmap);
            }
            reqmap.put(req.getMessageId(), req);
        }
    }

    public Request removeOutstandingRequest(IoSession session, int messageId) {
        return this.removeOutstandingRequest(session, new Integer(messageId));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Request removeOutstandingRequest(IoSession session, Integer id) {
        Map<IoSession, Map<Integer, Request>> map = this.requests;
        synchronized (map) {
            Map<Integer, Request> reqmap = this.requests.get(session);
            if (reqmap == null) {
                return null;
            }
            return reqmap.remove(id);
        }
    }

    public Map<Integer, Request> getOutstandingRequests(IoSession session) {
        Map<Integer, Request> reqmap = this.requests.get(session);
        if (reqmap == null) {
            return Collections.EMPTY_MAP;
        }
        return new HashMap<Integer, Request>(reqmap);
    }

    public Request getOutstandingRequest(IoSession session, int abandonedId) {
        return this.getOutstandingRequest(session, new Integer(abandonedId));
    }

    public Request getOutstandingRequest(IoSession session, Integer id) {
        Map<Integer, Request> reqmap = this.requests.get(session);
        if (reqmap == null) {
            return null;
        }
        return reqmap.get(id);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public IoSession[] getSessions() {
        IoSession[] sessions;
        Map<IoSession, LdapContext> map = this.contexts;
        synchronized (map) {
            sessions = new IoSession[this.contexts.size()];
            sessions = this.contexts.keySet().toArray(sessions);
        }
        return sessions;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public LdapContext getLdapContext(IoSession session, Control[] connCtls, boolean allowAnonymous) throws NamingException {
        ServerLdapContext slc;
        boolean isAnonymousUser;
        LdapContext ctx;
        Map<IoSession, LdapContext> map = this.contexts;
        synchronized (map) {
            ctx = this.contexts.get(session);
        }
        if (ctx == null && allowAnonymous) {
            if (!this.ldapServer.isAllowAnonymousAccess()) {
                throw new LdapNoPermissionException("Anonymous binds have been disabled!");
            }
            if (this.env.containsKey("server.use.factory.instance")) {
                InitialContextFactory factory = (InitialContextFactory)this.env.get("server.use.factory.instance");
                if (factory == null) {
                    throw new NullPointerException("server.use.factory.instance was set in env but was null");
                }
                ctx = (LdapContext)factory.getInitialContext(this.env);
            } else {
                Hashtable cloned = (Hashtable)this.env.clone();
                cloned.put("java.naming.security.authentication", AuthenticationLevel.NONE.toString());
                cloned.remove("java.naming.security.principal");
                cloned.remove("java.naming.security.credentials");
                ctx = new InitialLdapContext(cloned, connCtls);
            }
        } else if (ctx != null && allowAnonymous && (isAnonymousUser = (slc = !(ctx instanceof ServerLdapContext) ? (ServerLdapContext)ctx.lookup("") : (ServerLdapContext)ctx).getPrincipal().getName().trim().equals("")) && !this.ldapServer.isAllowAnonymousAccess()) {
            throw new LdapNoPermissionException("Anonymous binds have been disabled!");
        }
        return ctx;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public LdapContext getLdapContextOnRootDSEAccess(IoSession session, Control[] connCtls) throws NamingException {
        LdapContext ctx;
        Map<IoSession, LdapContext> map = this.contexts;
        synchronized (map) {
            ctx = this.contexts.get(session);
        }
        if (ctx == null) {
            if (this.env.containsKey("server.use.factory.instance")) {
                InitialContextFactory factory = (InitialContextFactory)this.env.get("server.use.factory.instance");
                if (factory == null) {
                    throw new NullPointerException("server.use.factory.instance was set in env but was null");
                }
                ctx = (LdapContext)factory.getInitialContext(this.env);
            } else {
                Hashtable cloned = (Hashtable)this.env.clone();
                cloned.put("java.naming.security.authentication", AuthenticationLevel.NONE.toString());
                cloned.remove("java.naming.security.principal");
                cloned.remove("java.naming.security.credentials");
                ctx = new InitialLdapContext(cloned, connCtls);
            }
        }
        return ctx;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setLdapContext(IoSession session, LdapContext ictx) {
        Map<IoSession, LdapContext> map = this.contexts;
        synchronized (map) {
            this.contexts.put(session, ictx);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void remove(IoSession session) {
        Map<Integer, Request> reqmap;
        Map<IoSession, LdapContext> map = this.contexts;
        synchronized (map) {
            this.contexts.remove(session);
        }
        Map<IoSession, Map<Integer, Request>> map2 = this.requests;
        synchronized (map2) {
            reqmap = this.requests.remove(session);
        }
        if (reqmap == null || reqmap.isEmpty()) {
            return;
        }
        for (Request request : reqmap.values()) {
            if (!(request instanceof AbandonableRequest)) continue;
            ((AbandonableRequest)request).abandon();
        }
    }

    public void terminateSession(IoSession session) {
        session.close();
    }
}

