/*
 * Decompiled with CFR 0.152.
 */
package org.apache.directory.server.ldap.support.bind;

import java.util.Hashtable;
import javax.naming.NamingException;
import javax.naming.ldap.Control;
import javax.naming.ldap.InitialLdapContext;
import javax.naming.ldap.LdapContext;
import javax.naming.spi.InitialContextFactory;
import org.apache.directory.server.ldap.SessionRegistry;
import org.apache.directory.shared.ldap.exception.LdapException;
import org.apache.directory.shared.ldap.message.BindRequest;
import org.apache.directory.shared.ldap.message.LdapResult;
import org.apache.directory.shared.ldap.message.MessageTypeEnum;
import org.apache.directory.shared.ldap.message.MutableControl;
import org.apache.directory.shared.ldap.message.ResultCodeEnum;
import org.apache.directory.shared.ldap.name.LdapDN;
import org.apache.directory.shared.ldap.util.ExceptionUtils;
import org.apache.mina.common.IoSession;
import org.apache.mina.handler.chain.IoHandlerCommand;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class GetLdapContext
implements IoHandlerCommand {
    private static final Logger log = LoggerFactory.getLogger(GetLdapContext.class);
    private static final MutableControl[] EMPTY = new MutableControl[0];

    public void execute(IoHandlerCommand.NextCommand next, IoSession session, Object message) throws Exception {
        Hashtable env = this.getEnvironment(session, message);
        BindRequest request = (BindRequest)message;
        LdapResult result = request.getResultResponse().getLdapResult();
        LdapContext ctx = null;
        try {
            if (env.containsKey("server.use.factory.instance")) {
                InitialContextFactory factory = (InitialContextFactory)env.get("server.use.factory.instance");
                if (factory == null) {
                    throw new NullPointerException("server.use.factory.instance was set in env but was null");
                }
                ctx = (LdapContext)factory.getInitialContext(env);
            } else {
                MutableControl[] connCtls = request.getControls().values().toArray(EMPTY);
                ctx = new InitialLdapContext(env, (Control[])connCtls);
            }
            SessionRegistry.getSingleton().setLdapContext(session, ctx);
            request.getResultResponse().addAll(ctx.getResponseControls());
            next.execute(session, message);
        }
        catch (NamingException e) {
            ResultCodeEnum code;
            if (e instanceof LdapException) {
                code = ((LdapException)e).getResultCode();
                result.setResultCode(code);
            } else {
                code = ResultCodeEnum.getBestEstimate((Throwable)e, (MessageTypeEnum)request.getType());
                result.setResultCode(code);
            }
            String msg = "Bind failed: " + e.getMessage();
            if (log.isDebugEnabled()) {
                msg = msg + ":\n" + ExceptionUtils.getStackTrace((Throwable)e);
                msg = msg + "\n\nBindRequest = \n" + request.toString();
            }
            if (e.getResolvedName() != null && (code == ResultCodeEnum.NO_SUCH_OBJECT || code == ResultCodeEnum.ALIAS_PROBLEM || code == ResultCodeEnum.INVALID_DN_SYNTAX || code == ResultCodeEnum.ALIAS_DEREFERENCING_PROBLEM)) {
                result.setMatchedDn((LdapDN)e.getResolvedName());
            }
            result.setErrorMessage(msg);
            session.write((Object)request.getResultResponse());
            ctx = null;
        }
    }

    private Hashtable getEnvironment(IoSession session, Object message) {
        Object principal = session.getAttribute("java.naming.security.principal");
        Object credentials = session.getAttribute("java.naming.security.credentials");
        String sessionMechanism = (String)session.getAttribute("sessionMechanism");
        String authenticationLevel = this.getAuthenticationLevel(sessionMechanism);
        log.debug("{} {}", (Object)"java.naming.security.principal", principal);
        log.debug("{} {}", (Object)"java.naming.security.credentials", credentials);
        log.debug("{} {}", (Object)"java.naming.security.authentication", (Object)authenticationLevel);
        Hashtable<String, Object> env = SessionRegistry.getSingleton().getEnvironmentByCopy();
        env.put("java.naming.security.principal", principal);
        if (credentials != null) {
            env.put("java.naming.security.credentials", credentials);
        }
        env.put("java.naming.security.authentication", authenticationLevel);
        BindRequest request = (BindRequest)message;
        if (request.getControls().containsKey("2.16.840.1.113730.3.4.2")) {
            env.put("java.naming.referral", "ignore");
        } else {
            env.put("java.naming.referral", "throw");
        }
        return env;
    }

    private String getAuthenticationLevel(String sessionMechanism) {
        if (sessionMechanism.equals("SIMPLE")) {
            return "simple";
        }
        return "strong";
    }
}

