/*
 * Decompiled with CFR 0.152.
 */
package org.apache.directory.server.dns.store.jndi;

import java.util.Map;
import java.util.Set;
import javax.naming.Name;
import javax.naming.NamingException;
import javax.naming.directory.DirContext;
import javax.naming.ldap.LdapName;
import org.apache.directory.api.ldap.model.exception.LdapNoSuchObjectException;
import org.apache.directory.server.core.api.CoreSession;
import org.apache.directory.server.core.api.DirectoryService;
import org.apache.directory.server.core.jndi.ServerLdapContext;
import org.apache.directory.server.dns.DnsException;
import org.apache.directory.server.dns.messages.QuestionRecord;
import org.apache.directory.server.dns.messages.ResourceRecord;
import org.apache.directory.server.dns.messages.ResponseCode;
import org.apache.directory.server.dns.store.jndi.DnsCatalog;
import org.apache.directory.server.dns.store.jndi.SearchStrategy;
import org.apache.directory.server.dns.store.jndi.operations.GetRecords;
import org.apache.directory.server.i18n.I18n;
import org.apache.directory.server.protocol.shared.ServiceConfigurationException;
import org.apache.directory.server.protocol.shared.catalog.Catalog;
import org.apache.directory.server.protocol.shared.catalog.GetCatalog;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MultiBaseSearch
implements SearchStrategy {
    private static final Logger LOG = LoggerFactory.getLogger(MultiBaseSearch.class);
    private final Catalog catalog;
    private final DirectoryService directoryService;

    MultiBaseSearch(String catalogBaseDn, DirectoryService directoryService) {
        this.directoryService = directoryService;
        try {
            CoreSession session = directoryService.getSession();
            this.catalog = new DnsCatalog((Map)new GetCatalog().execute(session, null));
        }
        catch (Exception e) {
            LOG.error(e.getLocalizedMessage(), (Throwable)e);
            String message = I18n.err((I18n)I18n.ERR_37003_FAILED_TO_GET_CATALOG_CONTEXT, (Object[])new Object[]{catalogBaseDn});
            throw new ServiceConfigurationException(message, (Throwable)e);
        }
    }

    @Override
    public Set<ResourceRecord> getRecords(QuestionRecord question) throws DnsException {
        try {
            GetRecords getRecords = new GetRecords(question);
            String baseDn = this.catalog.getBaseDn(question.getDomainName());
            CoreSession session = this.directoryService.getSession();
            ServerLdapContext dirContext = new ServerLdapContext(this.directoryService, session, (Name)new LdapName(baseDn));
            return getRecords.execute((DirContext)dirContext, null);
        }
        catch (LdapNoSuchObjectException lnnfe) {
            LOG.debug("Name for DNS record search does not exist.", (Throwable)lnnfe);
            throw new DnsException(ResponseCode.NAME_ERROR);
        }
        catch (NamingException ne) {
            LOG.error(ne.getLocalizedMessage(), (Throwable)ne);
            String message = I18n.err((I18n)I18n.ERR_37004_FAILED_TO_GET_INITIAL_CONTEXT, (Object[])new Object[]{question.getDomainName()});
            throw new ServiceConfigurationException(message, (Throwable)ne);
        }
        catch (Exception e) {
            LOG.debug("Unexpected error retrieving DNS records.", (Throwable)e);
            throw new DnsException(ResponseCode.SERVER_FAILURE);
        }
    }
}

