/*
 * Decompiled with CFR 0.152.
 */
package org.apache.directory.server.dns;

import org.apache.directory.server.core.DefaultDirectoryService;
import org.apache.directory.server.core.DirectoryService;
import org.apache.directory.server.dns.DnsServer;
import org.apache.directory.server.protocol.shared.transport.TcpTransport;
import org.apache.directory.server.protocol.shared.transport.Transport;
import org.apache.directory.server.protocol.shared.transport.UdpTransport;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Main {
    private static final Logger LOG = LoggerFactory.getLogger(Main.class);
    private static DnsServer dnsConfiguration;

    public static void main(String[] args) throws Exception {
        new Main().go();
    }

    public void go() throws Exception {
        LOG.debug("Starting the DNS server");
        DefaultDirectoryService directoryService = new DefaultDirectoryService();
        dnsConfiguration = new DnsServer();
        dnsConfiguration.setDirectoryService((DirectoryService)directoryService);
        dnsConfiguration.setEnabled(true);
        dnsConfiguration.setTransports(new Transport[]{new TcpTransport(10053), new UdpTransport(10053)});
        dnsConfiguration.start();
    }

    protected void shutdown() {
        LOG.debug("Stopping the DNS server");
        dnsConfiguration.stop();
    }
}

