/*
 * Decompiled with CFR 0.152.
 */
package org.apache.directory.server.dns;

import java.io.IOException;
import javax.naming.NamingException;
import org.apache.directory.server.core.DefaultDirectoryService;
import org.apache.directory.server.core.DirectoryService;
import org.apache.directory.server.dns.DnsServer;
import org.apache.directory.server.protocol.shared.DatagramAcceptor;
import org.apache.directory.server.protocol.shared.SocketAcceptor;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Main {
    private static final Logger LOG = LoggerFactory.getLogger(Main.class);
    private static DnsServer dnsConfiguration;

    public static void main(String[] args) throws Exception {
        new Main().go();
    }

    public void go() throws IOException, NamingException {
        LOG.debug("Starting the DNS server");
        DatagramAcceptor datagramAcceptor = new DatagramAcceptor(null);
        SocketAcceptor socketAcceptor = new SocketAcceptor(null);
        DefaultDirectoryService directoryService = new DefaultDirectoryService();
        dnsConfiguration = new DnsServer();
        dnsConfiguration.setDatagramAcceptor(datagramAcceptor);
        dnsConfiguration.setSocketAcceptor(socketAcceptor);
        dnsConfiguration.setDirectoryService((DirectoryService)directoryService);
        dnsConfiguration.setEnabled(true);
        dnsConfiguration.setIpPort(10053);
        dnsConfiguration.start();
    }

    protected void shutdown() {
        LOG.debug("Stopping the DNS server");
        dnsConfiguration.stop();
    }
}

