/*
 * Decompiled with CFR 0.152.
 */
package org.apache.directory.server.dns.service;

import org.apache.directory.server.dns.messages.DnsMessage;
import org.apache.directory.server.dns.service.DnsContext;
import org.apache.directory.server.dns.service.MonitorMessage;
import org.apache.mina.common.IoSession;
import org.apache.mina.handler.chain.IoHandlerCommand;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MonitorReply
extends MonitorMessage {
    private static final Logger log = LoggerFactory.getLogger(MonitorReply.class);
    private String contextKey = "context";

    public void execute(IoHandlerCommand.NextCommand next, IoSession session, Object message) throws Exception {
        if (log.isDebugEnabled()) {
            try {
                DnsContext dnsContext = (DnsContext)session.getAttribute(this.getContextKey());
                DnsMessage reply = dnsContext.getReply();
                log.debug(this.monitorMessage(reply, "reply"));
            }
            catch (Exception e) {
                log.error("Error in reply monitor", (Throwable)e);
            }
        }
        next.execute(session, message);
    }

    public String getContextKey() {
        return this.contextKey;
    }
}

