/*
 * Decompiled with CFR 0.152.
 */
package org.apache.directory.server.dns.messages;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;

public final class MessageType
implements Comparable {
    public static final MessageType QUERY = new MessageType(0, "Query");
    public static final MessageType RESPONSE = new MessageType(1, "Response");
    private static final MessageType[] values = new MessageType[]{QUERY, RESPONSE};
    public static final List VALUES = Collections.unmodifiableList(Arrays.asList(values));
    private final String name;
    private final int ordinal;

    private MessageType(int ordinal, String name) {
        this.ordinal = ordinal;
        this.name = name;
    }

    public String toString() {
        return this.name;
    }

    public int compareTo(Object that) {
        return this.ordinal - ((MessageType)that).ordinal;
    }

    public static MessageType getTypeByOrdinal(int type) {
        for (int ii = 0; ii < values.length; ++ii) {
            if (MessageType.values[ii].ordinal != type) continue;
            return values[ii];
        }
        return QUERY;
    }

    public int getOrdinal() {
        return this.ordinal;
    }
}

