/*
 * Decompiled with CFR 0.152.
 */
package org.apache.directory.server.dhcp.protocol;

import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.SocketAddress;
import org.apache.directory.server.dhcp.messages.DhcpMessage;
import org.apache.directory.server.dhcp.protocol.DhcpProtocolCodecFactory;
import org.apache.directory.server.dhcp.service.DhcpServiceImpl;
import org.apache.mina.common.ConnectFuture;
import org.apache.mina.common.IdleStatus;
import org.apache.mina.common.IoFilter;
import org.apache.mina.common.IoHandler;
import org.apache.mina.common.IoSession;
import org.apache.mina.filter.codec.ProtocolCodecFactory;
import org.apache.mina.filter.codec.ProtocolCodecFilter;
import org.apache.mina.transport.socket.nio.DatagramConnector;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DhcpProtocolHandler
implements IoHandler {
    private static final Logger log = LoggerFactory.getLogger(DhcpProtocolHandler.class);

    public void sessionCreated(IoSession session) throws Exception {
        log.debug("{} CREATED", (Object)session.getRemoteAddress());
        session.getFilterChain().addFirst("codec", (IoFilter)new ProtocolCodecFilter((ProtocolCodecFactory)new DhcpProtocolCodecFactory()));
    }

    public void sessionOpened(IoSession session) {
        log.debug("{} OPENED", (Object)session.getRemoteAddress());
    }

    public void sessionClosed(IoSession session) {
        log.debug("{} CLOSED", (Object)session.getRemoteAddress());
    }

    public void sessionIdle(IoSession session, IdleStatus status) {
        log.debug("{} IDLE ({})", (Object)session.getRemoteAddress(), (Object)status);
    }

    public void exceptionCaught(IoSession session, Throwable cause) {
        log.debug(session.getRemoteAddress() + " EXCEPTION", cause);
        session.close();
    }

    public void messageReceived(IoSession session, Object message) throws Exception {
        log.debug("{} RCVD:  {}", (Object)session.getRemoteAddress(), message);
        DhcpMessage request = (DhcpMessage)message;
        if (request.getOpCode() == 1) {
            DhcpServiceImpl dhcpService = new DhcpServiceImpl();
            DhcpMessage reply = dhcpService.getReplyFor(request);
            int PORT = 68;
            DatagramConnector connector = new DatagramConnector();
            InetAddress broadcast = InetAddress.getByName(null);
            ConnectFuture future = connector.connect((SocketAddress)new InetSocketAddress(broadcast, PORT), (IoHandler)new DhcpProtocolHandler());
            future.join();
            IoSession replySession = future.getSession();
            replySession.write((Object)reply).join();
            replySession.close();
        }
    }

    public void messageSent(IoSession session, Object message) {
        log.debug("{} SENT:  {}", (Object)session.getRemoteAddress(), message);
    }
}

