/*
 * Decompiled with CFR 0.152.
 */
package org.apache.directory.server.kerberos.shared.io.decoder;

import java.util.Enumeration;
import org.apache.directory.server.kerberos.shared.messages.value.PrincipalName;
import org.apache.directory.shared.asn1.der.DEREncodable;
import org.apache.directory.shared.asn1.der.DERGeneralString;
import org.apache.directory.shared.asn1.der.DERInteger;
import org.apache.directory.shared.asn1.der.DERSequence;
import org.apache.directory.shared.asn1.der.DERTaggedObject;

public class PrincipalNameDecoder {
    public static PrincipalName decode(DERSequence sequence) {
        PrincipalName principalName = new PrincipalName();
        Enumeration e = sequence.getObjects();
        while (e.hasMoreElements()) {
            DERTaggedObject object = (DERTaggedObject)e.nextElement();
            int tag = object.getTagNo();
            DEREncodable derObject = object.getObject();
            switch (tag) {
                case 0: {
                    DERInteger nameType = (DERInteger)derObject;
                    principalName.setNameType(nameType.intValue());
                    break;
                }
                case 1: {
                    DERSequence nameString = (DERSequence)derObject;
                    PrincipalNameDecoder.decodeNameString(nameString, principalName);
                }
            }
        }
        return principalName;
    }

    private static void decodeNameString(DERSequence sequence, PrincipalName principalName) {
        Enumeration e = sequence.getObjects();
        while (e.hasMoreElements()) {
            DERGeneralString object = (DERGeneralString)e.nextElement();
            principalName.addName(object.getString());
        }
    }
}

