/*
 * Decompiled with CFR 0.152.
 */
package org.apache.directory.server.kerberos.shared.messages.value.flags;

import org.apache.directory.server.kerberos.shared.messages.value.flags.KerberosFlag;
import org.apache.directory.server.kerberos.shared.messages.value.flags.KerberosFlags;
import org.apache.directory.shared.asn1.primitives.BitString;

public abstract class AbstractKerberosFlags
extends BitString
implements KerberosFlags {
    public static final int MAX_SIZE = 32;
    protected int value;

    public AbstractKerberosFlags() {
        super(32);
    }

    public AbstractKerberosFlags(byte[] flags) {
        super(flags);
        this.value = (this.getBytes()[0] & 0xF) << 24 | (this.getBytes()[1] & 0xFF) << 16 | (this.getBytes()[2] & 0xFF) << 8 | 0xFF & this.getBytes()[3];
    }

    public static byte[] getBytes(int flags) {
        return new byte[]{(byte)(flags >>> 24), (byte)(flags >> 16 & 0xFF), (byte)(flags >> 8 & 0xFF), (byte)(flags & 0xFF)};
    }

    public byte[] getBytes() {
        return this.getData();
    }

    public int getIntValue() {
        return this.value;
    }

    public static boolean isFlagSet(int flags, int flag) {
        return (flags & 1 << flag) != 0;
    }

    public boolean isFlagSet(KerberosFlag flag) {
        return (this.value & 1 << flag.getOrdinal()) != 0;
    }

    public boolean isFlagSet(int flag) {
        return (flag & 1 << this.value) != 0;
    }

    public void setFlag(KerberosFlag flag) {
        this.value |= 1 << flag.getOrdinal();
        this.setBit(flag.getOrdinal());
    }

    public void setFlag(int flag) {
        this.value |= 1 << flag;
        this.setBit(flag);
    }

    public void setFlags(byte[] bytes) {
        if (bytes == null || bytes.length != 4) {
            this.value = -1;
        }
        this.value = (this.getBytes()[0] & 0xF) << 24 | (this.getBytes()[1] & 0xFF) << 16 | (this.getBytes()[2] & 0xFF) << 8 | 0xFF & this.getBytes()[3];
        this.setData(bytes);
    }

    public void clearFlag(KerberosFlag flag) {
        this.value &= ~(1 << flag.getOrdinal());
        this.clearBit(flag.getOrdinal());
    }

    public void clearFlag(int flag) {
        this.value &= ~(1 << flag);
        this.clearBit(flag);
    }

    public int getHexValue() {
        return 1 << this.value;
    }
}

