/*
 * Decompiled with CFR 0.152.
 */
package org.apache.directory.server.kerberos.shared.store.operations;

import javax.naming.Name;
import javax.naming.NamingException;
import javax.naming.directory.Attributes;
import javax.naming.directory.DirContext;
import javax.naming.spi.DirStateFactory;
import org.apache.directory.server.kerberos.shared.store.PrincipalStoreEntry;
import org.apache.directory.server.kerberos.shared.store.operations.PrincipalStateFactory;
import org.apache.directory.server.protocol.shared.store.ContextOperation;
import org.apache.directory.shared.ldap.name.LdapDN;

public class AddPrincipal
implements ContextOperation {
    private static final long serialVersionUID = -1032737167622217786L;
    protected PrincipalStoreEntry entry;

    public AddPrincipal(PrincipalStoreEntry entry) {
        this.entry = entry;
    }

    public Object execute(DirContext ctx, Name searchBaseDn) {
        if (this.entry == null) {
            return null;
        }
        try {
            PrincipalStateFactory factory = new PrincipalStateFactory();
            DirStateFactory.Result result = factory.getStateToBind((Object)this.entry, null, null, null, null);
            Attributes attrs = result.getAttributes();
            LdapDN name = new LdapDN("uid=" + this.entry.getUserId() + ",ou=Users");
            ctx.rebind((Name)name, null, attrs);
            return name.toString();
        }
        catch (NamingException ne) {
            ne.printStackTrace();
            return null;
        }
    }
}

