/*
 * Decompiled with CFR 0.152.
 */
package org.apache.directory.server.kerberos.shared.messages.value.types;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public enum AuthorizationType {
    NULL(0),
    AD_IF_RELEVANT(1),
    AD_INTENDED_FOR_SERVER(2),
    AD_INTENDED_FOR_APPLICATION_CLASS(3),
    AD_KDC_ISSUED(4),
    AD_OR(5),
    AD_MANDATORY_TICKET_EXTENSIONS(6),
    AD_IN_TICKET_EXTENSIONS(7),
    AD_MANDATORY_FOR_KDC(8),
    OSF_DCE(64),
    SESAME(65),
    AD_OSF_DCE_PKI_CERTID(66),
    AD_WIN2K_PAC(128),
    AD_ETYPE_NEGOTIATION(129);

    private final int ordinal;

    private AuthorizationType(int ordinal) {
        this.ordinal = ordinal;
    }

    public static AuthorizationType getTypeByOrdinal(int type) {
        switch (type) {
            case 1: {
                return AD_IF_RELEVANT;
            }
            case 2: {
                return AD_INTENDED_FOR_SERVER;
            }
            case 3: {
                return AD_INTENDED_FOR_APPLICATION_CLASS;
            }
            case 4: {
                return AD_KDC_ISSUED;
            }
            case 5: {
                return AD_OR;
            }
            case 6: {
                return AD_MANDATORY_TICKET_EXTENSIONS;
            }
            case 7: {
                return AD_IN_TICKET_EXTENSIONS;
            }
            case 8: {
                return AD_MANDATORY_FOR_KDC;
            }
            case 64: {
                return OSF_DCE;
            }
            case 65: {
                return SESAME;
            }
            case 66: {
                return AD_OSF_DCE_PKI_CERTID;
            }
            case 128: {
                return AD_WIN2K_PAC;
            }
            case 129: {
                return AD_ETYPE_NEGOTIATION;
            }
        }
        return NULL;
    }

    public int getOrdinal() {
        return this.ordinal;
    }

    public String toString() {
        switch (this) {
            case AD_IF_RELEVANT: {
                return "if relevant(" + this.ordinal + ")";
            }
            case AD_INTENDED_FOR_SERVER: {
                return "intended for server(" + this.ordinal + ")";
            }
            case AD_INTENDED_FOR_APPLICATION_CLASS: {
                return "intended for application class(" + this.ordinal + ")";
            }
            case AD_KDC_ISSUED: {
                return "kdc issued(" + this.ordinal + ")";
            }
            case AD_OR: {
                return "or(" + this.ordinal + ")";
            }
            case AD_MANDATORY_TICKET_EXTENSIONS: {
                return "mandatory ticket extensions(" + this.ordinal + ")";
            }
            case AD_IN_TICKET_EXTENSIONS: {
                return "in ticket extensions(" + this.ordinal + ")";
            }
            case AD_MANDATORY_FOR_KDC: {
                return "mandatory-for-kdc(" + this.ordinal + ")";
            }
            case OSF_DCE: {
                return "OSF DCE(" + this.ordinal + ")";
            }
            case SESAME: {
                return "sesame(" + this.ordinal + ")";
            }
            case AD_OSF_DCE_PKI_CERTID: {
                return "OSF DCE pki certid(" + this.ordinal + ")";
            }
            case AD_WIN2K_PAC: {
                return "win 2000 PAC(" + this.ordinal + ")";
            }
            case AD_ETYPE_NEGOTIATION: {
                return "etype negociation(" + this.ordinal + ")";
            }
        }
        return "null(" + this.ordinal + ")";
    }
}

