/*
 * Decompiled with CFR 0.152.
 */
package org.apache.directory.server.kerberos.shared.messages.value;

import java.nio.BufferOverflowException;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.apache.directory.server.kerberos.shared.messages.value.HostAddress;
import org.apache.directory.shared.asn1.AbstractAsn1Object;
import org.apache.directory.shared.asn1.ber.tlv.TLV;
import org.apache.directory.shared.asn1.codec.EncoderException;
import org.apache.directory.shared.ldap.util.StringTools;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HostAddresses
extends AbstractAsn1Object {
    private static final Logger LOG = LoggerFactory.getLogger(HostAddresses.class);
    private static final boolean IS_DEBUG = LOG.isDebugEnabled();
    private List<HostAddress> addresses;
    private transient int addressesLength;

    public HostAddresses() {
        this.addresses = new ArrayList<HostAddress>();
    }

    public HostAddresses(HostAddress[] addresses) {
        this.addresses = addresses == null ? new ArrayList<HostAddress>() : Arrays.asList(addresses);
    }

    public void addHostAddress(HostAddress hostAddress) {
        this.addresses.add(hostAddress);
    }

    public boolean contains(HostAddress address) {
        if (this.addresses != null) {
            return this.addresses.contains((Object)address);
        }
        return false;
    }

    public boolean equals(HostAddresses that) {
        if (this.addresses == null && that.addresses != null || this.addresses != null && that.addresses == null) {
            return false;
        }
        if (this.addresses != null && that.addresses != null) {
            if (this.addresses.size() != that.addresses.size()) {
                return false;
            }
            HostAddress[] thisHostAddresses = (HostAddress[])this.addresses.toArray();
            HostAddress[] thatHostAddresses = (HostAddress[])that.addresses.toArray();
            for (int i = 0; i < thisHostAddresses.length; ++i) {
                if (thisHostAddresses[i].equals((Object)thatHostAddresses[i])) continue;
                return false;
            }
        }
        return true;
    }

    public HostAddress[] getAddresses() {
        return (HostAddress[])this.addresses.toArray();
    }

    public int computeLength() {
        this.addressesLength = 0;
        if (this.addresses != null && this.addresses.size() != 0) {
            for (HostAddress hostAddress : this.addresses) {
                int length = hostAddress.computeLength();
                this.addressesLength += length;
            }
        }
        return 1 + TLV.getNbBytes((int)this.addressesLength) + this.addressesLength;
    }

    public ByteBuffer encode(ByteBuffer buffer) throws EncoderException {
        if (buffer == null) {
            throw new EncoderException("Cannot put a PDU in a null buffer !");
        }
        try {
            buffer.put((byte)48);
            buffer.put(TLV.getBytes((int)this.addressesLength));
            if (this.addresses != null && this.addresses.size() != 0) {
                for (HostAddress hostAddress : this.addresses) {
                    hostAddress.encode(buffer);
                }
            }
        }
        catch (BufferOverflowException boe) {
            LOG.error("Cannot encode the HostAddresses object, the PDU size is {} when only {} bytes has been allocated", (Object)(1 + TLV.getNbBytes((int)this.addressesLength) + this.addressesLength), (Object)buffer.capacity());
            throw new EncoderException("The PDU buffer size is too small !");
        }
        if (IS_DEBUG) {
            LOG.debug("HostAddresses encoding : {}", (Object)StringTools.dumpBytes((byte[])buffer.array()));
            LOG.debug("HostAddresses initial value : {}", (Object)this.toString());
        }
        return buffer;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        boolean isFirst = true;
        for (HostAddress hostAddress : this.addresses) {
            if (isFirst) {
                isFirst = false;
            } else {
                sb.append(", ");
            }
            sb.append(hostAddress.toString());
        }
        return sb.toString();
    }
}

