/*
 * Decompiled with CFR 0.152.
 */
package org.apache.directory.server.kerberos.shared.messages.value;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class AuthorizationType
implements Comparable<AuthorizationType> {
    public static final AuthorizationType NULL = new AuthorizationType(0, "null");
    public static final AuthorizationType AD_IF_RELEVANT = new AuthorizationType(1, "if relevant");
    public static final AuthorizationType AD_INTENDED_FOR_SERVER = new AuthorizationType(2, "intended for server");
    public static final AuthorizationType AD_INTENDED_FOR_APPLICATION_CLASS = new AuthorizationType(3, "intended for application class");
    public static final AuthorizationType AD_KDC_ISSUED = new AuthorizationType(4, "kdc issued");
    public static final AuthorizationType AD_AND_OR = new AuthorizationType(5, "and-or");
    public static final AuthorizationType AD_MANDATORY_TICKET_EXTENSIONS = new AuthorizationType(6, "mandatory ticket extensions");
    public static final AuthorizationType AD_IN_TICKET_EXTENSIONS = new AuthorizationType(7, "in ticket extensions");
    public static final AuthorizationType AD_MANDATORY_FOR_KDC = new AuthorizationType(8, "mandatory for KDC");
    public static final AuthorizationType AD_INITIAL_VERIFIED_CAS = new AuthorizationType(9, "Initial verified CAS");
    public static final AuthorizationType OSF_DCE = new AuthorizationType(64, "OSF DCE");
    public static final AuthorizationType SESAME = new AuthorizationType(65, "sesame");
    public static final AuthorizationType AD_OSF_DCE_PKI_CERTID = new AuthorizationType(66, "OSF DCE PKI CERTID");
    public static final AuthorizationType AD_WIN2K_PAC = new AuthorizationType(128, "WIN2K PAC");
    public static final AuthorizationType AD_ETYPE_NEGOTIATION = new AuthorizationType(129, "encryption negotiation");
    private static final AuthorizationType[] values = new AuthorizationType[]{NULL, AD_IF_RELEVANT, AD_INTENDED_FOR_SERVER, AD_INTENDED_FOR_APPLICATION_CLASS, AD_KDC_ISSUED, AD_AND_OR, AD_MANDATORY_TICKET_EXTENSIONS, AD_IN_TICKET_EXTENSIONS, AD_MANDATORY_FOR_KDC, AD_INITIAL_VERIFIED_CAS, OSF_DCE, SESAME, AD_OSF_DCE_PKI_CERTID, AD_WIN2K_PAC, AD_ETYPE_NEGOTIATION};
    public static final List<AuthorizationType> VALUES = Collections.unmodifiableList(Arrays.asList(values));
    private final String name;
    private final int ordinal;

    private AuthorizationType(int ordinal, String name) {
        this.ordinal = ordinal;
        this.name = name;
    }

    public static AuthorizationType getTypeByOrdinal(int type) {
        for (int ii = 0; ii < values.length; ++ii) {
            if (AuthorizationType.values[ii].ordinal != type) continue;
            return values[ii];
        }
        return NULL;
    }

    public int getOrdinal() {
        return this.ordinal;
    }

    @Override
    public int compareTo(AuthorizationType that) {
        return this.ordinal - that.ordinal;
    }

    public String toString() {
        return this.name + " (" + this.ordinal + ")";
    }
}

