/*
 * Decompiled with CFR 0.152.
 */
package org.apache.directory.server.kerberos.shared.store.operations;

import java.util.Properties;
import javax.naming.CompoundName;
import javax.naming.Name;
import javax.naming.NamingEnumeration;
import javax.naming.NamingException;
import javax.naming.directory.Attribute;
import javax.naming.directory.Attributes;
import javax.naming.directory.DirContext;
import javax.naming.directory.ModificationItem;
import javax.naming.directory.SearchResult;
import javax.security.auth.kerberos.KerberosKey;
import javax.security.auth.kerberos.KerberosPrincipal;
import org.apache.directory.server.protocol.shared.store.ContextOperation;
import org.apache.directory.shared.ldap.message.AttributeImpl;
import org.apache.directory.shared.ldap.message.AttributesImpl;
import org.apache.directory.shared.ldap.message.ModificationItemImpl;

public class ChangePassword
implements ContextOperation {
    private static final long serialVersionUID = -7147685183641418353L;
    protected KerberosPrincipal principal;
    protected KerberosKey newKey;

    public ChangePassword(KerberosPrincipal principal, KerberosKey newKey) {
        this.principal = principal;
        this.newKey = newKey;
    }

    public Object execute(DirContext ctx, Name searchBaseDn) {
        if (this.principal == null) {
            return null;
        }
        ModificationItemImpl[] mods = new ModificationItemImpl[1];
        AttributeImpl newKeyAttribute = new AttributeImpl("krb5key", this.newKey.getEncoded());
        mods[0] = new ModificationItemImpl(2, (Attribute)newKeyAttribute);
        String dn = null;
        try {
            dn = this.search(ctx, this.principal.getName());
            Name rdn = this.getRelativeName(ctx.getNameInNamespace(), dn);
            ctx.modifyAttributes(rdn, (ModificationItem[])mods);
        }
        catch (NamingException e) {
            return null;
        }
        return dn;
    }

    private String search(DirContext ctx, String principal) throws NamingException {
        SearchResult sr;
        String[] attrIDs = new String[]{"krb5PrincipalName", "krb5KeyVersionNumber", "krb5EncryptionType", "krb5Key"};
        AttributesImpl matchAttrs = new AttributesImpl(true);
        matchAttrs.put((Attribute)new AttributeImpl("krb5PrincipalName", (Object)principal));
        NamingEnumeration<SearchResult> answer = ctx.search("", (Attributes)matchAttrs, attrIDs);
        if (answer.hasMore() && (sr = answer.next()) != null) {
            return sr.getName();
        }
        return null;
    }

    private Name getRelativeName(String nameInNamespace, String baseDn) throws NamingException {
        Properties props = new Properties();
        props.setProperty("jndi.syntax.direction", "right_to_left");
        props.setProperty("jndi.syntax.separator", ",");
        props.setProperty("jndi.syntax.ignorecase", "true");
        props.setProperty("jndi.syntax.trimblanks", "true");
        CompoundName searchBaseDn = null;
        CompoundName ctxRoot = new CompoundName(nameInNamespace, props);
        searchBaseDn = new CompoundName(baseDn, props);
        if (!searchBaseDn.startsWith(ctxRoot)) {
            throw new NamingException("Invalid search base " + baseDn);
        }
        for (int ii = 0; ii < ctxRoot.size(); ++ii) {
            searchBaseDn.remove(0);
        }
        return searchBaseDn;
    }
}

