/*
 * Decompiled with CFR 0.152.
 */
package org.apache.directory.server.kerberos.shared.replay;

import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import javax.security.auth.kerberos.KerberosPrincipal;
import org.apache.directory.server.kerberos.shared.messages.value.KerberosTime;
import org.apache.directory.server.kerberos.shared.replay.ReplayCache;

public class InMemoryReplayCache
implements ReplayCache {
    private static final long TWO_WEEKS = 1209600000L;
    private List list = new ArrayList();

    public synchronized boolean isReplay(KerberosTime clientTime, KerberosPrincipal clientPrincipal) {
        ReplayCacheEntry testEntry = new ReplayCacheEntry(clientTime, clientPrincipal);
        for (ReplayCacheEntry entry : this.list) {
            if (!entry.equals(testEntry)) continue;
            return true;
        }
        return false;
    }

    public synchronized void save(KerberosTime clientTime, KerberosPrincipal clientPrincipal) {
        this.list.add(new ReplayCacheEntry(clientTime, clientPrincipal));
        this.purgeExpired();
    }

    private synchronized void purgeExpired() {
        long now = new Date().getTime();
        KerberosTime age = new KerberosTime(now - 1209600000L);
        for (ReplayCacheEntry entry : this.list) {
            if (!entry.olderThan(age)) continue;
            this.list.remove(entry);
        }
    }

    private class ReplayCacheEntry {
        private KerberosTime clientTime;
        private KerberosPrincipal clientPrincipal;

        public ReplayCacheEntry(KerberosTime time, KerberosPrincipal principal) {
            this.clientTime = time;
            this.clientPrincipal = principal;
        }

        public boolean equals(ReplayCacheEntry other) {
            return this.clientTime.equals(other.clientTime) && this.clientPrincipal.equals(other.clientPrincipal);
        }

        public boolean olderThan(KerberosTime time) {
            return time.greaterThan(this.clientTime);
        }
    }
}

