/*
 * Decompiled with CFR 0.152.
 */
package org.apache.directory.server.kerberos.shared.store.operations;

import javax.naming.Name;
import javax.naming.NamingEnumeration;
import javax.naming.NamingException;
import javax.naming.directory.Attributes;
import javax.naming.directory.BasicAttribute;
import javax.naming.directory.BasicAttributes;
import javax.naming.directory.DirContext;
import javax.naming.directory.SearchResult;
import javax.security.auth.kerberos.KerberosPrincipal;
import org.apache.directory.server.kerberos.shared.messages.value.SamType;
import org.apache.directory.server.kerberos.shared.store.PrincipalStoreEntry;
import org.apache.directory.server.kerberos.shared.store.PrincipalStoreEntryModifier;
import org.apache.directory.server.protocol.shared.store.ContextOperation;

public class GetPrincipal
implements ContextOperation {
    private static final long serialVersionUID = 4598007518413451945L;
    private final KerberosPrincipal principal;

    public GetPrincipal(KerberosPrincipal principal) {
        this.principal = principal;
    }

    public Object execute(DirContext ctx, Name base) {
        if (this.principal == null) {
            return null;
        }
        String[] attrIDs = new String[]{"krb5PrincipalName", "krb5KeyVersionNumber", "krb5EncryptionType", "krb5Key", "apacheSamType"};
        BasicAttributes matchAttrs = new BasicAttributes(false);
        matchAttrs.put(new BasicAttribute("krb5PrincipalName", this.principal.getName()));
        PrincipalStoreEntry entry = null;
        try {
            NamingEnumeration<SearchResult> answer = ctx.search("", (Attributes)matchAttrs, attrIDs);
            if (answer.hasMore()) {
                SearchResult result = answer.next();
                Attributes attrs = result.getAttributes();
                if (attrs == null) {
                    return null;
                }
                entry = this.getEntry(attrs);
            }
        }
        catch (NamingException e) {
            return null;
        }
        return entry;
    }

    private PrincipalStoreEntry getEntry(Attributes attrs) throws NamingException {
        PrincipalStoreEntryModifier modifier = new PrincipalStoreEntryModifier();
        String principal = (String)attrs.get("krb5PrincipalName").get();
        String encryptionType = (String)attrs.get("krb5EncryptionType").get();
        String keyVersionNumber = (String)attrs.get("krb5KeyVersionNumber").get();
        if (attrs.get("apacheSamType") != null) {
            String samType = (String)attrs.get("apacheSamType").get();
            modifier.setSamType(SamType.getTypeByOrdinal(Integer.parseInt(samType)));
        }
        Object key = attrs.get("krb5Key").get();
        byte[] keyBytes = null;
        if (key instanceof String) {
            String msg = "JNDI should not return a string for the kerberos key: JNDI property java.naming.ldap.attributes.binary must include the krb5key attribute.";
            throw new NamingException(msg);
        }
        keyBytes = (byte[])key;
        modifier.setKey(keyBytes);
        modifier.setPrincipal(new KerberosPrincipal(principal));
        modifier.setEncryptionType(Integer.parseInt(encryptionType));
        modifier.setKeyVersionNumber(Integer.parseInt(keyVersionNumber));
        return modifier.getEntry();
    }
}

