/*
 * Decompiled with CFR 0.152.
 */
package org.apache.directory.server.kerberos.shared.exceptions;

import org.apache.directory.server.kerberos.shared.exceptions.ErrorType;

public class KerberosException
extends Exception {
    private static final long serialVersionUID = 2968072183596955597L;
    private final int errorCode;
    private byte[] explanatoryData;

    public KerberosException(int errorCode, String msg) {
        super(msg);
        this.errorCode = errorCode;
    }

    public KerberosException(int errorCode, String msg, Throwable cause) {
        super(msg, cause);
        this.errorCode = errorCode;
    }

    public KerberosException(int errorCode, String msg, byte[] explanatoryData) {
        super(msg);
        this.errorCode = errorCode;
        this.explanatoryData = explanatoryData;
    }

    public KerberosException(ErrorType errorType) {
        super(errorType.getMessage());
        this.errorCode = errorType.getOrdinal();
    }

    public KerberosException(ErrorType errorType, String msg) {
        super(msg);
        this.errorCode = errorType.getOrdinal();
    }

    public KerberosException(ErrorType errorType, byte[] explanatoryData) {
        super(errorType.getMessage());
        this.errorCode = errorType.getOrdinal();
        this.explanatoryData = explanatoryData;
    }

    public int getErrorCode() {
        return this.errorCode;
    }

    public byte[] getExplanatoryData() {
        return this.explanatoryData;
    }
}

