/*
 * Decompiled with CFR 0.152.
 */
package org.apache.directory.shared.kerberos.codec.kdcRep.actions;

import org.apache.directory.shared.asn1.DecoderException;
import org.apache.directory.shared.asn1.ber.Asn1Container;
import org.apache.directory.shared.asn1.ber.Asn1Decoder;
import org.apache.directory.shared.asn1.ber.grammar.GrammarAction;
import org.apache.directory.shared.asn1.ber.tlv.TLV;
import org.apache.directory.shared.i18n.I18n;
import org.apache.directory.shared.kerberos.codec.kdcRep.KdcRepContainer;
import org.apache.directory.shared.kerberos.codec.ticket.TicketContainer;
import org.apache.directory.shared.kerberos.components.KdcRep;
import org.apache.directory.shared.kerberos.messages.Ticket;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class StoreTicket
extends GrammarAction<KdcRepContainer> {
    private static final Logger LOG = LoggerFactory.getLogger(StoreTicket.class);
    private static final boolean IS_DEBUG = LOG.isDebugEnabled();

    public StoreTicket() {
        super("KDC-REP Store Ticket");
    }

    public void action(KdcRepContainer kdcRepContainer) throws DecoderException {
        TLV tlv = kdcRepContainer.getCurrentTLV();
        if (tlv.getLength() == 0) {
            LOG.error(I18n.err((I18n)I18n.ERR_04066, (Object[])new Object[0]));
            throw new DecoderException(I18n.err((I18n)I18n.ERR_04067, (Object[])new Object[0]));
        }
        Asn1Decoder ticketDecoder = new Asn1Decoder();
        TicketContainer ticketContainer = new TicketContainer(kdcRepContainer.getStream());
        ticketDecoder.decode(kdcRepContainer.getStream(), (Asn1Container)ticketContainer);
        tlv.setExpectedLength(tlv.getExpectedLength() - tlv.getLength());
        kdcRepContainer.updateParent();
        Ticket ticket = ticketContainer.getTicket();
        KdcRep kdcRep = kdcRepContainer.getKdcRep();
        kdcRep.setTicket(ticket);
        if (IS_DEBUG) {
            LOG.debug("Stored ticket:  {}", (Object)ticket);
        }
    }
}

