/*
 * Decompiled with CFR 0.152.
 */
package jdbm.recman;

import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import jdbm.RecordManager;
import jdbm.helper.DefaultSerializer;
import jdbm.helper.Serializer;
import jdbm.recman.Location;
import jdbm.recman.LogicalRowIdManager;
import jdbm.recman.PageManager;
import jdbm.recman.PhysicalRowIdManager;
import jdbm.recman.RecordFile;
import jdbm.recman.TransactionManager;
import org.apache.directory.server.i18n.I18n;

public final class BaseRecordManager
implements RecordManager {
    private RecordFile recordFile;
    private PhysicalRowIdManager physMgr;
    private LogicalRowIdManager logMgr;
    private PageManager pageMgr;
    public static final int NAME_DIRECTORY_ROOT = 0;
    public static final boolean DEBUG = false;
    private Map<String, Long> nameDirectory;

    public BaseRecordManager(String filename) throws IOException {
        this.recordFile = new RecordFile(filename);
        this.pageMgr = new PageManager(this.recordFile);
        this.physMgr = new PhysicalRowIdManager(this.pageMgr);
        this.logMgr = new LogicalRowIdManager(this.pageMgr);
    }

    public synchronized TransactionManager getTransactionManager() throws IOException {
        this.checkIfClosed();
        return this.recordFile.getTxnMgr();
    }

    public synchronized void disableTransactions() {
        this.checkIfClosed();
        this.recordFile.disableTransactions();
    }

    @Override
    public synchronized void close() throws IOException {
        this.checkIfClosed();
        this.pageMgr.close();
        this.pageMgr = null;
        this.recordFile.close();
        this.recordFile = null;
    }

    @Override
    public long insert(Object obj) throws IOException {
        return this.insert(obj, DefaultSerializer.INSTANCE);
    }

    @Override
    public synchronized long insert(Object obj, Serializer serializer) throws IOException {
        this.checkIfClosed();
        byte[] data = serializer.serialize(obj);
        Location physRowId = this.physMgr.insert(data, 0, data.length);
        long recid = this.logMgr.insert(physRowId).toLong();
        return recid;
    }

    @Override
    public synchronized void delete(long recid) throws IOException {
        this.checkIfClosed();
        if (recid <= 0L) {
            throw new IllegalArgumentException(I18n.err((I18n)I18n.ERR_536, (Object[])new Object[]{recid}));
        }
        Location logRowId = new Location(recid);
        Location physRowId = this.logMgr.fetch(logRowId);
        this.physMgr.delete(physRowId);
        this.logMgr.delete(logRowId);
    }

    @Override
    public void update(long recid, Object obj) throws IOException {
        this.update(recid, obj, DefaultSerializer.INSTANCE);
    }

    @Override
    public synchronized void update(long recid, Object obj, Serializer serializer) throws IOException {
        byte[] data;
        this.checkIfClosed();
        if (recid <= 0L) {
            throw new IllegalArgumentException(I18n.err((I18n)I18n.ERR_536, (Object[])new Object[]{recid}));
        }
        Location logRecid = new Location(recid);
        Location physRecid = this.logMgr.fetch(logRecid);
        Location newRecid = this.physMgr.update(physRecid, data = serializer.serialize(obj), 0, data.length);
        if (!newRecid.equals(physRecid)) {
            this.logMgr.update(logRecid, newRecid);
        }
    }

    @Override
    public Object fetch(long recid) throws IOException {
        return this.fetch(recid, DefaultSerializer.INSTANCE);
    }

    @Override
    public synchronized Object fetch(long recid, Serializer serializer) throws IOException {
        this.checkIfClosed();
        if (recid <= 0L) {
            throw new IllegalArgumentException(I18n.err((I18n)I18n.ERR_536, (Object[])new Object[]{recid}));
        }
        byte[] data = this.physMgr.fetch(this.logMgr.fetch(new Location(recid)));
        return serializer.deserialize(data);
    }

    @Override
    public int getRootCount() {
        return 1013;
    }

    @Override
    public synchronized long getRoot(int id) throws IOException {
        this.checkIfClosed();
        return this.pageMgr.getFileHeader().getRoot(id);
    }

    @Override
    public synchronized void setRoot(int id, long rowid) throws IOException {
        this.checkIfClosed();
        this.pageMgr.getFileHeader().setRoot(id, rowid);
    }

    @Override
    public long getNamedObject(String name) throws IOException {
        this.checkIfClosed();
        Map<String, Long> nameDirectory = this.getNameDirectory();
        Long recid = nameDirectory.get(name);
        if (recid == null) {
            return 0L;
        }
        return recid;
    }

    @Override
    public void setNamedObject(String name, long recid) throws IOException {
        this.checkIfClosed();
        if (recid == 0L) {
            this.getNameDirectory().remove(name);
        } else {
            this.getNameDirectory().put(name, recid);
        }
        this.saveNameDirectory();
    }

    @Override
    public synchronized void commit() throws IOException {
        this.checkIfClosed();
        this.pageMgr.commit();
    }

    @Override
    public synchronized void rollback() throws IOException {
        this.checkIfClosed();
        this.pageMgr.rollback();
    }

    private Map<String, Long> getNameDirectory() throws IOException {
        long nameDirectory_recid = this.getRoot(0);
        if (nameDirectory_recid == 0L) {
            this.nameDirectory = new HashMap<String, Long>();
            nameDirectory_recid = this.insert(this.nameDirectory);
            this.setRoot(0, nameDirectory_recid);
        } else {
            this.nameDirectory = (Map)this.fetch(nameDirectory_recid);
        }
        return this.nameDirectory;
    }

    private void saveNameDirectory() throws IOException {
        long recid = this.getRoot(0);
        if (recid == 0L) {
            throw new IOException(I18n.err((I18n)I18n.ERR_537, (Object[])new Object[0]));
        }
        this.update(recid, this.nameDirectory);
    }

    private void checkIfClosed() throws IllegalStateException {
        if (this.recordFile == null) {
            throw new IllegalStateException(I18n.err((I18n)I18n.ERR_538, (Object[])new Object[0]));
        }
    }
}

