/*
 * Decompiled with CFR 0.152.
 */
package org.apache.directory.server.core.partition.impl.btree.jdbm;

import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import jdbm.RecordManager;
import jdbm.helper.CachePolicy;
import jdbm.helper.MRU;
import jdbm.recman.BaseRecordManager;
import jdbm.recman.CacheRecordManager;
import org.apache.directory.server.core.partition.impl.btree.LongComparator;
import org.apache.directory.server.core.partition.impl.btree.jdbm.JdbmIndex;
import org.apache.directory.server.core.partition.impl.btree.jdbm.JdbmTable;
import org.apache.directory.server.core.partition.impl.btree.jdbm.LongSerializer;
import org.apache.directory.server.i18n.I18n;
import org.apache.directory.server.xdbm.ParentIdAndRdn;
import org.apache.directory.server.xdbm.ParentIdAndRdnComparator;
import org.apache.directory.shared.ldap.model.schema.AttributeType;
import org.apache.directory.shared.ldap.model.schema.MatchingRule;
import org.apache.directory.shared.ldap.model.schema.SchemaManager;
import org.apache.directory.shared.util.SynchronizedLRUMap;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JdbmRdnIndex<E>
extends JdbmIndex<ParentIdAndRdn<Long>, E> {
    private static final Logger LOG = LoggerFactory.getLogger(JdbmRdnIndex.class);

    public JdbmRdnIndex() {
        this.initialized = false;
    }

    public JdbmRdnIndex(String attributeId) {
        this.initialized = false;
        this.setAttributeId(attributeId);
    }

    @Override
    public void init(SchemaManager schemaManager, AttributeType attributeType) throws IOException {
        LOG.debug("Initializing an Index for attribute '{}'", (Object)attributeType.getName());
        this.keyCache = new SynchronizedLRUMap(this.cacheSize);
        this.attributeType = attributeType;
        if (this.attributeId == null) {
            this.setAttributeId(attributeType.getName());
        }
        if (this.wkDirPath == null) {
            NullPointerException e = new NullPointerException("The index working directory has not be set");
            e.printStackTrace();
            throw e;
        }
        String path = new File(this.wkDirPath, attributeType.getOid()).getAbsolutePath();
        BaseRecordManager base = new BaseRecordManager(path);
        base.disableTransactions();
        this.recMan = new CacheRecordManager((RecordManager)base, (CachePolicy)new MRU(this.cacheSize));
        try {
            this.initTables(schemaManager);
        }
        catch (IOException e) {
            this.close();
            throw e;
        }
        FileWriter fw = new FileWriter(new File(path + "-" + attributeType.getName() + ".txt"));
        fw.write(attributeType.toString());
        fw.close();
        this.initialized = true;
    }

    private void initTables(SchemaManager schemaManager) throws IOException {
        MatchingRule mr = this.attributeType.getEquality();
        if (mr == null) {
            throw new IOException(I18n.err((I18n)I18n.ERR_574, (Object[])new Object[]{this.attributeType.getName()}));
        }
        ParentIdAndRdnComparator comp = new ParentIdAndRdnComparator(mr.getOid());
        LongComparator.INSTANCE.setSchemaManager(schemaManager);
        this.forward = new JdbmTable(schemaManager, this.attributeType.getOid() + "_forward", this.recMan, comp, null, LongSerializer.INSTANCE);
        this.reverse = new JdbmTable(schemaManager, this.attributeType.getOid() + "_reverse", this.recMan, LongComparator.INSTANCE, LongSerializer.INSTANCE, null);
    }

    @Override
    public void add(ParentIdAndRdn<Long> rdn, Long entryId) throws Exception {
        this.forward.put(rdn, entryId);
        this.reverse.put(entryId, rdn);
    }

    @Override
    public void drop(Long entryId) throws Exception {
        ParentIdAndRdn rdn = (ParentIdAndRdn)this.reverse.get(entryId);
        this.forward.remove(rdn);
        this.reverse.remove(entryId);
    }

    @Override
    public void drop(ParentIdAndRdn<Long> rdn, Long id) throws Exception {
        long val = (Long)this.forward.get(rdn);
        if (val == id) {
            this.forward.remove(rdn);
            this.reverse.remove(val);
        }
    }

    @Override
    public ParentIdAndRdn<Long> getNormalized(ParentIdAndRdn<Long> rdn) throws Exception {
        return rdn;
    }
}

