/*
 * Decompiled with CFR 0.152.
 */
package org.apache.directory.server.installers.archive;

import java.io.File;
import java.io.IOException;
import org.apache.directory.server.core.api.InstanceLayout;
import org.apache.directory.server.i18n.I18n;
import org.apache.directory.server.installers.GenerateMojo;
import org.apache.directory.server.installers.LinuxInstallerCommand;
import org.apache.directory.server.installers.MojoHelperUtils;
import org.apache.directory.server.installers.archive.ArchiveTarget;
import org.apache.directory.server.installers.archive.ArchiveType;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.tools.ant.Project;
import org.apache.tools.ant.taskdefs.BZip2;
import org.apache.tools.ant.taskdefs.GZip;
import org.apache.tools.ant.taskdefs.Tar;
import org.apache.tools.ant.taskdefs.Zip;
import org.codehaus.plexus.util.FileUtils;

public class ArchiveInstallerCommand
extends LinuxInstallerCommand<ArchiveTarget> {
    private static final String APACHE_BAT_FILE = "apacheds.bat";
    private static final String APACHE_SH_FILE = "apacheds.sh";
    private static final String CPAPPEND_BAT_FILE = "cpappend.bat";
    private static final String DOT_TAR = ".tar";
    private static final String ALL_FILES = "/**";

    public ArchiveInstallerCommand(GenerateMojo mojo, ArchiveTarget target) {
        super(mojo, target);
        this.initializeFilterProperties();
    }

    @Override
    protected void createInstanceLayout() throws IOException {
        InstanceLayout instanceLayout = this.getInstanceLayout();
        instanceLayout.mkdirs();
        MojoHelperUtils.copyAsciiFile(this.mojo, this.filterProperties, "/org/apache/directory/server/installers/archive/log4j.properties", this.getClass().getResourceAsStream("/org/apache/directory/server/installers/archive/log4j.properties"), new File(instanceLayout.getConfDirectory(), "log4j.properties"), true);
        MojoHelperUtils.copyAsciiFile(this.mojo, this.filterProperties, "/org/apache/directory/server/installers/wrapper-instance.conf", this.getClass().getResourceAsStream("/org/apache/directory/server/installers/wrapper-instance.conf"), new File(instanceLayout.getConfDirectory(), "wrapper-instance.conf"), true);
        MojoHelperUtils.copyAsciiFile(this.mojo, this.filterProperties, "/org/apache/directory/server/installers/config.ldif", this.getClass().getResourceAsStream("/org/apache/directory/server/installers/config.ldif"), new File(instanceLayout.getConfDirectory(), "config.ldif"), false);
    }

    @Override
    public void execute() throws MojoExecutionException, MojoFailureException {
        if (!this.verifyTarget()) {
            return;
        }
        String archiveType = ((ArchiveTarget)this.target).getArchiveType();
        this.log.info((CharSequence)("  Creating " + archiveType + " archive..."));
        if (!this.getTargetDirectory().mkdirs()) {
            IOException e = new IOException(I18n.err((I18n)I18n.ERR_112_COULD_NOT_CREATE_DIRECTORY, (Object[])new Object[]{this.getTargetDirectory()}));
            this.log.error((CharSequence)e.getLocalizedMessage());
            throw new MojoFailureException(e.getMessage());
        }
        this.log.info((CharSequence)"    Copying archive files");
        try {
            this.createLayouts(false);
            MojoHelperUtils.copyAsciiFile(this.mojo, this.filterProperties, APACHE_BAT_FILE, this.getClass().getResourceAsStream(APACHE_BAT_FILE), new File(this.getInstallationLayout().getBinDirectory(), APACHE_BAT_FILE), false);
            MojoHelperUtils.copyAsciiFile(this.mojo, this.filterProperties, APACHE_SH_FILE, this.getClass().getResourceAsStream(APACHE_SH_FILE), new File(this.getInstallationLayout().getBinDirectory(), APACHE_SH_FILE), false);
            MojoHelperUtils.copyAsciiFile(this.mojo, this.filterProperties, CPAPPEND_BAT_FILE, this.getClass().getResourceAsStream(CPAPPEND_BAT_FILE), new File(this.getInstallationLayout().getBinDirectory(), CPAPPEND_BAT_FILE), false);
            FileUtils.deleteDirectory((File)this.getInstallationLayout().getConfDirectory());
            File wrapperConf = new File(this.getInstanceLayout().getConfDirectory(), "wrapper-instance.conf");
            if (!wrapperConf.delete()) {
                throw new IOException(I18n.err((I18n)I18n.ERR_113_COULD_NOT_DELETE_FILE_OR_DIRECTORY, (Object[])new Object[]{wrapperConf}));
            }
        }
        catch (Exception e) {
            this.log.error((CharSequence)e.getMessage());
            throw new MojoFailureException("Failed to copy archive files.");
        }
        this.log.info((CharSequence)"    Generating archive");
        String finalName = ((ArchiveTarget)this.target).getFinalName();
        if (!finalName.endsWith(archiveType)) {
            finalName = finalName + archiveType;
        }
        File finalFile = new File(this.mojo.getOutputDirectory(), finalName);
        Project project = new Project();
        project.setBaseDir(this.mojo.getOutputDirectory());
        ArchiveType type = ArchiveType.getType(archiveType);
        switch (type) {
            case ZIP: {
                Zip zipTask = new Zip();
                zipTask.setProject(project);
                zipTask.setDestFile(finalFile);
                zipTask.setBasedir(this.getTargetDirectory());
                zipTask.setIncludes(this.getArchiveDirectory().getName() + ALL_FILES);
                zipTask.execute();
                break;
            }
            case TAR: {
                this.createTarFile(project, finalFile);
                break;
            }
            case TAR_GZ: {
                File tarFile = new File(this.mojo.getOutputDirectory(), ((ArchiveTarget)this.target).getId() + DOT_TAR);
                this.createTarFile(project, tarFile);
                GZip gzipTask = new GZip();
                gzipTask.setProject(project);
                gzipTask.setDestfile(finalFile);
                gzipTask.setSrc(tarFile);
                gzipTask.execute();
                if (tarFile.delete()) break;
                IOException e = new IOException(I18n.err((I18n)I18n.ERR_113_COULD_NOT_DELETE_FILE_OR_DIRECTORY, (Object[])new Object[]{tarFile}));
                this.log.error((CharSequence)e.getLocalizedMessage());
                throw new MojoFailureException(e.getMessage());
            }
            case TAR_BZ2: {
                File tarFile = new File(this.mojo.getOutputDirectory(), ((ArchiveTarget)this.target).getId() + DOT_TAR);
                this.createTarFile(project, finalFile);
                BZip2 bzip2Task = new BZip2();
                bzip2Task.setProject(project);
                bzip2Task.setDestfile(finalFile);
                bzip2Task.setSrc(tarFile);
                bzip2Task.execute();
                if (tarFile.delete()) break;
                IOException e = new IOException(I18n.err((I18n)I18n.ERR_113_COULD_NOT_DELETE_FILE_OR_DIRECTORY, (Object[])new Object[]{tarFile}));
                this.log.error((CharSequence)e.getLocalizedMessage());
                throw new MojoFailureException(e.getMessage());
            }
            default: {
                IOException e = new IOException("Cannot determinate the archive type. Only \"tar\", \"tar.gz\", \"tar.bz2\" and \"zip\" are accepted : " + archiveType);
                this.log.error((CharSequence)e.getLocalizedMessage());
                throw new MojoFailureException(e.getMessage());
            }
        }
        this.log.info((CharSequence)("=> Archive Installer (" + archiveType + ") archive generated at " + finalFile));
    }

    private void createTarFile(Project project, File tarFile) {
        Tar tarTask = new Tar();
        tarTask.setProject(project);
        tarTask.setDestFile(tarFile);
        Tar.TarFileSet nonExecutables = tarTask.createTarFileSet();
        nonExecutables.setDir(this.getTargetDirectory());
        nonExecutables.setIncludes(this.getArchiveDirectory().getName() + ALL_FILES);
        nonExecutables.setExcludes(this.getArchiveDirectory().getName() + "/**/*.sh");
        Tar.TarFileSet executables = tarTask.createTarFileSet();
        executables.setDir(this.getTargetDirectory());
        executables.setIncludes(this.getArchiveDirectory().getName() + "/**/*.sh");
        executables.setFileMode("755");
        tarTask.execute();
    }

    private boolean verifyTarget() {
        String archiveType = ((ArchiveTarget)this.target).getArchiveType();
        if (archiveType == null) {
            this.log.warn((CharSequence)"Archive type is null!");
            this.log.warn((CharSequence)"The build will continue, but please check the archive type of this installer target");
            return false;
        }
        ArchiveType type = ArchiveType.getType(archiveType);
        if (type != ArchiveType.ZIP && type != ArchiveType.TAR && type != ArchiveType.TAR_GZ && type != ArchiveType.TAR_BZ2) {
            this.log.warn((CharSequence)("Archive type is unknwown (" + archiveType + ")!"));
            this.log.warn((CharSequence)"The build will continue, but please check the archive type of this installer target");
            return false;
        }
        return true;
    }

    @Override
    protected void initializeFilterProperties() {
        super.initializeFilterProperties();
    }

    @Override
    public File getInstallationDirectory() {
        return this.getArchiveDirectory();
    }

    @Override
    public File getInstanceDirectory() {
        return new File(this.getArchiveDirectory(), "instances/default");
    }

    private File getArchiveDirectory() {
        return new File(this.getTargetDirectory(), "apacheds-" + this.mojo.getProject().getVersion());
    }
}

