/*
 * Decompiled with CFR 0.152.
 */
package org.apache.directory.server.installers.deb;

import java.io.File;
import java.io.IOException;
import org.apache.directory.server.i18n.I18n;
import org.apache.directory.server.installers.AbstractMojoCommand;
import org.apache.directory.server.installers.GenerateMojo;
import org.apache.directory.server.installers.MojoHelperUtils;
import org.apache.directory.server.installers.deb.DebTarget;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.tools.ant.taskdefs.Execute;

public class DebInstallerCommand
extends AbstractMojoCommand<DebTarget> {
    public DebInstallerCommand(GenerateMojo mojo, DebTarget target) {
        super(mojo, target);
        this.initializeFilterProperties();
    }

    @Override
    public void execute() throws MojoExecutionException, MojoFailureException {
        if (!this.verifyTarget()) {
            return;
        }
        this.log.info((CharSequence)"  Creating Deb installer...");
        if (!this.getTargetDirectory().mkdirs()) {
            IOException e = new IOException(I18n.err((I18n)I18n.ERR_112_COULD_NOT_CREATE_DIRECORY, (Object[])new Object[]{this.getTargetDirectory()}));
            this.log.error((CharSequence)e.getLocalizedMessage());
            throw new MojoFailureException(e.getMessage());
        }
        this.log.info((CharSequence)"    Copying Deb installer files");
        try {
            this.createLayouts();
            File debEtcInitdDirectory = new File(this.getDebDirectory(), "etc/init.d");
            if (!debEtcInitdDirectory.mkdirs()) {
                IOException e = new IOException(I18n.err((I18n)I18n.ERR_112_COULD_NOT_CREATE_DIRECORY, (Object[])new Object[]{debEtcInitdDirectory}));
                this.log.error((CharSequence)e.getLocalizedMessage());
                throw new MojoFailureException(e.getMessage());
            }
            MojoHelperUtils.copyAsciiFile(this.mojo, this.filterProperties, this.getClass().getResourceAsStream("/org/apache/directory/server/installers/etc-initd-script"), new File(debEtcInitdDirectory, "apacheds-" + this.mojo.getProject().getVersion() + "-default"), true);
        }
        catch (Exception e) {
            this.log.error((CharSequence)e.getMessage());
            throw new MojoFailureException("Failed to copy Deb installer files.");
        }
        File debDebianDirectory = new File(this.getDebDirectory(), "DEBIAN");
        if (!debDebianDirectory.mkdirs()) {
            IOException e = new IOException(I18n.err((I18n)I18n.ERR_112_COULD_NOT_CREATE_DIRECORY, (Object[])new Object[]{debDebianDirectory}));
            this.log.error((CharSequence)e.getLocalizedMessage());
            throw new MojoFailureException(e.getMessage());
        }
        try {
            MojoHelperUtils.copyAsciiFile(this.mojo, this.filterProperties, this.getClass().getResourceAsStream("control"), new File(debDebianDirectory, "control"), true);
            MojoHelperUtils.copyAsciiFile(this.mojo, this.filterProperties, this.getClass().getResourceAsStream("postinst"), new File(debDebianDirectory, "postinst"), true);
            MojoHelperUtils.copyAsciiFile(this.mojo, this.filterProperties, this.getClass().getResourceAsStream("prerm"), new File(debDebianDirectory, "prerm"), true);
        }
        catch (IOException e) {
            this.log.error((CharSequence)e.getMessage());
            throw new MojoFailureException("Failed to copy DEB 'control' file.");
        }
        MojoHelperUtils.exec(new String[]{"chmod", "755", new File(debDebianDirectory, "postinst").toString()}, debDebianDirectory, false);
        MojoHelperUtils.exec(new String[]{"chmod", "755", new File(debDebianDirectory, "prerm").toString()}, debDebianDirectory, false);
        this.log.info((CharSequence)"    Generating Deb installer");
        String finalName = ((DebTarget)this.target).getFinalName();
        if (!finalName.endsWith(".deb")) {
            finalName = finalName + ".deb";
        }
        Execute createDebTask = new Execute();
        String[] cmd = new String[]{this.mojo.getDpkgUtility().getAbsolutePath(), "-b", this.getTargetDirectory().getName() + "/" + this.getDebDirectory().getName(), finalName};
        createDebTask.setCommandline(cmd);
        createDebTask.setWorkingDirectory(this.mojo.getOutputDirectory());
        try {
            createDebTask.execute();
        }
        catch (IOException e) {
            this.log.error((CharSequence)e.getMessage());
            throw new MojoFailureException("Failed while trying to generate the DEB package: " + e.getMessage());
        }
        this.log.info((CharSequence)("Debian DEB package generated at " + new File(this.mojo.getOutputDirectory(), finalName)));
    }

    private boolean verifyTarget() {
        if (!((DebTarget)this.target).isOsNameLinux()) {
            this.log.warn((CharSequence)"Deb package installer can only be targeted for Linux platforms!");
            this.log.warn((CharSequence)"The build will continue, but please check the the platform of this installer target");
            return false;
        }
        if (!"Linux".equalsIgnoreCase(System.getProperty("os.name")) && !"Mac OS X".equalsIgnoreCase(System.getProperty("os.name"))) {
            this.log.warn((CharSequence)"Deb package installer can only be built on a machine running Linux or Mac OS X!");
            this.log.warn((CharSequence)"The build will continue, generation of this target is skipped.");
            return false;
        }
        if (!this.mojo.getDpkgUtility().exists()) {
            this.log.warn((CharSequence)("Cannot find dpkg utility at this location: " + this.mojo.getDpkgUtility()));
            this.log.warn((CharSequence)"The build will continue, but please check the location of your dpkg utility.");
            return false;
        }
        return true;
    }

    @Override
    protected void initializeFilterProperties() {
        super.initializeFilterProperties();
        String version = this.mojo.getProject().getVersion();
        if (version != null) {
            if (version.endsWith("-SNAPSHOT")) {
                this.filterProperties.put("version.debian", version + "1");
            } else {
                this.filterProperties.put("version.debian", version);
            }
        }
        this.filterProperties.put("arch", ((DebTarget)this.target).getOsArch());
        this.filterProperties.put("installation.directory", "/opt/apacheds-" + this.mojo.getProject().getVersion());
        this.filterProperties.put("instances.directory", "/var/lib/apacheds-" + this.mojo.getProject().getVersion());
        this.filterProperties.put("user", "apacheds");
        this.filterProperties.put("wrapper.java.command", "# wrapper.java.command=<path-to-java-executable>");
        this.filterProperties.put("double.quote", "");
        this.filterProperties.put("default.instance.name", "default");
        this.filterProperties.put("installation.directory", "/opt/apacheds-" + this.mojo.getProject().getVersion());
    }

    @Override
    public File getInstallationDirectory() {
        return new File(this.getDebDirectory(), "opt/apacheds-" + this.mojo.getProject().getVersion());
    }

    @Override
    public File getInstanceDirectory() {
        return new File(this.getDebDirectory(), "var/lib/apacheds-" + this.mojo.getProject().getVersion() + "/default");
    }

    private File getDebDirectory() {
        return new File(this.getTargetDirectory(), "deb");
    }
}

