/*
 * Decompiled with CFR 0.152.
 */
package org.apache.directory.server.installers.archive;

import java.io.File;
import java.io.IOException;
import org.apache.directory.server.i18n.I18n;
import org.apache.directory.server.installers.AbstractMojoCommand;
import org.apache.directory.server.installers.GenerateMojo;
import org.apache.directory.server.installers.MojoHelperUtils;
import org.apache.directory.server.installers.archive.ArchiveTarget;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.tools.ant.Project;
import org.apache.tools.ant.taskdefs.BZip2;
import org.apache.tools.ant.taskdefs.GZip;
import org.apache.tools.ant.taskdefs.Tar;
import org.apache.tools.ant.taskdefs.Zip;
import org.codehaus.plexus.util.FileUtils;

public class ArchiveInstallerCommand
extends AbstractMojoCommand<ArchiveTarget> {
    public ArchiveInstallerCommand(GenerateMojo mojo, ArchiveTarget target) {
        super(mojo, target);
        this.initializeFilterProperties();
    }

    @Override
    public void execute() throws MojoExecutionException, MojoFailureException {
        if (!this.verifyTarget()) {
            return;
        }
        String archiveType = ((ArchiveTarget)this.target).getArchiveType();
        this.log.info((CharSequence)("  Creating " + archiveType + " archive..."));
        if (!this.getTargetDirectory().mkdirs()) {
            IOException e = new IOException(I18n.err((I18n)I18n.ERR_112_COULD_NOT_CREATE_DIRECORY, (Object[])new Object[]{this.getTargetDirectory()}));
            this.log.error((CharSequence)e.getLocalizedMessage());
            throw new MojoFailureException(e.getMessage());
        }
        this.log.info((CharSequence)"    Copying archive files");
        try {
            this.createLayouts(false);
            MojoHelperUtils.copyAsciiFile(this.mojo, this.filterProperties, this.getClass().getResourceAsStream("apacheds.bat"), new File(this.getInstallationLayout().getBinDirectory(), "apacheds.bat"), false);
            MojoHelperUtils.copyAsciiFile(this.mojo, this.filterProperties, this.getClass().getResourceAsStream("apacheds.sh"), new File(this.getInstallationLayout().getBinDirectory(), "apacheds.sh"), false);
            MojoHelperUtils.copyAsciiFile(this.mojo, this.filterProperties, this.getClass().getResourceAsStream("cpappend.bat"), new File(this.getInstallationLayout().getBinDirectory(), "cpappend.bat"), false);
            FileUtils.deleteDirectory((File)this.getInstallationLayout().getConfDirectory());
            File wrapperConf = new File(this.getInstanceLayout().getConfDirectory(), "wrapper.conf");
            if (!wrapperConf.delete()) {
                throw new IOException(I18n.err((I18n)I18n.ERR_113_COULD_NOT_DELETE_FILE_OR_DIRECTORY, (Object[])new Object[]{wrapperConf}));
            }
            FileUtils.deleteDirectory((File)this.getInstanceLayout().getRunDirectory());
        }
        catch (Exception e) {
            this.log.error((CharSequence)e.getMessage());
            throw new MojoFailureException("Failed to copy archive files.");
        }
        this.log.info((CharSequence)"    Generating archive");
        String finalName = ((ArchiveTarget)this.target).getFinalName();
        if (!finalName.endsWith(archiveType)) {
            finalName = finalName + archiveType;
        }
        File finalFile = new File(this.mojo.getOutputDirectory(), finalName);
        Project project = new Project();
        project.setBaseDir(this.mojo.getOutputDirectory());
        if (archiveType.equalsIgnoreCase("zip")) {
            Zip zipTask = new Zip();
            zipTask.setProject(project);
            zipTask.setDestFile(finalFile);
            zipTask.setBasedir(this.getTargetDirectory());
            zipTask.setIncludes(this.getArchiveDirectory().getName() + "/**");
            zipTask.execute();
        } else if (archiveType.equalsIgnoreCase("tar")) {
            Tar tarTask = new Tar();
            tarTask.setProject(project);
            tarTask.setDestFile(finalFile);
            tarTask.setBasedir(this.getTargetDirectory());
            tarTask.setIncludes(this.getArchiveDirectory().getName() + "/**");
            tarTask.execute();
        } else if (archiveType.equalsIgnoreCase("tar.gz")) {
            File tarFile = new File(this.mojo.getOutputDirectory(), ((ArchiveTarget)this.target).getId() + ".tar");
            Tar tarTask = new Tar();
            tarTask.setProject(project);
            tarTask.setDestFile(tarFile);
            tarTask.setBasedir(this.getTargetDirectory());
            tarTask.setIncludes(this.getArchiveDirectory().getName() + "/**");
            tarTask.execute();
            GZip gzipTask = new GZip();
            gzipTask.setProject(project);
            gzipTask.setDestfile(finalFile);
            gzipTask.setSrc(tarFile);
            gzipTask.execute();
            if (!tarFile.delete()) {
                IOException e = new IOException(I18n.err((I18n)I18n.ERR_113_COULD_NOT_DELETE_FILE_OR_DIRECTORY, (Object[])new Object[]{tarFile}));
                this.log.error((CharSequence)e.getLocalizedMessage());
                throw new MojoFailureException(e.getMessage());
            }
        } else if (archiveType.equalsIgnoreCase("tar.bz2")) {
            File tarFile = new File(this.mojo.getOutputDirectory(), ((ArchiveTarget)this.target).getId() + ".tar");
            Tar tarTask = new Tar();
            tarTask.setProject(project);
            tarTask.setDestFile(tarFile);
            tarTask.setBasedir(this.getTargetDirectory());
            tarTask.setIncludes(this.getArchiveDirectory().getName() + "/**");
            tarTask.execute();
            BZip2 bzip2Task = new BZip2();
            bzip2Task.setProject(project);
            bzip2Task.setDestfile(finalFile);
            bzip2Task.setSrc(tarFile);
            bzip2Task.execute();
            if (!tarFile.delete()) {
                IOException e = new IOException(I18n.err((I18n)I18n.ERR_113_COULD_NOT_DELETE_FILE_OR_DIRECTORY, (Object[])new Object[]{tarFile}));
                this.log.error((CharSequence)e.getLocalizedMessage());
                throw new MojoFailureException(e.getMessage());
            }
        }
        this.log.info((CharSequence)("=> Archive Installer (" + archiveType + ") archive generated at " + finalFile));
    }

    private boolean verifyTarget() {
        String archiveType = ((ArchiveTarget)this.target).getArchiveType();
        if (archiveType == null) {
            this.log.warn((CharSequence)"Archive type is null!");
            this.log.warn((CharSequence)"The build will continue, but please check the archive type of this installer target");
            return false;
        }
        if (!(archiveType.equalsIgnoreCase("zip") || archiveType.equalsIgnoreCase("tar") || archiveType.equalsIgnoreCase("tar.gz") || archiveType.equalsIgnoreCase("tar.bz2"))) {
            this.log.warn((CharSequence)("Archive type is unknwown (" + archiveType + ")!"));
            this.log.warn((CharSequence)"The build will continue, but please check the archive type of this installer target");
            return false;
        }
        return true;
    }

    @Override
    protected void initializeFilterProperties() {
        super.initializeFilterProperties();
    }

    @Override
    public File getInstallationDirectory() {
        return this.getArchiveDirectory();
    }

    @Override
    public File getInstanceDirectory() {
        return new File(this.getArchiveDirectory(), "instances/default");
    }

    private File getArchiveDirectory() {
        return new File(this.getTargetDirectory(), "apacheds-" + this.mojo.getProject().getVersion());
    }
}

