/*
 * Decompiled with CFR 0.152.
 */
package org.apache.directory.server.installers.rpm;

import java.io.File;
import java.io.IOException;
import java.util.Properties;
import org.apache.directory.server.installers.AbstractMojoCommand;
import org.apache.directory.server.installers.GenerateMojo;
import org.apache.directory.server.installers.MojoHelperUtils;
import org.apache.directory.server.installers.rpm.RpmTarget;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.codehaus.plexus.util.FileUtils;

public class RpmInstallerCommand
extends AbstractMojoCommand<RpmTarget> {
    public RpmInstallerCommand(GenerateMojo mojo, RpmTarget target) {
        super(mojo, target);
        this.initializeFilterProperties();
    }

    @Override
    public void execute() throws MojoExecutionException, MojoFailureException {
        if (!this.verifyTarget()) {
            return;
        }
        this.log.info((CharSequence)"  Creating Rpm installer...");
        this.getTargetDirectory().mkdirs();
        this.log.info((CharSequence)"    Copying Rpm installer files");
        try {
            new File(this.getTargetDirectory(), "BUILD").mkdirs();
            new File(this.getTargetDirectory(), "RPMS").mkdirs();
            new File(this.getTargetDirectory(), "SOURCES").mkdirs();
            new File(this.getTargetDirectory(), "SPECS").mkdirs();
            new File(this.getTargetDirectory(), "SRPMS").mkdirs();
            this.createLayouts();
            MojoHelperUtils.copyAsciiFile(this.mojo, this.filterProperties, this.getClass().getResourceAsStream("/org/apache/directory/server/installers/etc-initd-script"), new File(this.getAdsSourcesDirectory(), "etc-initd-script"), true);
            this.createSpecFile();
            MojoHelperUtils.exec(new String[]{"tar", "-zcf", "apacheds-" + this.getVersion() + ".tar.gz", "apacheds-" + this.getVersion()}, new File(this.getTargetDirectory(), "/SOURCES"), false);
        }
        catch (Exception e) {
            this.log.error((CharSequence)e.getMessage());
            throw new MojoFailureException("Failed to copy Rpm installer files.");
        }
        this.log.info((CharSequence)"    Generating Rpm installer");
        MojoHelperUtils.exec(new String[]{this.mojo.getRpmbuildUtility().getAbsolutePath(), "--quiet", "-ba", "--target", ((RpmTarget)this.target).getOsArch() + "-linux", "--define", "_topdir " + this.getTargetDirectory(), "--define", "_tmppath /tmp", "SPECS/apacheds.spec"}, this.getTargetDirectory(), false);
        try {
            String rpmName = "apacheds-" + this.getVersion() + "-1." + ((RpmTarget)this.target).getOsArch() + ".rpm";
            String finalName = ((RpmTarget)this.target).getFinalName();
            if (!finalName.endsWith(".rpm")) {
                finalName = finalName + ".rpm";
            }
            File finalFile = new File(this.mojo.getOutputDirectory(), finalName);
            FileUtils.copyFile((File)new File(this.getTargetDirectory(), "RPMS/" + ((RpmTarget)this.target).getOsArch() + "/" + rpmName), (File)finalFile);
            this.log.info((CharSequence)("=> RPM generated at " + finalFile));
        }
        catch (IOException e) {
            throw new MojoFailureException("Failed to copy generated Rpm installer file.");
        }
    }

    private boolean verifyTarget() {
        if (!((RpmTarget)this.target).isOsNameLinux()) {
            this.log.warn((CharSequence)"Rpm installer can only be targeted for Linux platforms!");
            this.log.warn((CharSequence)"The build will continue, but please check the the platform of this installer target");
            return false;
        }
        if (!"Linux".equalsIgnoreCase(System.getProperty("os.name")) && !"Mac OS X".equalsIgnoreCase(System.getProperty("os.name"))) {
            this.log.warn((CharSequence)"Rpm package installer can only be built on a machine running Linux or Mac OS X!");
            this.log.warn((CharSequence)"The build will continue, generation of this target is skipped.");
            return false;
        }
        if (!this.mojo.getRpmbuildUtility().exists()) {
            this.log.warn((CharSequence)("Cannot find rpmbuild utility at this location: " + this.mojo.getRpmbuildUtility()));
            this.log.warn((CharSequence)"The build will continue, but please check the location of your rpmbuild utility.");
            return false;
        }
        return true;
    }

    @Override
    protected void initializeFilterProperties() {
        super.initializeFilterProperties();
        this.filterProperties.put("installation.directory", "/opt/apacheds-" + this.getVersion());
        this.filterProperties.put("instances.directory", "/var/lib/apacheds-" + this.getVersion());
        this.filterProperties.put("default.instance.name", "default");
        this.filterProperties.put("user", "apacheds");
        this.filterProperties.put("wrapper.java.command", "# wrapper.java.command=<path-to-java-executable>");
        this.filterProperties.put("double.quote", "");
        this.filterProperties.put("version", this.getVersion());
    }

    private void createSpecFile() throws IOException {
        StringBuilder installLibs = new StringBuilder();
        StringBuilder filesLibs = new StringBuilder();
        File libDirectory = this.getInstallationLayout().getLibDirectory();
        if (libDirectory.exists()) {
            for (File file : libDirectory.listFiles()) {
                if (!file.isFile()) continue;
                installLibs.append("install -m 644 " + this.getBuidDirectory() + "/%{name}-%{version}/server/lib/" + file.getName() + " $RPM_BUILD_ROOT%{adshome}/lib/" + file.getName() + "\n");
                filesLibs.append("%{adshome}/lib/" + file.getName() + "\n");
            }
        }
        Properties properties = new Properties();
        properties.put("version", this.getVersion());
        properties.put("build.dir", this.getBuidDirectory());
        properties.put("install.libs", installLibs.toString());
        properties.put("files.libs", filesLibs.toString());
        MojoHelperUtils.copyAsciiFile(this.mojo, properties, this.getClass().getResourceAsStream("apacheds.spec"), new File(this.getTargetDirectory(), "SPECS/apacheds.spec"), true);
    }

    private File getAdsSourcesDirectory() {
        return new File(this.getTargetDirectory(), "SOURCES/apacheds-" + this.getVersion());
    }

    @Override
    public File getInstallationDirectory() {
        return new File(this.getAdsSourcesDirectory(), "server");
    }

    @Override
    public File getInstanceDirectory() {
        return new File(this.getAdsSourcesDirectory(), "instances/default");
    }

    private String getVersion() {
        return this.mojo.getProject().getVersion().replace('-', '_');
    }

    private String getBuidDirectory() {
        return this.getTargetDirectory().getAbsolutePath() + "/BUILD";
    }
}

