/*
 * Decompiled with CFR 0.152.
 */
package org.apache.directory.server.installers.nsis;

import java.io.File;
import java.io.IOException;
import org.apache.directory.server.installers.AbstractMojoCommand;
import org.apache.directory.server.installers.GenerateMojo;
import org.apache.directory.server.installers.MojoHelperUtils;
import org.apache.directory.server.installers.nsis.NsisTarget;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.tools.ant.taskdefs.Execute;

public class NsisInstallerCommand
extends AbstractMojoCommand<NsisTarget> {
    private static final String INSTALLATION_FILES = "installationFiles";

    public NsisInstallerCommand(GenerateMojo mojo, NsisTarget target) {
        super(mojo, target);
        this.initializeFilterProperties();
    }

    @Override
    public void execute() throws MojoExecutionException, MojoFailureException {
        if (!this.verifyTarget()) {
            return;
        }
        this.log.info((CharSequence)"  Creating NSIS installer...");
        File targetDirectory = this.getTargetDirectory();
        targetDirectory.mkdirs();
        this.log.info((CharSequence)"    Copying NSIS installer files");
        File installerFile = new File(targetDirectory, "installer.nsi");
        try {
            this.createLayouts();
            MojoHelperUtils.copyBinaryFile(this.getClass().getResourceAsStream("Manage ApacheDS.exe"), new File(this.getInstallationDirectory(), "Manage ApacheDS.exe"));
            MojoHelperUtils.copyBinaryFile(this.getClass().getResourceAsStream("header.bmp"), new File(targetDirectory, "header.bmp"));
            MojoHelperUtils.copyBinaryFile(this.getClass().getResourceAsStream("welcome.bmp"), new File(targetDirectory, "welcome.bmp"));
            MojoHelperUtils.copyBinaryFile(this.getClass().getResourceAsStream("installer.ico"), new File(targetDirectory, "installer.ico"));
            MojoHelperUtils.copyBinaryFile(this.getClass().getResourceAsStream("uninstaller.ico"), new File(targetDirectory, "uninstaller.ico"));
            MojoHelperUtils.copyAsciiFile(this.mojo, this.filterProperties, this.getClass().getResourceAsStream("installer.nsi"), installerFile, true);
        }
        catch (Exception e) {
            this.log.error((CharSequence)e.getMessage());
            throw new MojoFailureException("Failed to copy NSIS installer files.");
        }
        this.log.info((CharSequence)"    Generating NSIS installer");
        Execute createPkgTask = new Execute();
        String[] cmd = new String[]{this.mojo.getMakensisUtility().getAbsolutePath(), "-V2", installerFile.getAbsolutePath()};
        createPkgTask.setCommandline(cmd);
        createPkgTask.setWorkingDirectory(targetDirectory);
        try {
            createPkgTask.execute();
        }
        catch (IOException e) {
            this.log.error((CharSequence)e.getMessage());
            throw new MojoFailureException("Failed while trying to generate the NSIS installer: " + e.getMessage());
        }
        this.log.info((CharSequence)("=> NSIS installer generated at " + new File(this.mojo.getOutputDirectory(), this.filterProperties.getProperty("finalname"))));
    }

    private boolean verifyTarget() {
        if (!((NsisTarget)this.target).getOsName().equalsIgnoreCase("Windows")) {
            this.log.warn((CharSequence)"NSIS installer can only be targeted for Windows platform!");
            this.log.warn((CharSequence)"The build will continue, but please check the the platform of this installer target.");
            return false;
        }
        if (!this.mojo.getMakensisUtility().exists()) {
            this.log.warn((CharSequence)("Cannot find NSIS compiler at this location: " + this.mojo.getMakensisUtility()));
            this.log.warn((CharSequence)"The build will continue, but please check the location of your makensis executable.");
            return false;
        }
        return true;
    }

    @Override
    protected void initializeFilterProperties() {
        super.initializeFilterProperties();
        String finalName = ((NsisTarget)this.target).getFinalName();
        if (!finalName.endsWith(".exe")) {
            finalName = finalName + ".exe";
        }
        this.filterProperties.put("finalname", ((NsisTarget)this.target).getFinalName());
        this.filterProperties.put(INSTALLATION_FILES, INSTALLATION_FILES);
        this.filterProperties.put("instancesFiles", "instancesFiles");
        this.filterProperties.put("wrapper.java.command", "wrapper.java.command=@java.home@\\bin\\java.exe");
        this.filterProperties.put("double.quote", "\"");
    }

    @Override
    public File getInstallationDirectory() {
        return new File(this.getTargetDirectory(), INSTALLATION_FILES);
    }

    @Override
    public File getInstanceDirectory() {
        return new File(this.getTargetDirectory(), "instancesFiles/default");
    }
}

