/*
 * Decompiled with CFR 0.152.
 */
package org.apache.directory.mavibot.btree;

import java.io.File;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.lang.reflect.Array;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import java.util.TreeSet;
import org.apache.commons.io.FileUtils;
import org.apache.directory.api.ldap.model.csn.CsnFactory;
import org.apache.directory.api.ldap.model.entry.Attribute;
import org.apache.directory.api.ldap.model.entry.DefaultAttribute;
import org.apache.directory.api.ldap.model.entry.Entry;
import org.apache.directory.api.ldap.model.entry.Value;
import org.apache.directory.api.ldap.model.ldif.LdifEntry;
import org.apache.directory.api.ldap.model.name.Dn;
import org.apache.directory.api.ldap.model.name.Rdn;
import org.apache.directory.api.ldap.model.schema.AttributeType;
import org.apache.directory.api.ldap.model.schema.SchemaManager;
import org.apache.directory.api.ldap.schemaloader.JarLdifSchemaLoader;
import org.apache.directory.api.ldap.schemamanager.impl.DefaultSchemaManager;
import org.apache.directory.api.util.DateUtils;
import org.apache.directory.mavibot.btree.AbstractPage;
import org.apache.directory.mavibot.btree.BTree;
import org.apache.directory.mavibot.btree.BTreeFactory;
import org.apache.directory.mavibot.btree.BTreeHeader;
import org.apache.directory.mavibot.btree.DnTuple;
import org.apache.directory.mavibot.btree.FastLdifReader;
import org.apache.directory.mavibot.btree.IndexTupleComparator;
import org.apache.directory.mavibot.btree.KeyHolder;
import org.apache.directory.mavibot.btree.Option;
import org.apache.directory.mavibot.btree.Page;
import org.apache.directory.mavibot.btree.PageHolder;
import org.apache.directory.mavibot.btree.PersistedBTree;
import org.apache.directory.mavibot.btree.PersistedLeaf;
import org.apache.directory.mavibot.btree.PersistedNode;
import org.apache.directory.mavibot.btree.PersistedPageHolder;
import org.apache.directory.mavibot.btree.PersistedValueHolder;
import org.apache.directory.mavibot.btree.RecordManager;
import org.apache.directory.mavibot.btree.SchemaAwareLdifReader;
import org.apache.directory.mavibot.btree.Tuple;
import org.apache.directory.mavibot.btree.TupleCursor;
import org.apache.directory.mavibot.btree.ValueHolder;
import org.apache.directory.mavibot.btree.util.Strings;
import org.apache.directory.server.core.partition.impl.btree.mavibot.MavibotIndex;
import org.apache.directory.server.core.partition.impl.btree.mavibot.MavibotPartition;
import org.apache.directory.server.core.shared.DefaultDnFactory;
import org.apache.directory.server.xdbm.Index;
import org.apache.directory.server.xdbm.ParentIdAndRdn;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MavibotPartitionBuilder {
    private int numKeysInNode = 16;
    private Dn suffixDn;
    private String outputDir = "/tmp/builder";
    private RecordManager rm;
    private SchemaManager schemaManager;
    private CsnFactory csnFactory;
    private RandomAccessFile raf;
    private String ldifFile;
    private String masterTableName = "master";
    private List<String> indexAttributes = new ArrayList<String>();
    private int totalEntries = 0;
    private static final Logger LOG = LoggerFactory.getLogger(MavibotPartitionBuilder.class);

    public MavibotPartitionBuilder(String ldifFile, String outputDir) {
        this(ldifFile, outputDir, 16, 1);
    }

    public MavibotPartitionBuilder(String ldifFile, String outputDir, int numKeysInNode, int rid) {
        this.ldifFile = ldifFile;
        this.outputDir = outputDir;
        this.numKeysInNode = numKeysInNode;
        this.csnFactory = new CsnFactory(rid);
    }

    private BTree build(Iterator<Tuple> sortedTupleItr, String name) throws Exception {
        PersistedBTree btree = (PersistedBTree)this.rm.getManagedTree(name);
        long newRevision = btree.getRevision() + 1L;
        btree.setRevision(newRevision);
        ArrayList<Page> lstLeaves = new ArrayList<Page>();
        ArrayList<Page> lstNodes = new ArrayList<Page>();
        int totalLeaves = 1;
        int totalTuples = 0;
        Page leaf1 = BTreeFactory.createLeaf(btree, newRevision, this.numKeysInNode);
        lstLeaves.add(leaf1);
        int leafIndex = 0;
        while (sortedTupleItr.hasNext()) {
            Tuple tuple = sortedTupleItr.next();
            BTreeFactory.setKey(btree, leaf1, leafIndex, tuple.getKey());
            Object val = tuple.getValue();
            PersistedValueHolder<Object> eh = null;
            if (btree.allowDuplicates) {
                Set s = (Set)val;
                val = s.toArray();
                eh = new PersistedValueHolder<Object>(btree, (Object[])val);
            } else {
                eh = new PersistedValueHolder<Object>(btree, val);
            }
            BTreeFactory.setValue(btree, leaf1, leafIndex, eh);
            ++totalTuples;
            if (++leafIndex != this.numKeysInNode) continue;
            leafIndex = 0;
            PageHolder pageHolder = this.rm.writePage(btree, leaf1, newRevision);
            if (totalLeaves % (this.numKeysInNode + 1) == 0) {
                this.cleanLastLeaf(lstLeaves, btree, newRevision);
                if (!lstLeaves.isEmpty()) {
                    Page node = this.attachNodes(lstLeaves, btree);
                    lstNodes.add(node);
                    lstLeaves.clear();
                }
            }
            ((PersistedLeaf)leaf1)._clearValues_();
            leaf1 = BTreeFactory.createLeaf(btree, newRevision, this.numKeysInNode);
            ++totalLeaves;
            lstLeaves.add(leaf1);
        }
        if (!lstLeaves.isEmpty()) {
            this.cleanLastLeaf(lstLeaves, btree, newRevision);
            if (!lstLeaves.isEmpty()) {
                Page node = this.attachNodes(lstLeaves, btree);
                lstNodes.add(node);
                lstLeaves.clear();
            }
        }
        if (lstNodes.isEmpty()) {
            return btree;
        }
        Page rootPage = this.attachNodes(lstNodes, btree);
        lstNodes.clear();
        Page oldRoot = btree.getRootPage();
        btree.setNbElems(totalTuples);
        long newRootPageOffset = ((AbstractPage)rootPage).getOffset();
        System.out.println("replacing old offset " + btree.getRootPageOffset() + " of the BTree " + name + " with " + newRootPageOffset);
        BTreeHeader header = btree.getBtreeHeader();
        header.setRootPage(rootPage);
        header.setRevision(btree.getRevision());
        header.setNbElems(btree.getNbElems());
        long newBtreeHeaderOffset = this.rm.writeBtreeHeader(btree, header);
        this.rm.addInBtreeOfBtrees(name, btree.getRevision(), newBtreeHeaderOffset);
        btree.storeRevision(header, this.rm.isKeepRevisions());
        this.rm.freePages(btree, btree.getRevision(), Arrays.asList(oldRoot));
        return btree;
    }

    private void cleanLastLeaf(List<Page> lstLeaves, BTree btree, long newRevision) throws IOException {
        if (lstLeaves.isEmpty()) {
            return;
        }
        PersistedLeaf lastLeaf = (PersistedLeaf)lstLeaves.get(lstLeaves.size() - 1);
        if (lastLeaf.keys[0] == null) {
            lstLeaves.remove(lastLeaf);
            return;
        }
        for (int i = 0; i < lastLeaf.nbElems; ++i) {
            int n;
            if (lastLeaf.keys[i] != null) continue;
            lastLeaf.nbElems = n = i;
            KeyHolder[] keys = lastLeaf.keys;
            lastLeaf.keys = (KeyHolder[])Array.newInstance(KeyHolder.class, n);
            System.arraycopy(keys, 0, lastLeaf.keys, 0, n);
            ValueHolder<V>[] values = lastLeaf.values;
            lastLeaf.values = (ValueHolder[])Array.newInstance(ValueHolder.class, n);
            System.arraycopy(values, 0, lastLeaf.values, 0, n);
            PageHolder pageHolder = this.rm.writePage(btree, lastLeaf, newRevision);
            break;
        }
    }

    private Page attachNodes(List<Page> children, BTree btree) throws IOException {
        if (children.size() == 1) {
            return children.get(0);
        }
        ArrayList<Page> lstNodes = new ArrayList<Page>();
        int numChildren = this.numKeysInNode + 1;
        PersistedNode node = (PersistedNode)BTreeFactory.createNode(btree, btree.getRevision(), this.numKeysInNode);
        lstNodes.add(node);
        int i = 0;
        int attachedChildren = 0;
        for (Page p : children) {
            if (i != 0) {
                BTreeFactory.setKey(btree, node, i - 1, p.getLeftMostKey());
            }
            node.children[i] = new PersistedPageHolder(btree, p);
            ++i;
            if (++attachedChildren % numChildren != 0) continue;
            PageHolder pageHolder = this.rm.writePage(btree, node, 1L);
            if (children.size() == attachedChildren) break;
            i = 0;
            node = (PersistedNode)BTreeFactory.createNode(btree, btree.getRevision(), this.numKeysInNode);
            lstNodes.add(node);
        }
        AbstractPage lastNode = (AbstractPage)lstNodes.get(lstNodes.size() - 1);
        if (lastNode.keys[0] == null) {
            lstNodes.remove(lastNode);
            return this.attachNodes(lstNodes, btree);
        }
        for (int j = 0; j < lastNode.nbElems; ++j) {
            int n;
            if (lastNode.keys[j] != null) continue;
            lastNode.nbElems = n = j;
            KeyHolder<K>[] keys = lastNode.keys;
            lastNode.keys = (KeyHolder[])Array.newInstance(KeyHolder.class, n);
            System.arraycopy(keys, 0, lastNode.keys, 0, n);
            PageHolder pageHolder = this.rm.writePage(btree, lastNode, 1L);
            break;
        }
        return this.attachNodes(lstNodes, btree);
    }

    private static void calcLevels(int totalKeys, int numKeysPerPage) {
        int numLevels = 0;
        while (totalKeys > 1) {
            if (numLevels > 0) {
                ++numKeysPerPage;
            }
            int rem = totalKeys % numKeysPerPage;
            totalKeys /= numKeysPerPage;
            if (rem != 0) {
                ++totalKeys;
            }
            if (numLevels == 0) {
                System.out.println("Total Leaves " + totalKeys);
            } else {
                System.out.println("Total Nodes " + totalKeys);
            }
            ++numLevels;
        }
        System.out.println(numLevels);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private Set<DnTuple> getDnTuples() throws Exception {
        File file = new File(this.ldifFile);
        this.raf = new RandomAccessFile(file, "r");
        FastLdifReader reader = new FastLdifReader(file);
        TreeSet<DnTuple> sortedDnSet = new TreeSet<DnTuple>();
        while (reader.hasNext()) {
            LdifEntry entry = reader.next();
            DnTuple dt = reader.getDnTuple();
            dt.getDn().apply(this.schemaManager);
            sortedDnSet.add(dt);
        }
        reader.close();
        if (sortedDnSet.isEmpty()) {
            return Collections.EMPTY_SET;
        }
        Iterator itr = sortedDnSet.iterator();
        DnTuple root = (DnTuple)itr.next();
        root.setParent(null);
        this.suffixDn = root.getDn();
        System.out.println("Using " + this.suffixDn.getName() + " as the partition's root DN");
        HashMap<String, DnTuple> parentDnIdMap = new HashMap<String, DnTuple>();
        parentDnIdMap.put(root.getDn().getNormName(), root);
        DnTuple prevTuple = root;
        while (itr.hasNext()) {
            DnTuple dt = (DnTuple)itr.next();
            String parentDn = dt.getDn().getParent().getNormName();
            DnTuple parent = (DnTuple)parentDnIdMap.get(parentDn);
            if (parent == null) {
                if (!parentDn.equals(prevTuple.getDn().getNormName())) throw new IllegalStateException("Parent entry's ID of the entry " + dt.getDn().getName() + " not found.");
                parentDnIdMap.put(prevTuple.getDn().getNormName(), prevTuple);
                parent = prevTuple;
            } else if (!dt.getDn().isDescendantOf(prevTuple.getDn())) {
                parentDnIdMap.put(prevTuple.getDn().getNormName(), root);
            }
            dt.setParent(parent);
            parent.addChild();
            parent.addDecendent();
            prevTuple = dt;
        }
        return sortedDnSet;
    }

    private void buildMasterTable(Set<DnTuple> sortedDnSet) throws Exception {
        final TreeSet<DnTuple> idSortedSet = new TreeSet<DnTuple>(new Comparator<DnTuple>(){

            @Override
            public int compare(DnTuple dt0, DnTuple dt1) {
                return dt0.getId().compareTo(dt1.getId());
            }
        });
        idSortedSet.addAll(sortedDnSet);
        Iterator<Tuple> entryItr = new Iterator<Tuple>(){
            private Iterator<DnTuple> itr;
            final SchemaAwareLdifReader lar;
            final AttributeType atEntryUUID;
            final AttributeType atEntryParentID;
            final AttributeType atCsn;
            final AttributeType atCreator;
            final AttributeType atCreatedTime;
            final Attribute creatorsName;
            final Attribute createdTime;
            final Attribute entryCsn;
            final Tuple t;
            {
                this.itr = idSortedSet.iterator();
                this.lar = new SchemaAwareLdifReader(MavibotPartitionBuilder.this.schemaManager);
                this.atEntryUUID = MavibotPartitionBuilder.this.schemaManager.lookupAttributeTypeRegistry("entryUUID");
                this.atEntryParentID = MavibotPartitionBuilder.this.schemaManager.lookupAttributeTypeRegistry("entryParentId");
                this.atCsn = MavibotPartitionBuilder.this.schemaManager.lookupAttributeTypeRegistry("entryCSN");
                this.atCreator = MavibotPartitionBuilder.this.schemaManager.lookupAttributeTypeRegistry("creatorsName");
                this.atCreatedTime = MavibotPartitionBuilder.this.schemaManager.lookupAttributeTypeRegistry("createTimestamp");
                this.creatorsName = new DefaultAttribute(this.atCreator, "uid=admin,ou=system");
                this.createdTime = new DefaultAttribute(this.atCreatedTime, DateUtils.getGeneralizedTime());
                this.entryCsn = new DefaultAttribute(this.atCsn, MavibotPartitionBuilder.this.csnFactory.newInstance().toString());
                this.t = new Tuple();
            }

            @Override
            public boolean hasNext() {
                return this.itr.hasNext();
            }

            @Override
            public Tuple<String, Entry> next() {
                DnTuple dt = this.itr.next();
                this.t.setKey(dt.getId());
                try {
                    byte[] data = new byte[dt.getLen()];
                    MavibotPartitionBuilder.this.raf.seek(dt.getOffset());
                    MavibotPartitionBuilder.this.raf.readFully(data, 0, data.length);
                    Entry entry = this.lar.parseLdifEntry(Strings.utf8ToString(data)).getEntry();
                    entry.add(this.atEntryUUID, dt.getId());
                    entry.add(this.atEntryParentID, dt.getParentId());
                    entry.add(this.entryCsn);
                    entry.add(this.creatorsName);
                    entry.add(this.createdTime);
                    this.t.setValue(entry);
                }
                catch (Exception e) {
                    LOG.warn("Failed to parse the entry for the DnTuple " + dt);
                    throw new RuntimeException(e);
                }
                return this.t;
            }

            @Override
            public void remove() {
                throw new UnsupportedOperationException("Not supported");
            }
        };
        this.build(entryItr, this.masterTableName);
    }

    private void buildRdnIndex(Set<DnTuple> sortedDnSet) throws Exception {
        final TreeSet<DnTuple> parentIdRdnSortedSet = new TreeSet<DnTuple>(new Comparator<DnTuple>(){

            @Override
            public int compare(DnTuple dt0, DnTuple dt1) {
                int val = dt0.getParentId().compareTo(dt1.getParentId());
                if (val != 0) {
                    return val;
                }
                Rdn[] dt0Rdns = dt0.getDn().getRdns().toArray(new Rdn[0]);
                Rdn[] dt1Rdns = dt1.getDn().getRdns().toArray(new Rdn[0]);
                if (dt0Rdns.length == 1) {
                    val = dt0Rdns[0].getNormName().compareTo(dt1Rdns[0].getNormName());
                    return val;
                }
                for (int i = 0; i < dt0Rdns.length; ++i) {
                    val = dt0Rdns[i].getNormName().compareTo(dt1Rdns[i].getNormName());
                    if (val == 0) continue;
                    return val;
                }
                return 0;
            }
        });
        parentIdRdnSortedSet.addAll(sortedDnSet);
        Iterator<Tuple> parentIdAndRdnFwdItr = new Iterator<Tuple>(){
            Iterator<DnTuple> itr;
            {
                this.itr = parentIdRdnSortedSet.iterator();
            }

            @Override
            public void remove() {
            }

            @Override
            public Tuple next() {
                DnTuple dt = this.itr.next();
                Tuple<ParentIdAndRdn, String> t = new Tuple<ParentIdAndRdn, String>();
                ParentIdAndRdn rdn = new ParentIdAndRdn(dt.getParentId(), dt.getDn().getRdns());
                rdn.setNbChildren(dt.getNbChildren());
                rdn.setNbDescendants(dt.getNbDecendents());
                t.setKey(rdn);
                t.setValue(dt.getId());
                return t;
            }

            @Override
            public boolean hasNext() {
                return this.itr.hasNext();
            }
        };
        String forwardRdnTree = "1.3.6.1.4.1.18060.0.4.1.2.50_forward";
        this.build(parentIdAndRdnFwdItr, forwardRdnTree);
        Iterator<Tuple> parentIdAndRdnRevItr = new Iterator<Tuple>(){
            Iterator<DnTuple> itr;
            {
                this.itr = parentIdRdnSortedSet.iterator();
            }

            @Override
            public void remove() {
            }

            @Override
            public Tuple next() {
                DnTuple dt = this.itr.next();
                Tuple<String, ParentIdAndRdn> t = new Tuple<String, ParentIdAndRdn>();
                ParentIdAndRdn rdn = new ParentIdAndRdn(dt.getParentId(), dt.getDn().getRdns());
                rdn.setNbChildren(dt.getNbChildren());
                rdn.setNbDescendants(dt.getNbDecendents());
                t.setKey(dt.getId());
                t.setValue(rdn);
                return t;
            }

            @Override
            public boolean hasNext() {
                return this.itr.hasNext();
            }
        };
        String revRdnTree = "1.3.6.1.4.1.18060.0.4.1.2.50_reverse";
        this.build(parentIdAndRdnRevItr, revRdnTree);
    }

    public void buildPartition() {
        try {
            System.out.println("Loading schema using JarLdifSchemaLoader");
            JarLdifSchemaLoader loader = new JarLdifSchemaLoader();
            this.schemaManager = new DefaultSchemaManager(loader);
            this.schemaManager.loadAllEnabled();
        }
        catch (Exception e) {
            LOG.warn("Failed to initialize the schema manager", e);
            return;
        }
        Set<DnTuple> sortedDnSet = null;
        try {
            long sortT0 = System.currentTimeMillis();
            System.out.println("Sorting the LDIF data...");
            sortedDnSet = this.getDnTuples();
            long sortT1 = System.currentTimeMillis();
            this.totalEntries = sortedDnSet.size();
            System.out.println("Completed sorting, total number of entries " + this.totalEntries + ", time taken : " + (sortT1 - sortT0) + "ms");
        }
        catch (Exception e) {
            LOG.warn("Failed to parse the given LDIF file ", e);
            return;
        }
        if (sortedDnSet == null || sortedDnSet.isEmpty()) {
            String message = "No entries found in the given LDIF file, aborting bulk load";
            System.out.println(message);
            LOG.info(message);
        }
        MavibotPartition partition = null;
        try {
            long partT0 = System.currentTimeMillis();
            System.out.print("Creating partition...");
            DefaultDnFactory dnFactory = new DefaultDnFactory(this.schemaManager, null);
            partition = new MavibotPartition(this.schemaManager, dnFactory);
            partition.setId("builder");
            partition.setSuffixDn(this.suffixDn);
            File dir = new File(this.outputDir);
            partition.setPartitionPath(dir.toURI());
            for (String atName : this.indexAttributes) {
                this.schemaManager.lookupAttributeTypeRegistry(atName);
                partition.addIndex(new MavibotIndex(atName, false));
            }
            partition.initialize();
            this.masterTableName = partition.getMasterTable().getName();
            this.rm = partition.getRecordMan();
            long partT1 = System.currentTimeMillis();
            System.out.println(", time taken : " + (partT1 - partT0) + "ms");
        }
        catch (Exception e) {
            LOG.warn("Failed to initialize the partition", e);
            return;
        }
        try {
            long masterT0 = System.currentTimeMillis();
            System.out.print("Building master table...");
            this.buildMasterTable(sortedDnSet);
            long masterT1 = System.currentTimeMillis();
            System.out.println(", time taken : " + (masterT1 - masterT0) + "ms");
        }
        catch (Exception e) {
            LOG.warn("Failed to build master table", e);
            e.printStackTrace();
            return;
        }
        Iterator<String> userIndexItr = partition.getUserIndices();
        try {
            partition.destroy();
            this.rm = new RecordManager(new File(partition.getPartitionPath()).getAbsolutePath());
            long rdnT0 = System.currentTimeMillis();
            System.out.print("Building RDN index.");
            this.buildRdnIndex(sortedDnSet);
            long rdnT1 = System.currentTimeMillis();
            System.out.println(", time taken : " + (rdnT1 - rdnT0) + "ms");
        }
        catch (Exception e) {
            LOG.warn("Failed to build the RDN index", e);
            return;
        }
        System.out.println("Clearing the sorted DN set.");
        sortedDnSet.clear();
        for (Index<?, String> id : partition.getAllIndices()) {
            String oid = id.getAttribute().getOid();
            if ("1.3.6.1.4.1.18060.0.4.1.2.50".equals(oid) || "1.3.6.1.4.1.18060.0.4.1.2.3".equals(oid)) continue;
            String ignoreVal = null;
            if ("2.5.4.0".equals(oid)) {
                ignoreVal = "top";
            }
            try {
                long indexT0 = System.currentTimeMillis();
                System.out.print("Building index " + id.getAttribute().getName());
                this.buildIndex(id, ignoreVal);
                long indexT1 = System.currentTimeMillis();
                System.out.println(", time taken : " + (indexT1 - indexT0) + "ms");
            }
            catch (Exception e) {
                e.printStackTrace();
                LOG.warn("Failed to build the index " + id.getAttribute().getName());
                LOG.warn("", e);
                return;
            }
        }
        try {
            System.out.print("Building presence index...");
            long presenceT0 = System.currentTimeMillis();
            this.buildPresenceIndex(userIndexItr);
            long presenceT1 = System.currentTimeMillis();
            System.out.println(", time taken : " + (presenceT1 - presenceT0) + "ms");
        }
        catch (Exception e) {
            LOG.warn("Failed to build the presence index.");
            LOG.warn("", e);
            return;
        }
        System.out.println("Patition building complete.");
    }

    private void buildPresenceIndex(Iterator<String> itr) throws Exception {
        HashSet<String> idxOids = new HashSet<String>();
        while (itr.hasNext()) {
            idxOids.add(itr.next());
        }
        BTree masterTree = this.rm.getManagedTree(this.masterTableName);
        BTree fwdTree = this.rm.getManagedTree("1.3.6.1.4.1.18060.0.4.1.2.3_forward");
        boolean fwdDupsAllowed = fwdTree.isAllowDuplicates();
        Comparator fwdKeyComparator = fwdTree.getKeySerializer().getComparator();
        final TreeMap fwdMap = new TreeMap();
        TupleCursor cursor = masterTree.browse();
        while (cursor.hasNext()) {
            Tuple t = cursor.next();
            Entry e = (Entry)t.getValue();
            for (String oid : idxOids) {
                TreeSet idSet;
                Attribute at = e.get(oid);
                if (at == null || (idSet = (TreeSet)fwdMap.get(oid)) != null) continue;
                idSet = new TreeSet();
                idSet.add(t.getKey());
                fwdMap.put(oid, idSet);
            }
        }
        cursor.close();
        Iterator<Tuple> tupleItr = new Iterator<Tuple>(){
            Iterator<Map.Entry<String, Set>> itr;
            {
                this.itr = fwdMap.entrySet().iterator();
            }

            @Override
            public Tuple next() {
                Map.Entry<String, Set> e = this.itr.next();
                Tuple<String, Set> t = new Tuple<String, Set>();
                t.setKey(e.getKey());
                t.setValue(e.getValue());
                return t;
            }

            @Override
            public boolean hasNext() {
                return this.itr.hasNext();
            }

            @Override
            public void remove() {
            }
        };
        this.build(tupleItr, fwdTree.getName());
    }

    private void buildIndex(Index<?, String> idx, String ignoreVal) throws Exception {
        BTree masterTree = this.rm.getManagedTree(this.masterTableName);
        AttributeType type = idx.getAttribute();
        boolean isBinary = type.getSyntax().isHumanReadable();
        boolean singleValued = type.isSingleValued();
        BTree fwdTree = this.rm.getManagedTree(type.getOid() + "_forward");
        boolean fwdDupsAllowed = fwdTree.isAllowDuplicates();
        Comparator fwdKeyComparator = fwdTree.getKeySerializer().getComparator();
        TreeSet<Tuple> fwdSet = new TreeSet<Tuple>(new IndexTupleComparator(fwdKeyComparator));
        TreeMap fwdMap = new TreeMap(fwdKeyComparator);
        BTree revTree = null;
        TreeSet<Tuple> revSet = null;
        TreeMap revMap = null;
        Comparator revValComparator = null;
        if (idx.hasReverse()) {
            revTree = this.rm.getManagedTree(type.getOid() + "_reverse");
            boolean revDupsAllowed = revTree.isAllowDuplicates();
            Comparator revKeyComparator = revTree.getKeySerializer().getComparator();
            revValComparator = revTree.getValueSerializer().getComparator();
            revSet = new TreeSet<Tuple>(new IndexTupleComparator(revKeyComparator));
            revMap = new TreeMap(revKeyComparator);
        }
        TupleCursor cursor = masterTree.browse();
        while (cursor.hasNext()) {
            Tuple t = cursor.next();
            Entry e = (Entry)t.getValue();
            Attribute at = e.get(type);
            if (at == null) continue;
            if (singleValued) {
                Value<?> v = at.get();
                Object normVal = v.getNormValue();
                if (ignoreVal != null && normVal.equals(ignoreVal)) continue;
                Tuple fwdTuple = new Tuple(normVal, t.getKey());
                fwdSet.add(fwdTuple);
                if (revTree == null) continue;
                Tuple revTuple = new Tuple(t.getKey(), v.getNormValue());
                revSet.add(revTuple);
                continue;
            }
            for (Value v : at) {
                TreeSet valSet;
                Set idSet;
                Object val = v.getNormValue();
                if (ignoreVal != null && val.equals(ignoreVal)) continue;
                Tuple fwdTuple = (Tuple)fwdMap.get(val);
                if (fwdTuple == null) {
                    idSet = new TreeSet();
                    idSet.add(t.getKey());
                    fwdTuple = new Tuple(val, idSet);
                    fwdMap.put(val, fwdTuple);
                } else {
                    idSet = (Set)fwdTuple.getValue();
                    idSet.add(t.getKey());
                }
                if (revTree == null) continue;
                Tuple revTuple = (Tuple)revMap.get(t.getKey());
                if (revTuple == null) {
                    valSet = new TreeSet(revValComparator);
                    valSet.add(val);
                    revTuple = new Tuple(t.getKey(), valSet);
                    continue;
                }
                valSet = (TreeSet)revTuple.getValue();
                valSet.add(val);
            }
        }
        cursor.close();
        if (singleValued) {
            if (fwdSet.isEmpty()) {
                return;
            }
            this.build(fwdSet.iterator(), fwdTree.getName());
            if (revTree != null) {
                this.build(revSet.iterator(), revTree.getName());
            }
        } else {
            if (fwdMap.isEmpty()) {
                return;
            }
            this.build(fwdMap.values().iterator(), fwdTree.getName());
            if (revTree != null) {
                this.build(revMap.values().iterator(), revTree.getName());
            }
        }
    }

    public void testBTree(String name) {
        try {
            BTree tree = this.rm.getManagedTree(name);
            TupleCursor cursor = tree.browse();
            long fetched = 0L;
            while (cursor.hasNext()) {
                ++fetched;
                Tuple t = cursor.next();
            }
            cursor.close();
            if (fetched != tree.getNbElems()) {
                System.err.println("The number of elements fetched from the btree did not match with the stored count " + name + " ( fetched = " + fetched + ", stored count = " + tree.getNbElems() + " )");
            } else {
                System.out.println("The number of elements in the btree " + name + " " + fetched);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    int getTotalEntries() {
        return this.totalEntries;
    }

    int getNumKeysInNode() {
        return this.numKeysInNode;
    }

    RecordManager getRm() {
        return this.rm;
    }

    SchemaManager getSchemaManager() {
        return this.schemaManager;
    }

    String getMasterTableName() {
        return this.masterTableName;
    }

    public static void help() {
        Option[] options;
        System.out.println("Usage");
        System.out.println("java -jar bulkloader.jar <options>");
        System.out.println("Available options are:");
        for (Option o : options = Option.values()) {
            if (o == Option.UNKNOWN) continue;
            System.out.println(o.getText() + "    " + o.getDesc());
        }
    }

    private static String getArgAt(int position, Option opt, String[] args) {
        if (position >= args.length) {
            System.out.println("No value was provided for the option " + opt.getText());
            System.exit(1);
        }
        return args[position];
    }

    public static void main(String[] args) throws Exception {
        String inFile = null;
        String outDirPath = null;
        int numKeysInNode = 16;
        int rid = 1;
        boolean cleanOutDir = false;
        boolean verifyMasterTable = false;
        if (args.length < 2) {
            MavibotPartitionBuilder.help();
            System.exit(0);
        }
        block10: for (int i = 0; i < args.length; ++i) {
            Option opt = Option.getOpt(args[i]);
            switch (opt) {
                case HELP: {
                    MavibotPartitionBuilder.help();
                    System.exit(0);
                    continue block10;
                }
                case INPUT_FILE: {
                    inFile = MavibotPartitionBuilder.getArgAt(++i, opt, args);
                    continue block10;
                }
                case OUT_DIR: {
                    outDirPath = MavibotPartitionBuilder.getArgAt(++i, opt, args);
                    continue block10;
                }
                case CLEAN_OUT_DIR: {
                    cleanOutDir = true;
                    continue block10;
                }
                case VERIFY_MASTER_TABLE: {
                    verifyMasterTable = true;
                    continue block10;
                }
                case NUM_KEYS_PER_NODE: {
                    numKeysInNode = Integer.parseInt(MavibotPartitionBuilder.getArgAt(++i, opt, args));
                    continue block10;
                }
                case DS_RID: {
                    rid = Integer.parseInt(MavibotPartitionBuilder.getArgAt(++i, opt, args));
                    continue block10;
                }
                case UNKNOWN: {
                    System.out.println("Unknown option " + args[i]);
                    continue block10;
                }
            }
        }
        if (inFile == null || inFile.trim().length() == 0) {
            System.out.println("Invalid input file");
            return;
        }
        if (!new File(inFile).exists()) {
            System.out.println("The input file " + inFile + " doesn't exist");
            return;
        }
        File outDir = new File(outDirPath);
        if (outDir.exists()) {
            if (!cleanOutDir) {
                System.out.println("The output directory is not empty, pass " + Option.CLEAN_OUT_DIR.getText() + " to force delete the contents or specify a different directory");
                return;
            }
            FileUtils.deleteDirectory(outDir);
        }
        MavibotPartitionBuilder builder = new MavibotPartitionBuilder(inFile, outDirPath, numKeysInNode, rid);
        long start = System.currentTimeMillis();
        builder.buildPartition();
        long end = System.currentTimeMillis();
        System.out.println("Total time taken " + (end - start) + "msec");
        if (verifyMasterTable) {
            System.out.println("Verifying the contents of master table");
            builder.testBTree("master");
        }
    }
}

