/*
 * Decompiled with CFR 0.152.
 */
package org.apache.directory.server.core.integ;

import java.lang.reflect.AnnotatedElement;
import java.lang.reflect.Field;
import java.util.UUID;
import org.apache.directory.api.ldap.model.name.DefaultDnFactory;
import org.apache.directory.api.util.FileUtils;
import org.apache.directory.server.annotations.CreateLdapServer;
import org.apache.directory.server.core.annotations.CreateDS;
import org.apache.directory.server.core.api.DirectoryService;
import org.apache.directory.server.core.api.changelog.ChangeLog;
import org.apache.directory.server.core.factory.DSAnnotationProcessor;
import org.apache.directory.server.core.factory.DefaultDirectoryServiceFactory;
import org.apache.directory.server.core.factory.DirectoryServiceFactory;
import org.apache.directory.server.core.factory.PartitionFactory;
import org.apache.directory.server.factory.ServerAnnotationProcessor;
import org.apache.directory.server.i18n.I18n;
import org.apache.directory.server.ldap.LdapServer;
import org.junit.jupiter.api.Disabled;
import org.junit.jupiter.api.extension.AfterAllCallback;
import org.junit.jupiter.api.extension.AfterEachCallback;
import org.junit.jupiter.api.extension.BeforeAllCallback;
import org.junit.jupiter.api.extension.BeforeEachCallback;
import org.junit.jupiter.api.extension.ExtensionContext;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ApacheDSTestExtension
implements BeforeEachCallback,
AfterEachCallback,
BeforeAllCallback,
AfterAllCallback {
    private static final Logger LOG = LoggerFactory.getLogger(ApacheDSTestExtension.class);
    public static final String CLASS_DS = "classDirectoryService";
    public static final String CLASS_LS = "classLdapServer";
    public static final String METHOD_DS = "methodDirectoryService";
    public static final String METHOD_LS = "methodLdapServer";
    public static final String CURRENT_DS = "directoryService";
    public static final String CURRENT_LS = "ldapServer";
    public static final String REVISION = "revision";

    private DirectoryService getDirectoryService(ExtensionContext context, String fieldName) throws NoSuchFieldException, SecurityException, IllegalArgumentException, IllegalAccessException {
        Class<?> testClass = context.getTestClass().get();
        Field field = testClass.getField(fieldName);
        if (field != null) {
            return (DirectoryService)field.get(testClass);
        }
        return null;
    }

    private void setDirectoryService(ExtensionContext context, String fieldName, DirectoryService directoryService) throws NoSuchFieldException, SecurityException, IllegalArgumentException, IllegalAccessException {
        Class<?> testClass = context.getTestClass().get();
        Field field = testClass.getField(fieldName);
        field.set(null, directoryService);
    }

    private LdapServer getLdapServer(ExtensionContext context, String fieldName) throws NoSuchFieldException, SecurityException, IllegalArgumentException, IllegalAccessException {
        Class<?> testClass = context.getTestClass().get();
        Field field = testClass.getField(fieldName);
        if (field != null) {
            return (LdapServer)field.get(testClass);
        }
        return null;
    }

    private void setLdapServer(ExtensionContext context, String fieldName, LdapServer ldapServer) throws NoSuchFieldException, SecurityException, IllegalArgumentException, IllegalAccessException {
        Class<?> testClass = context.getTestClass().get();
        Field field = testClass.getField(fieldName);
        field.set(null, ldapServer);
    }

    private long getRevision(ExtensionContext context, String fieldName) throws NoSuchFieldException, SecurityException, IllegalArgumentException, IllegalAccessException {
        Class<?> testClass = context.getTestClass().get();
        Field field = testClass.getField(fieldName);
        if (field != null) {
            return (Long)field.get(testClass);
        }
        return 0L;
    }

    private void setRevision(ExtensionContext context, long revision) throws NoSuchFieldException, SecurityException, IllegalArgumentException, IllegalAccessException {
        Class<?> testClass = context.getTestClass().get();
        Field field = testClass.getField(REVISION);
        field.set(null, revision);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void beforeAll(ExtensionContext context) throws Exception {
        if (context.getTestClass().get().getAnnotation(Disabled.class) != null) {
            return;
        }
        try {
            AnnotatedElement annotations = context.getTestClass().get();
            CreateDS dsBuilder = annotations.getDeclaredAnnotation(CreateDS.class);
            DirectoryService classDS = DSAnnotationProcessor.getDirectoryService(dsBuilder);
            if (classDS == null) {
                DirectoryServiceFactory dsf = (DirectoryServiceFactory)DefaultDirectoryServiceFactory.class.newInstance();
                classDS = dsf.getDirectoryService();
                classDS.getChangeLog().setEnabled(true);
                dsf.init("default" + UUID.randomUUID().toString());
                DSAnnotationProcessor.loadSchemas(context, classDS);
                dsf.getDirectoryService().getLdapCodecService().setDnfactory(new DefaultDnFactory(dsf.getDirectoryService().getSchemaManager(), 1000));
            }
            DSAnnotationProcessor.applyLdifs(annotations, context.getDisplayName(), classDS);
            this.setDirectoryService(context, CLASS_DS, classDS);
            CreateLdapServer classLdapServerBuilder = annotations.getDeclaredAnnotation(CreateLdapServer.class);
            if (classLdapServerBuilder != null) {
                LdapServer classLdapServer = ServerAnnotationProcessor.createLdapServer(annotations, classDS);
                this.setLdapServer(context, CLASS_LS, classLdapServer);
            }
            DirectoryServiceFactory dsFactory = (DirectoryServiceFactory)DefaultDirectoryServiceFactory.class.newInstance();
            PartitionFactory partitionFactory = dsFactory.getPartitionFactory();
            LOG.debug("Using partition factory {}", (Object)partitionFactory.getClass().getSimpleName());
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        finally {
            System.out.println("");
        }
    }

    @Override
    public void afterAll(ExtensionContext context) {
        try {
            DirectoryService classDS;
            LdapServer classLdapServer = this.getLdapServer(context, CLASS_LS);
            if (classLdapServer != null) {
                classLdapServer.stop();
            }
            if ((classDS = this.getDirectoryService(context, CLASS_DS)) != null) {
                LOG.debug("Shuting down DS for {}", (Object)classDS.getInstanceId());
                classDS.shutdown();
                FileUtils.deleteDirectory(classDS.getInstanceLayout().getInstanceDirectory());
            } else {
                long revision = this.getRevision(context, REVISION);
                this.revert(classDS, revision);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            LOG.error(I18n.err(I18n.ERR_181, context.getTestClass().get().getName()));
            LOG.error(e.getLocalizedMessage());
        }
    }

    @Override
    public void beforeEach(ExtensionContext context) throws Exception {
        if (context.getTestMethod().get().getAnnotation(Disabled.class) != null) {
            return;
        }
        DirectoryService directoryService = this.processDS(context);
        this.processLS(context, directoryService);
    }

    private DirectoryService processDS(ExtensionContext context) throws Exception {
        DirectoryService classDS;
        AnnotatedElement classAnnotation = context.getTestClass().get();
        AnnotatedElement methodAnnotation = context.getTestMethod().get();
        CreateDS methodDsBuilder = methodAnnotation.getDeclaredAnnotation(CreateDS.class);
        DirectoryService service = classDS = this.getDirectoryService(context, CLASS_DS);
        if (methodDsBuilder != null) {
            try {
                DirectoryService methodDS = DSAnnotationProcessor.getDirectoryService(methodDsBuilder);
                this.setDirectoryService(context, METHOD_DS, methodDS);
                service = methodDS;
                DSAnnotationProcessor.applyLdifs(classAnnotation, context.getDisplayName(), service);
            }
            catch (Exception methodDS) {
                // empty catch block
            }
        }
        DSAnnotationProcessor.applyLdifs(methodAnnotation, context.getDisplayName(), service);
        if (service != null && service.getChangeLog().isEnabled()) {
            long revision = service.getChangeLog().getCurrentRevision();
            this.setRevision(context, revision);
        }
        this.setDirectoryService(context, CURRENT_DS, service);
        return service;
    }

    private void processLS(ExtensionContext context, DirectoryService directoryService) throws Exception {
        AnnotatedElement methodAnnotation = context.getTestMethod().get();
        LdapServer ldapServer = this.getLdapServer(context, CLASS_LS);
        CreateLdapServer methodLsBuilder = methodAnnotation.getDeclaredAnnotation(CreateLdapServer.class);
        if (methodLsBuilder != null) {
            LdapServer methodLdapServer = ServerAnnotationProcessor.createLdapServer(methodAnnotation, this.getDirectoryService(context, CURRENT_DS));
            this.setLdapServer(context, METHOD_LS, methodLdapServer);
            ldapServer = methodLdapServer;
        }
        if (ldapServer != null) {
            DirectoryService currentDS = this.getDirectoryService(context, CURRENT_DS);
            ldapServer.setDirectoryService(currentDS);
            this.setLdapServer(context, CURRENT_LS, ldapServer);
        }
    }

    @Override
    public void afterEach(ExtensionContext context) throws Exception {
        DirectoryService methodDS = this.getDirectoryService(context, METHOD_DS);
        DirectoryService classDS = this.getDirectoryService(context, CLASS_DS);
        LdapServer methodLS = this.getLdapServer(context, METHOD_LS);
        long revision = this.getRevision(context, REVISION);
        try {
            if (methodDS != null) {
                LOG.debug("Shuting down DS for {}", (Object)methodDS.getInstanceId());
                methodDS.shutdown();
                FileUtils.deleteDirectory(methodDS.getInstanceLayout().getInstanceDirectory());
                this.setDirectoryService(context, METHOD_DS, null);
                this.setLdapServer(context, METHOD_LS, null);
            } else {
                this.revert(classDS, revision);
            }
            if (methodLS != null) {
                methodLS.stop();
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private int getMinPort() {
        return 0;
    }

    private void revert(DirectoryService dirService, long revision) throws Exception {
        if (dirService == null) {
            return;
        }
        ChangeLog cl = dirService.getChangeLog();
        if (cl.isEnabled() && revision < cl.getCurrentRevision()) {
            LOG.debug("Revert revision {}", (Object)revision);
            dirService.revert(revision);
        }
    }
}

