/*
 * Decompiled with CFR 0.152.
 */
package org.apache.directory.mavibot.btree;

import java.io.IOException;
import java.util.NoSuchElementException;
import org.apache.directory.mavibot.btree.AbstractPage;
import org.apache.directory.mavibot.btree.Page;
import org.apache.directory.mavibot.btree.ParentPos;
import org.apache.directory.mavibot.btree.ReadTransaction;
import org.apache.directory.mavibot.btree.exception.EndOfFileExceededException;

public class KeyCursor<K> {
    private static final int BEFORE_FIRST = -1;
    private static final int AFTER_LAST = -2;
    protected ParentPos<K, K>[] stack;
    protected int depth = 0;
    protected ReadTransaction<K, K> transaction;

    protected KeyCursor() {
    }

    public KeyCursor(ReadTransaction<K, K> transaction, ParentPos<K, K>[] stack, int depth) {
        this.transaction = transaction;
        this.stack = stack;
        this.depth = depth;
    }

    public void afterLast() throws IOException {
        if (this.stack == null || this.stack.length == 0) {
            return;
        }
        Page child = null;
        for (int i2 = 0; i2 < this.depth; ++i2) {
            ParentPos<K, K> parentPos = this.stack[i2];
            if (child != null) {
                parentPos.page = child;
                parentPos.pos = child.getNbElems();
            } else {
                parentPos.pos = parentPos.page.getNbElems();
            }
            child = ((AbstractPage)parentPos.page).getPage(parentPos.pos);
        }
        ParentPos<K, K> parentPos = this.stack[this.depth];
        if (child == null) {
            parentPos.pos = parentPos.page.getNbElems() - 1;
        } else {
            parentPos.page = child;
            parentPos.pos = child.getNbElems() - 1;
        }
        parentPos.pos = -2;
    }

    public void beforeFirst() throws IOException {
        if (this.stack == null || this.stack.length == 0) {
            return;
        }
        Page child = null;
        for (int i2 = 0; i2 < this.depth; ++i2) {
            ParentPos<K, K> parentPos = this.stack[i2];
            parentPos.pos = 0;
            if (child != null) {
                parentPos.page = child;
            }
            child = ((AbstractPage)parentPos.page).getPage(0);
        }
        ParentPos<K, K> parentPos = this.stack[this.depth];
        parentPos.pos = -1;
        if (child != null) {
            parentPos.page = child;
        }
    }

    public boolean hasNext() throws EndOfFileExceededException, IOException {
        if (this.stack == null || this.stack.length == 0) {
            return false;
        }
        ParentPos<K, K> parentPos = this.stack[this.depth];
        if (parentPos.page == null) {
            return false;
        }
        if (parentPos.pos == -2) {
            return false;
        }
        if (parentPos.pos == -1) {
            return true;
        }
        if (parentPos.pos < parentPos.page.getNbElems() - 1) {
            return true;
        }
        for (int currentDepth = this.depth - 1; currentDepth >= 0; --currentDepth) {
            parentPos = this.stack[currentDepth];
            if (parentPos.pos >= parentPos.page.getNbElems()) continue;
            return true;
        }
        return false;
    }

    public K next() throws EndOfFileExceededException, IOException {
        if (this.stack == null || this.stack.length == 0) {
            throw new NoSuchElementException("No Key is present");
        }
        ParentPos<K, K> parentPos = this.stack[this.depth];
        if (parentPos.page == null || parentPos.pos == -2) {
            throw new NoSuchElementException("No more keys present");
        }
        if (parentPos.pos == parentPos.page.getNbElems() && ((parentPos = this.findNextParentPos()) == null || parentPos.page == null)) {
            throw new NoSuchElementException("No more keys present");
        }
        if (parentPos.pos == -1) {
            ++parentPos.pos;
        } else if (parentPos.pos == parentPos.page.getNbElems() - 1) {
            parentPos = this.findNextParentPos();
            if (parentPos == null || parentPos.page == null) {
                throw new NoSuchElementException("No more keys present");
            }
        } else {
            ++parentPos.pos;
        }
        AbstractPage leaf = (AbstractPage)parentPos.page;
        return leaf.getKey(parentPos.pos);
    }

    public K nextKey() throws EndOfFileExceededException, IOException {
        return this.next();
    }

    public boolean hasNextKey() throws EndOfFileExceededException, IOException {
        if (this.stack == null || this.stack.length == 0) {
            return false;
        }
        ParentPos<K, K> parentPos = this.stack[this.depth];
        if (parentPos.page == null) {
            return false;
        }
        if (parentPos.pos == parentPos.page.getNbElems() - 1) {
            return this.hasNextParentPos();
        }
        return true;
    }

    public boolean hasPrev() throws EndOfFileExceededException, IOException {
        if (this.stack == null || this.stack.length == 0) {
            return false;
        }
        ParentPos<K, K> parentPos = this.stack[this.depth];
        if (parentPos.page == null) {
            return false;
        }
        if (parentPos.pos > 0) {
            return true;
        }
        if (parentPos.pos == -1) {
            return false;
        }
        if (parentPos.pos == -2) {
            return true;
        }
        for (int currentDepth = this.depth - 1; currentDepth >= 0; --currentDepth) {
            parentPos = this.stack[currentDepth];
            if (parentPos.pos <= 0) continue;
            return true;
        }
        return false;
    }

    public K prev() throws EndOfFileExceededException, IOException {
        if (this.stack == null || this.stack.length == 0) {
            throw new NoSuchElementException("No more keys present");
        }
        ParentPos<K, K> parentPos = this.stack[this.depth];
        if (parentPos.page == null || parentPos.pos == -1) {
            throw new NoSuchElementException("No more keys present");
        }
        if (parentPos.pos == -2) {
            parentPos.pos = parentPos.page.getNbElems() - 1;
        } else if (parentPos.pos == 0) {
            parentPos = this.findPrevParentPos();
            if (parentPos == null || parentPos.page == null) {
                throw new NoSuchElementException("No more keys present");
            }
        } else {
            --parentPos.pos;
        }
        AbstractPage leaf = (AbstractPage)parentPos.page;
        return leaf.getKey(parentPos.pos);
    }

    public K prevKey() throws EndOfFileExceededException, IOException {
        return this.prev();
    }

    public boolean hasPrevKey() throws EndOfFileExceededException, IOException {
        if (this.stack == null || this.stack.length == 0) {
            return false;
        }
        ParentPos<K, K> parentPos = this.stack[this.depth];
        if (parentPos.page == null) {
            return false;
        }
        switch (parentPos.pos) {
            case 0: {
                return this.hasPrevParentPos();
            }
            case -1: {
                return false;
            }
        }
        return true;
    }

    private boolean hasNextParentPos() throws EndOfFileExceededException, IOException {
        if (this.depth == 0) {
            return false;
        }
        Page child = null;
        for (int currentDepth = this.depth - 1; currentDepth >= 0; --currentDepth) {
            ParentPos<K, K> parentPos = this.stack[currentDepth];
            if (parentPos.pos + 1 > parentPos.page.getNbElems()) {
                continue;
            }
            child = ((AbstractPage)parentPos.page).getPage(parentPos.pos + 1);
            while (currentDepth < this.depth - 1) {
                ++currentDepth;
                child = ((AbstractPage)child).getPage(0);
            }
            return true;
        }
        return false;
    }

    private ParentPos<K, K> findNextParentPos() throws EndOfFileExceededException, IOException {
        if (this.depth == 0) {
            return null;
        }
        Page child = null;
        for (int currentDepth = this.depth - 1; currentDepth >= 0; --currentDepth) {
            ParentPos<K, K> parentPos = this.stack[currentDepth];
            if (parentPos.pos + 1 > parentPos.page.getNbElems()) {
                continue;
            }
            ++parentPos.pos;
            child = ((AbstractPage)parentPos.page).getPage(parentPos.pos);
            while (currentDepth < this.depth - 1) {
                parentPos = this.stack[++currentDepth];
                parentPos.pos = 0;
                parentPos.page = child;
                child = ((AbstractPage)child).getPage(0);
            }
            parentPos = this.stack[this.depth];
            parentPos.page = child;
            parentPos.pos = 0;
            return parentPos;
        }
        return null;
    }

    private ParentPos<K, K> findPrevParentPos() throws EndOfFileExceededException, IOException {
        if (this.depth == 0) {
            return null;
        }
        Page child = null;
        for (int currentDepth = this.depth - 1; currentDepth >= 0; --currentDepth) {
            ParentPos<K, K> parentPos = this.stack[currentDepth];
            if (parentPos.pos == 0) {
                continue;
            }
            --parentPos.pos;
            child = ((AbstractPage)parentPos.page).getPage(parentPos.pos);
            while (currentDepth < this.depth - 1) {
                parentPos = this.stack[++currentDepth];
                parentPos.pos = child.getNbElems();
                parentPos.page = child;
                child = ((AbstractPage)parentPos.page).getPage(parentPos.page.getNbElems());
            }
            parentPos = this.stack[this.depth];
            parentPos.pos = child.getNbElems() - 1;
            parentPos.page = child;
            return parentPos;
        }
        return null;
    }

    private boolean hasPrevParentPos() throws EndOfFileExceededException, IOException {
        if (this.depth == 0) {
            return false;
        }
        Page child = null;
        for (int currentDepth = this.depth - 1; currentDepth >= 0; --currentDepth) {
            ParentPos<K, K> parentPos = this.stack[currentDepth];
            if (parentPos.pos == 0) {
                continue;
            }
            child = ((AbstractPage)parentPos.page).getPage(parentPos.pos - 1);
            while (currentDepth < this.depth - 1) {
                ++currentDepth;
                child = ((AbstractPage)child).getPage(child.getNbElems());
            }
            return true;
        }
        return false;
    }

    public void close() {
        this.transaction.close();
    }

    public long getCreationDate() {
        return this.transaction.getCreationDate();
    }

    public long getRevision() {
        return this.transaction.getRevision();
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("KeyCursor, depth = ").append(this.depth).append("\n");
        for (int i2 = 0; i2 <= this.depth; ++i2) {
            sb.append("    ").append(this.stack[i2]).append("\n");
        }
        return sb.toString();
    }
}

