/*
 * Decompiled with CFR 0.152.
 */
package org.apache.directory.server.core.partition.impl.btree.mavibot;

import java.io.File;
import java.io.FilenameFilter;
import java.io.IOException;
import java.io.Serializable;
import java.net.URI;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import net.sf.ehcache.Cache;
import net.sf.ehcache.Element;
import org.apache.directory.api.ldap.model.cursor.Cursor;
import org.apache.directory.api.ldap.model.cursor.Tuple;
import org.apache.directory.api.ldap.model.entry.Attribute;
import org.apache.directory.api.ldap.model.entry.Entry;
import org.apache.directory.api.ldap.model.entry.Value;
import org.apache.directory.api.ldap.model.exception.LdapException;
import org.apache.directory.api.ldap.model.exception.LdapOtherException;
import org.apache.directory.api.ldap.model.schema.AttributeType;
import org.apache.directory.api.ldap.model.schema.SchemaManager;
import org.apache.directory.api.util.exception.MultiException;
import org.apache.directory.mavibot.btree.RecordManager;
import org.apache.directory.server.core.api.DnFactory;
import org.apache.directory.server.core.api.entry.ClonedServerEntry;
import org.apache.directory.server.core.api.interceptor.context.DeleteOperationContext;
import org.apache.directory.server.core.api.interceptor.context.ModifyOperationContext;
import org.apache.directory.server.core.api.interceptor.context.MoveAndRenameOperationContext;
import org.apache.directory.server.core.api.interceptor.context.MoveOperationContext;
import org.apache.directory.server.core.api.interceptor.context.OperationContext;
import org.apache.directory.server.core.api.interceptor.context.RenameOperationContext;
import org.apache.directory.server.core.api.partition.Partition;
import org.apache.directory.server.core.api.partition.PartitionReadTxn;
import org.apache.directory.server.core.api.partition.PartitionTxn;
import org.apache.directory.server.core.api.partition.PartitionWriteTxn;
import org.apache.directory.server.core.partition.impl.btree.AbstractBTreePartition;
import org.apache.directory.server.core.partition.impl.btree.mavibot.MavibotDnIndex;
import org.apache.directory.server.core.partition.impl.btree.mavibot.MavibotEntrySerializer;
import org.apache.directory.server.core.partition.impl.btree.mavibot.MavibotIndex;
import org.apache.directory.server.core.partition.impl.btree.mavibot.MavibotMasterTable;
import org.apache.directory.server.core.partition.impl.btree.mavibot.MavibotRdnIndex;
import org.apache.directory.server.i18n.I18n;
import org.apache.directory.server.xdbm.Index;
import org.apache.directory.server.xdbm.search.impl.CursorBuilder;
import org.apache.directory.server.xdbm.search.impl.DefaultOptimizer;
import org.apache.directory.server.xdbm.search.impl.DefaultSearchEngine;
import org.apache.directory.server.xdbm.search.impl.EvaluatorBuilder;
import org.apache.directory.server.xdbm.search.impl.NoOpOptimizer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MavibotPartition
extends AbstractBTreePartition {
    private static final Logger LOG = LoggerFactory.getLogger(MavibotPartition.class);
    private static final String MAVIBOT_DB_FILE_EXTN = ".data";
    private static final FilenameFilter DB_FILTER = new FilenameFilter(){

        @Override
        public boolean accept(File dir, String name) {
            return name.endsWith(MavibotPartition.MAVIBOT_DB_FILE_EXTN) && !name.startsWith("master.");
        }
    };
    private RecordManager recordMan;
    private Cache entryCache;

    public MavibotPartition(SchemaManager schemaManager, DnFactory dnFactory) {
        super(schemaManager, dnFactory);
        MavibotEntrySerializer.setSchemaManager(schemaManager);
        if (this.cacheSize < 0) {
            this.cacheSize = 10000;
            LOG.debug("Using the default entry cache size of {} for {} partition", (Object)this.cacheSize, (Object)this.id);
        } else {
            LOG.debug("Using the custom configured cache size of {} for {} partition", (Object)this.cacheSize, (Object)this.id);
        }
    }

    @Override
    protected void doRepair() throws LdapException {
    }

    @Override
    protected void doInit() throws LdapException {
        if (!this.initialized) {
            if (!this.isOptimizerEnabled()) {
                this.setOptimizer(new NoOpOptimizer());
            } else {
                this.setOptimizer(new DefaultOptimizer(this));
            }
            EvaluatorBuilder evaluatorBuilder = new EvaluatorBuilder(this, this.schemaManager);
            CursorBuilder cursorBuilder = new CursorBuilder(this, evaluatorBuilder);
            this.setSearchEngine(new DefaultSearchEngine(this, cursorBuilder, evaluatorBuilder, this.getOptimizer()));
            File partitionDir = new File(this.getPartitionPath());
            if (!partitionDir.exists() && !partitionDir.mkdirs()) {
                throw new LdapOtherException(I18n.err(I18n.ERR_112_COULD_NOT_CREATE_DIRECTORY, partitionDir));
            }
            if (this.cacheSize < 0) {
                this.cacheSize = 10000;
                LOG.debug("Using the default entry cache size of {} for {} partition", (Object)this.cacheSize, (Object)this.id);
            } else {
                LOG.debug("Using the custom configured cache size of {} for {} partition", (Object)this.cacheSize, (Object)this.id);
            }
            this.recordMan = new RecordManager(partitionDir.getPath());
            super.doInit();
            Cache masterTableCache = this.cacheService.getCache(this.suffixDn.getName());
            try {
                this.master = new MavibotMasterTable(this.recordMan, this.schemaManager, "master", masterTableCache.getCacheConfiguration().getMaxElementsInMemory());
            }
            catch (IOException ioe) {
                throw new LdapOtherException(ioe.getMessage(), ioe);
            }
            File[] allIndexDbFiles = partitionDir.listFiles(DB_FILTER);
            List<String> indexDbFileNameList = Arrays.asList(partitionDir.list(DB_FILTER));
            ArrayList<String> allIndices = new ArrayList<String>();
            for (Index index : this.systemIndices.values()) {
                allIndices.add(index.getAttribute().getOid());
            }
            ArrayList indexToBuild = new ArrayList();
            if (this.cacheService != null) {
                this.entryCache = this.cacheService.getCache(this.getId());
                int cacheSizeConfig = this.entryCache.getCacheConfiguration().getMaxElementsInMemory();
                if (cacheSizeConfig < this.cacheSize) {
                    this.entryCache.getCacheConfiguration().setMaxElementsInMemory(this.cacheSize);
                }
            }
            this.initialized = true;
        }
    }

    @Override
    protected Index<?, String> convertAndInit(Index<?, String> index) throws LdapException {
        MavibotIndex mavibotIndex;
        if (index instanceof MavibotRdnIndex) {
            mavibotIndex = (MavibotRdnIndex)index;
        } else if (index instanceof MavibotDnIndex) {
            mavibotIndex = (MavibotDnIndex)index;
        } else if (index instanceof MavibotIndex) {
            mavibotIndex = (MavibotIndex)index;
            if (mavibotIndex.getWkDirPath() == null) {
                mavibotIndex.setWkDirPath(this.partitionPath);
            }
        } else {
            LOG.debug("Supplied index {} is not a MavibotIndex.  Will create new MavibotIndex using copied configuration parameters.", (Object)index);
            mavibotIndex = new MavibotIndex(index.getAttributeId(), true);
            mavibotIndex.setCacheSize(index.getCacheSize());
            mavibotIndex.setWkDirPath(index.getWkDirPath());
        }
        mavibotIndex.setRecordManager(this.recordMan);
        try {
            mavibotIndex.init(this.schemaManager, this.schemaManager.lookupAttributeTypeRegistry(index.getAttributeId()));
        }
        catch (IOException ioe) {
            throw new LdapOtherException(ioe.getMessage(), ioe);
        }
        return mavibotIndex;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected synchronized void doDestroy(PartitionTxn partitionTxn) throws LdapException {
        MultiException errors = new MultiException(I18n.err(I18n.ERR_577, new Object[0]));
        if (!this.initialized) {
            return;
        }
        try {
            super.doDestroy(partitionTxn);
        }
        catch (Exception e) {
            errors.addThrowable(e);
        }
        try {
            this.recordMan.close();
            LOG.debug("Closed record manager for {} partition.", (Object)this.suffixDn);
        }
        catch (Throwable t) {
            LOG.error(I18n.err(I18n.ERR_127, new Object[0]), t);
            errors.addThrowable(t);
        }
        finally {
            if (this.entryCache != null) {
                this.entryCache.removeAll();
            }
        }
        if (errors.size() > 0) {
            throw new LdapOtherException(errors.getMessage(), errors);
        }
    }

    @Override
    protected Index createSystemIndex(String indexOid, URI path, boolean withReverse) throws LdapException {
        MavibotIndex mavibotIndex;
        LOG.debug("Supplied index {} is not a MavibotIndex.  Will create new MavibotIndex using copied configuration parameters.");
        if (indexOid.equals("1.3.6.1.4.1.18060.0.4.1.2.50")) {
            mavibotIndex = new MavibotRdnIndex();
            mavibotIndex.setAttributeId("1.3.6.1.4.1.18060.0.4.1.2.50");
        } else if (indexOid.equals("1.3.6.1.4.1.18060.0.4.1.2.7")) {
            mavibotIndex = new MavibotDnIndex("1.3.6.1.4.1.18060.0.4.1.2.7");
            mavibotIndex.setAttributeId("1.3.6.1.4.1.18060.0.4.1.2.7");
        } else {
            mavibotIndex = new MavibotIndex(indexOid, withReverse);
        }
        mavibotIndex.setWkDirPath(path);
        return mavibotIndex;
    }

    private void deleteUnusedIndexFiles(List<String> allIndices, File[] dbFiles) {
    }

    private void buildUserIndex(PartitionTxn partitionTxn, List<Index<?, String>> userIndexes) throws Exception {
        Cursor cursor = this.master.cursor();
        cursor.beforeFirst();
        while (cursor.next()) {
            for (Index<?, String> index : userIndexes) {
                AttributeType atType = index.getAttribute();
                String attributeOid = index.getAttribute().getOid();
                LOG.info("building the index for attribute type {}", (Object)atType);
                Tuple tuple = cursor.get();
                String id = (String)tuple.getKey();
                Entry entry = (Entry)tuple.getValue();
                Attribute entryAttr = entry.get(atType);
                if (entryAttr == null) continue;
                for (Value value : entryAttr) {
                    index.add(partitionTxn, value.getValue(), id);
                }
                this.presenceIdx.add(partitionTxn, attributeOid, id);
            }
        }
        cursor.close();
    }

    public String getDefaultId() {
        return Partition.DEFAULT_ID;
    }

    public String getRootId() {
        return Partition.ROOT_ID;
    }

    public RecordManager getRecordMan() {
        return this.recordMan;
    }

    @Override
    public Entry lookupCache(String id) {
        if (this.entryCache == null) {
            return null;
        }
        Element el = this.entryCache.get((Serializable)((Object)id));
        if (el != null) {
            return (Entry)el.getValue();
        }
        return null;
    }

    @Override
    public void addToCache(String id, Entry entry) {
        if (this.entryCache == null) {
            return;
        }
        if (entry instanceof ClonedServerEntry) {
            entry = ((ClonedServerEntry)entry).getOriginalEntry();
        }
        this.entryCache.put(new Element((Serializable)((Object)id), entry));
    }

    @Override
    public void updateCache(OperationContext opCtx) {
        if (this.entryCache == null) {
            return;
        }
        try {
            if (opCtx instanceof ModifyOperationContext) {
                ModifyOperationContext modCtx = (ModifyOperationContext)opCtx;
                Entry entry = modCtx.getAlteredEntry();
                String id = entry.get("entryUUID").getString();
                if (entry instanceof ClonedServerEntry) {
                    entry = ((ClonedServerEntry)entry).getOriginalEntry();
                }
                this.entryCache.replace(new Element((Serializable)((Object)id), entry));
            } else if (opCtx instanceof MoveOperationContext || opCtx instanceof MoveAndRenameOperationContext || opCtx instanceof RenameOperationContext) {
                this.entryCache.removeAll();
            } else if (opCtx instanceof DeleteOperationContext) {
                DeleteOperationContext delCtx = (DeleteOperationContext)opCtx;
                this.entryCache.remove((Serializable)((Object)delCtx.getEntry().get("entryUUID").getString()));
            }
        }
        catch (LdapException e) {
            LOG.warn("Failed to update entry cache", e);
        }
    }

    public Set<Index<?, String>> getAllIndices() {
        HashSet all = new HashSet(this.systemIndices.values());
        all.addAll(this.userIndices.values());
        return all;
    }

    @Override
    public PartitionReadTxn beginReadTransaction() {
        return new PartitionReadTxn();
    }

    @Override
    public PartitionWriteTxn beginWriteTransaction() {
        return new PartitionWriteTxn();
    }
}

