/*
 * Decompiled with CFR 0.152.
 */
package org.apache.directory.api.ldap.model.schema.comparators;

import java.io.Serializable;
import java.math.BigInteger;
import org.apache.directory.api.i18n.I18n;
import org.apache.directory.api.ldap.model.entry.Value;
import org.apache.directory.api.ldap.model.exception.LdapException;
import org.apache.directory.api.ldap.model.schema.LdapComparator;
import org.apache.directory.api.ldap.model.schema.normalizers.NumericNormalizer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class IntegerComparator
extends LdapComparator<Object>
implements Serializable {
    private static final long serialVersionUID = 2L;
    private static final Logger LOG = LoggerFactory.getLogger(IntegerComparator.class);

    public IntegerComparator(String oid) {
        super(oid);
    }

    @Override
    public int compare(Object v1, Object v2) {
        if (v1 instanceof String) {
            return this.compare((String)v1, (String)v2);
        }
        if (v1 instanceof Value) {
            return this.compare(((Value)v1).getValue(), ((Value)v2).getValue());
        }
        return this.compare((Long)v1, (Long)v2);
    }

    @Override
    private int compare(Long backendValue, Long assertValue) {
        if (LOG.isDebugEnabled()) {
            LOG.debug(I18n.msg(I18n.MSG_13746_COMPARING_INTEGER, backendValue, assertValue));
        }
        if (backendValue == assertValue) {
            return 0;
        }
        if (backendValue == null || assertValue == null) {
            return backendValue == null ? -1 : 1;
        }
        return backendValue.compareTo(assertValue);
    }

    @Override
    private int compare(String backendValue, String assertValue) {
        if (LOG.isDebugEnabled()) {
            LOG.debug(I18n.msg(I18n.MSG_13746_COMPARING_INTEGER, backendValue, assertValue));
        }
        if (backendValue == assertValue) {
            return 0;
        }
        if (backendValue == null || assertValue == null) {
            return backendValue == null ? -1 : 1;
        }
        NumericNormalizer normalizer = new NumericNormalizer();
        try {
            backendValue = normalizer.normalize(backendValue);
        }
        catch (LdapException le) {
            throw new IllegalArgumentException(I18n.err(I18n.ERR_13724_INVALID_VALUE, backendValue), le);
        }
        try {
            assertValue = normalizer.normalize(assertValue);
        }
        catch (LdapException le) {
            throw new IllegalArgumentException(I18n.err(I18n.ERR_13724_INVALID_VALUE, assertValue), le);
        }
        BigInteger b1 = new BigInteger(backendValue);
        BigInteger b2 = new BigInteger(assertValue);
        return b1.compareTo(b2);
    }
}

