/*
 * Decompiled with CFR 0.152.
 */
package org.apache.directory.api.ldap.codec.actions.controls;

import org.apache.directory.api.asn1.DecoderException;
import org.apache.directory.api.asn1.ber.grammar.GrammarAction;
import org.apache.directory.api.asn1.ber.tlv.TLV;
import org.apache.directory.api.asn1.util.Oid;
import org.apache.directory.api.i18n.I18n;
import org.apache.directory.api.ldap.codec.api.CodecControl;
import org.apache.directory.api.ldap.codec.api.LdapMessageContainer;
import org.apache.directory.api.ldap.codec.api.MessageDecorator;
import org.apache.directory.api.ldap.model.message.Control;
import org.apache.directory.api.ldap.model.message.Message;
import org.apache.directory.api.util.Strings;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AddControl
extends GrammarAction<LdapMessageContainer<MessageDecorator<? extends Message>>> {
    private static final Logger LOG = LoggerFactory.getLogger(AddControl.class);

    public AddControl() {
        super("Add a new control");
    }

    @Override
    public void action(LdapMessageContainer<MessageDecorator<? extends Message>> container) throws DecoderException {
        TLV tlv = container.getCurrentTLV();
        if (tlv.getLength() == 0) {
            String msg = I18n.err(I18n.ERR_08214_NULL_OID, new Object[0]);
            LOG.error(msg);
            throw new DecoderException(msg);
        }
        byte[] value = tlv.getValue().getData();
        String oidValue = Strings.asciiBytesToString(value);
        if (!Oid.isOid(oidValue)) {
            String msg = I18n.err(I18n.ERR_08215_INVALID_CONTROL_OID, oidValue);
            LOG.error(msg);
            throw new DecoderException(msg);
        }
        MessageDecorator<? extends Message> message = container.getMessage();
        CodecControl<? extends Control> control = container.getLdapCodecService().newControl(oidValue);
        message.addControl(control);
        container.setGrammarEndAllowed(true);
        if (LOG.isDebugEnabled()) {
            LOG.debug(I18n.msg(I18n.MSG_08201_CONTROL_OID, oidValue));
        }
    }
}

