/*
 * Decompiled with CFR 0.152.
 */
package org.apache.directory.server.ldap;

import org.apache.directory.server.ldap.LdapServer;
import org.apache.directory.server.ldap.LdapSession;
import org.apache.directory.shared.ldap.codec.api.LdapApiServiceFactory;
import org.apache.directory.shared.ldap.codec.api.LdapMessageContainer;
import org.apache.directory.shared.ldap.codec.api.SchemaBinaryAttributeDetector;
import org.apache.directory.shared.ldap.model.exception.ResponseCarryingMessageException;
import org.apache.directory.shared.ldap.model.message.Control;
import org.apache.directory.shared.ldap.model.message.Request;
import org.apache.directory.shared.ldap.model.message.ResultCodeEnum;
import org.apache.directory.shared.ldap.model.message.ResultResponseRequest;
import org.apache.directory.shared.ldap.model.message.extended.NoticeOfDisconnect;
import org.apache.mina.core.session.IoSession;
import org.apache.mina.filter.ssl.SslFilter;
import org.apache.mina.handler.demux.DemuxingIoHandler;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class LdapProtocolHandler
extends DemuxingIoHandler {
    private static final Logger LOG = LoggerFactory.getLogger(LdapProtocolHandler.class);
    private final LdapServer ldapServer;

    LdapProtocolHandler(LdapServer ldapServer) {
        this.ldapServer = ldapServer;
    }

    @Override
    public void sessionCreated(IoSession session) throws Exception {
        LdapSession ldapSession = new LdapSession(session);
        this.ldapServer.getLdapSessionManager().addLdapSession(ldapSession);
        session.setAttribute("LDAP-maxPduSize", this.ldapServer.getDirectoryService().getMaxPDUSize());
        LdapMessageContainer ldapMessageContainer = new LdapMessageContainer(this.ldapServer.getDirectoryService().getLdapCodecService(), new SchemaBinaryAttributeDetector(this.ldapServer.getDirectoryService().getSchemaManager()));
        session.setAttribute("LDAP-container", ldapMessageContainer);
    }

    @Override
    public void sessionClosed(IoSession session) {
        LdapSession ldapSession = this.ldapServer.getLdapSessionManager().removeLdapSession(session);
        this.cleanUpSession(ldapSession);
    }

    private void cleanUpSession(LdapSession ldapSession) {
        if (ldapSession == null) {
            LOG.warn("Null LdapSession given to cleanUpSession.");
            return;
        }
        LOG.debug("Cleaning the {} session", ldapSession);
        ldapSession.abandonAllOutstandingRequests();
        if (!ldapSession.getIoSession().isClosing() || ldapSession.getIoSession().isConnected()) {
            try {
                ldapSession.getIoSession().close(true);
            }
            catch (Throwable t) {
                LOG.warn("Failed to close IoSession for LdapSession.");
            }
        }
    }

    @Override
    public void messageSent(IoSession session, Object message) throws Exception {
    }

    @Override
    public void messageReceived(IoSession session, Object message) throws Exception {
        ResultResponseRequest<Object> req;
        if (message == SslFilter.SESSION_SECURED) {
            req = LdapApiServiceFactory.getSingleton().newExtendedRequest("1.3.6.1.4.1.1466.20037", "SECURED".getBytes("ISO-8859-1"));
            message = req;
        } else if (message == SslFilter.SESSION_UNSECURED) {
            req = LdapApiServiceFactory.getSingleton().newExtendedRequest("1.3.6.1.4.1.1466.20037", "SECURED".getBytes("ISO-8859-1"));
            message = req;
        }
        if (((Request)message).getControls().size() > 0 && message instanceof ResultResponseRequest) {
            req = message;
            for (Control control : req.getControls().values()) {
                if (!control.isCritical() || this.ldapServer.getSupportedControls().contains(control.getOid())) continue;
                Object resp = req.getResultResponse();
                resp.getLdapResult().setDiagnosticMessage("Unsupport critical control: " + control.getOid());
                resp.getLdapResult().setResultCode(ResultCodeEnum.UNAVAILABLE_CRITICAL_EXTENSION);
                session.write(resp);
                return;
            }
        }
        super.messageReceived(session, message);
    }

    @Override
    public void exceptionCaught(IoSession session, Throwable cause) {
        ResponseCarryingMessageException rcme;
        if (cause.getCause() instanceof ResponseCarryingMessageException && (rcme = (ResponseCarryingMessageException)cause.getCause()).getResponse() != null) {
            session.write(rcme.getResponse());
            return;
        }
        LOG.warn("Unexpected exception forcing session to close: sending disconnect notice to client.", cause);
        session.write(NoticeOfDisconnect.PROTOCOLERROR);
        LdapSession ldapSession = this.ldapServer.getLdapSessionManager().removeLdapSession(session);
        this.cleanUpSession(ldapSession);
        session.close(true);
    }
}

