/*
 * Decompiled with CFR 0.152.
 */
package org.apache.directory.shared.ldap.codec.decorators;

import java.nio.BufferOverflowException;
import java.nio.ByteBuffer;
import org.apache.directory.shared.asn1.EncoderException;
import org.apache.directory.shared.asn1.ber.tlv.TLV;
import org.apache.directory.shared.i18n.I18n;
import org.apache.directory.shared.ldap.codec.api.LdapApiService;
import org.apache.directory.shared.ldap.codec.decorators.LdapResultDecorator;
import org.apache.directory.shared.ldap.codec.decorators.ResponseDecorator;
import org.apache.directory.shared.ldap.model.message.CompareResponse;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CompareResponseDecorator
extends ResponseDecorator<CompareResponse>
implements CompareResponse {
    private int compareResponseLength;

    public CompareResponseDecorator(LdapApiService codec, CompareResponse decoratedMessage) {
        super(codec, decoratedMessage);
    }

    public void setCompareResponseLength(int compareResponseLength) {
        this.compareResponseLength = compareResponseLength;
    }

    public int getCompareResponseLength() {
        return this.compareResponseLength;
    }

    @Override
    public boolean isTrue() {
        return ((CompareResponse)this.getDecorated()).isTrue();
    }

    @Override
    public int computeLength() {
        int compareResponseLength = ((LdapResultDecorator)this.getLdapResult()).computeLength();
        this.setCompareResponseLength(compareResponseLength);
        return 1 + TLV.getNbBytes(compareResponseLength) + compareResponseLength;
    }

    @Override
    public ByteBuffer encode(ByteBuffer buffer) throws EncoderException {
        try {
            buffer.put((byte)111);
            buffer.put(TLV.getBytes(this.getCompareResponseLength()));
            ((LdapResultDecorator)this.getLdapResult()).encode(buffer);
        }
        catch (BufferOverflowException boe) {
            throw new EncoderException(I18n.err(I18n.ERR_04005, new Object[0]));
        }
        return buffer;
    }
}

