/*
 * Decompiled with CFR 0.152.
 */
package org.apache.directory.server.ldap.handlers;

import org.apache.directory.server.core.api.CoreSession;
import org.apache.directory.server.ldap.LdapSession;
import org.apache.directory.server.ldap.handlers.LdapRequestHandler;
import org.apache.directory.shared.ldap.model.message.LdapResult;
import org.apache.directory.shared.ldap.model.message.ModifyRequest;
import org.apache.directory.shared.ldap.model.message.ModifyResponse;
import org.apache.directory.shared.ldap.model.message.ResultCodeEnum;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ModifyHandler
extends LdapRequestHandler<ModifyRequest> {
    private static final Logger LOG = LoggerFactory.getLogger(ModifyHandler.class);

    @Override
    public void handle(LdapSession session, ModifyRequest req) {
        LOG.debug("Handling request : {}", req);
        LdapResult result = ((ModifyResponse)req.getResultResponse()).getLdapResult();
        try {
            CoreSession coreSession = session.getCoreSession();
            coreSession.modify(req);
            result.setResultCode(ResultCodeEnum.SUCCESS);
            session.getIoSession().write(req.getResultResponse());
        }
        catch (Exception e) {
            this.handleException(session, req, e);
        }
    }
}

