/*
 * Decompiled with CFR 0.152.
 */
package org.apache.directory.server.core.trigger;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.directory.server.core.api.CoreSession;
import org.apache.directory.server.core.api.LdapPrincipal;
import org.apache.directory.server.core.api.interceptor.context.LookupOperationContext;
import org.apache.directory.server.core.api.interceptor.context.OperationContext;
import org.apache.directory.server.core.trigger.StoredProcedureParameterInjector;
import org.apache.directory.shared.ldap.model.constants.SchemaConstants;
import org.apache.directory.shared.ldap.model.exception.LdapException;
import org.apache.directory.shared.ldap.model.exception.LdapInvalidDnException;
import org.apache.directory.shared.ldap.model.name.Dn;
import org.apache.directory.shared.ldap.trigger.StoredProcedureParameter;

public abstract class AbstractStoredProcedureParameterInjector
implements StoredProcedureParameterInjector {
    private OperationContext opContext;
    private Map<Class<?>, StoredProcedureParameterInjector.MicroInjector> injectors;
    StoredProcedureParameterInjector.MicroInjector $operationPrincipalInjector = new StoredProcedureParameterInjector.MicroInjector(){

        @Override
        public Object inject(OperationContext opContext, StoredProcedureParameter param) throws LdapException {
            return AbstractStoredProcedureParameterInjector.this.getOperationPrincipal();
        }
    };
    StoredProcedureParameterInjector.MicroInjector $ldapContextInjector = new StoredProcedureParameterInjector.MicroInjector(){

        @Override
        public Object inject(OperationContext opContext, StoredProcedureParameter param) throws LdapException {
            StoredProcedureParameter.Generic_LDAP_CONTEXT ldapCtxParam = (StoredProcedureParameter.Generic_LDAP_CONTEXT)param;
            Dn ldapCtxName = ldapCtxParam.getCtxName();
            CoreSession session = opContext.getSession();
            LookupOperationContext lookupContext = new LookupOperationContext(session, ldapCtxName);
            lookupContext.setAttrsId(SchemaConstants.ALL_ATTRIBUTES_ARRAY);
            return session.getDirectoryService().getPartitionNexus().lookup(lookupContext);
        }
    };

    public AbstractStoredProcedureParameterInjector(OperationContext opContext) {
        this.opContext = opContext;
        this.injectors = new HashMap();
        this.injectors.put(StoredProcedureParameter.Generic_OPERATION_PRINCIPAL.class, this.$operationPrincipalInjector);
        this.injectors.put(StoredProcedureParameter.Generic_LDAP_CONTEXT.class, this.$ldapContextInjector);
    }

    protected Dn getOperationPrincipal() throws LdapInvalidDnException {
        LdapPrincipal principal = this.opContext.getSession().getEffectivePrincipal();
        Dn userName = this.opContext.getSession().getDirectoryService().getDnFactory().create(principal.getName());
        return userName;
    }

    protected Map<Class<?>, StoredProcedureParameterInjector.MicroInjector> getInjectors() {
        return this.injectors;
    }

    public OperationContext getOperationContext() {
        return this.opContext;
    }

    public void setOperationContext(OperationContext invocation) {
        this.opContext = invocation;
    }

    @Override
    public final List<Object> getArgumentsToInject(OperationContext opContext, List<StoredProcedureParameter> parameterList) throws LdapException {
        ArrayList<Object> arguments = new ArrayList<Object>();
        for (StoredProcedureParameter spParameter : parameterList) {
            StoredProcedureParameterInjector.MicroInjector injector = this.injectors.get(spParameter.getClass());
            arguments.add(injector.inject(opContext, spParameter));
        }
        return arguments;
    }
}

