/*
 * Decompiled with CFR 0.152.
 */
package org.apache.directory.server.core.exception;

import org.apache.commons.collections.map.LRUMap;
import org.apache.directory.server.core.api.CoreSession;
import org.apache.directory.server.core.api.DirectoryService;
import org.apache.directory.server.core.api.InterceptorEnum;
import org.apache.directory.server.core.api.entry.ClonedServerEntry;
import org.apache.directory.server.core.api.filtering.BaseEntryFilteringCursor;
import org.apache.directory.server.core.api.filtering.EntryFilteringCursor;
import org.apache.directory.server.core.api.interceptor.BaseInterceptor;
import org.apache.directory.server.core.api.interceptor.context.AddOperationContext;
import org.apache.directory.server.core.api.interceptor.context.DeleteOperationContext;
import org.apache.directory.server.core.api.interceptor.context.HasEntryOperationContext;
import org.apache.directory.server.core.api.interceptor.context.ListOperationContext;
import org.apache.directory.server.core.api.interceptor.context.LookupOperationContext;
import org.apache.directory.server.core.api.interceptor.context.ModifyOperationContext;
import org.apache.directory.server.core.api.interceptor.context.MoveAndRenameOperationContext;
import org.apache.directory.server.core.api.interceptor.context.MoveOperationContext;
import org.apache.directory.server.core.api.interceptor.context.OperationContext;
import org.apache.directory.server.core.api.interceptor.context.RenameOperationContext;
import org.apache.directory.server.core.api.partition.PartitionNexus;
import org.apache.directory.server.core.shared.SchemaService;
import org.apache.directory.server.i18n.I18n;
import org.apache.directory.shared.ldap.model.constants.SchemaConstants;
import org.apache.directory.shared.ldap.model.cursor.EmptyCursor;
import org.apache.directory.shared.ldap.model.entry.Attribute;
import org.apache.directory.shared.ldap.model.entry.Entry;
import org.apache.directory.shared.ldap.model.entry.Value;
import org.apache.directory.shared.ldap.model.exception.LdapAliasException;
import org.apache.directory.shared.ldap.model.exception.LdapEntryAlreadyExistsException;
import org.apache.directory.shared.ldap.model.exception.LdapException;
import org.apache.directory.shared.ldap.model.exception.LdapNoSuchObjectException;
import org.apache.directory.shared.ldap.model.exception.LdapUnwillingToPerformException;
import org.apache.directory.shared.ldap.model.message.ResultCodeEnum;
import org.apache.directory.shared.ldap.model.name.Dn;

public class ExceptionInterceptor
extends BaseInterceptor {
    private PartitionNexus nexus;
    private Dn subschemSubentryDn;
    private final LRUMap notAliasCache = new LRUMap(100);
    private static final int DEFAULT_CACHE_SIZE = 100;

    public ExceptionInterceptor() {
        super(InterceptorEnum.EXCEPTION_INTERCEPTOR);
    }

    @Override
    public void init(DirectoryService directoryService) throws LdapException {
        super.init(directoryService);
        this.nexus = directoryService.getPartitionNexus();
        Value<?> attr = this.nexus.getRootDse(null).get("subschemaSubentry").get();
        this.subschemSubentryDn = directoryService.getDnFactory().create(attr.getString());
    }

    @Override
    public void destroy() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void add(AddOperationContext addContext) throws LdapException {
        boolean notAnAlias;
        Dn name = addContext.getDn();
        if (this.subschemSubentryDn.equals(name)) {
            throw new LdapEntryAlreadyExistsException(I18n.err(I18n.ERR_249, new Object[0]));
        }
        Dn suffix = this.nexus.getSuffixDn(name);
        if (suffix.equals(name)) {
            this.next(addContext);
            return;
        }
        Dn parentDn = name.getParent();
        LRUMap lRUMap = this.notAliasCache;
        synchronized (lRUMap) {
            notAnAlias = this.notAliasCache.containsKey(parentDn.getNormName());
        }
        if (!notAnAlias) {
            Entry attrs;
            try {
                CoreSession session = addContext.getSession();
                LookupOperationContext lookupContext = new LookupOperationContext(session, parentDn);
                lookupContext.setAttrsId(SchemaConstants.ALL_ATTRIBUTES_ARRAY);
                attrs = this.directoryService.getPartitionNexus().lookup(lookupContext);
            }
            catch (Exception e) {
                LdapNoSuchObjectException e2 = new LdapNoSuchObjectException(I18n.err(I18n.ERR_251_PARENT_NOT_FOUND, parentDn.getName()));
                throw e2;
            }
            Attribute objectClass = ((ClonedServerEntry)attrs).getOriginalEntry().get(OBJECT_CLASS_AT);
            if (objectClass.contains("alias")) {
                String msg = I18n.err(I18n.ERR_252_ALIAS_WITH_CHILD_NOT_ALLOWED, name.getName(), parentDn.getName());
                LdapAliasException e = new LdapAliasException(msg);
                throw e;
            }
            LRUMap lRUMap2 = this.notAliasCache;
            synchronized (lRUMap2) {
                this.notAliasCache.put(parentDn.getNormName(), parentDn);
            }
        }
        this.next(addContext);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void delete(DeleteOperationContext deleteContext) throws LdapException {
        Dn dn = deleteContext.getDn();
        if (dn.equals(this.subschemSubentryDn)) {
            throw new LdapUnwillingToPerformException(ResultCodeEnum.UNWILLING_TO_PERFORM, I18n.err(I18n.ERR_253, this.subschemSubentryDn));
        }
        this.next(deleteContext);
        LRUMap lRUMap = this.notAliasCache;
        synchronized (lRUMap) {
            if (this.notAliasCache.containsKey(dn.getNormName())) {
                this.notAliasCache.remove(dn.getNormName());
            }
        }
    }

    @Override
    public EntryFilteringCursor list(ListOperationContext listContext) throws LdapException {
        if (listContext.getDn().getNormName().equals(this.subschemSubentryDn.getNormName())) {
            return new BaseEntryFilteringCursor(new EmptyCursor<Entry>(), listContext);
        }
        return this.next(listContext);
    }

    @Override
    public Entry lookup(LookupOperationContext lookupContext) throws LdapException {
        Dn dn = lookupContext.getDn();
        if (dn.equals(this.subschemSubentryDn)) {
            Entry serverEntry = SchemaService.getSubschemaEntry(this.directoryService, lookupContext.getAttrsIdArray());
            serverEntry.setDn(dn);
            return serverEntry;
        }
        Entry result = this.next(lookupContext);
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void modify(ModifyOperationContext modifyContext) throws LdapException {
        String msg = "Attempt to modify non-existant entry: ";
        if (modifyContext.getDn().equals(this.subschemSubentryDn)) {
            this.next(modifyContext);
            return;
        }
        this.assertHasEntry(modifyContext, msg);
        LRUMap lRUMap = this.notAliasCache;
        synchronized (lRUMap) {
            if (this.notAliasCache.containsKey(modifyContext.getDn().getNormName())) {
                this.notAliasCache.remove(modifyContext.getDn().getNormName());
            }
        }
        this.next(modifyContext);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void move(MoveOperationContext moveContext) throws LdapException {
        Dn oriChildName = moveContext.getDn();
        if (oriChildName.equals(this.subschemSubentryDn)) {
            throw new LdapUnwillingToPerformException(ResultCodeEnum.UNWILLING_TO_PERFORM, I18n.err(I18n.ERR_258, this.subschemSubentryDn, this.subschemSubentryDn));
        }
        this.next(moveContext);
        LRUMap lRUMap = this.notAliasCache;
        synchronized (lRUMap) {
            if (this.notAliasCache.containsKey(oriChildName.getNormName())) {
                this.notAliasCache.remove(oriChildName.getNormName());
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void moveAndRename(MoveAndRenameOperationContext moveAndRenameContext) throws LdapException {
        Dn oldDn = moveAndRenameContext.getDn();
        if (oldDn.equals(this.subschemSubentryDn)) {
            throw new LdapUnwillingToPerformException(ResultCodeEnum.UNWILLING_TO_PERFORM, I18n.err(I18n.ERR_258, this.subschemSubentryDn, this.subschemSubentryDn));
        }
        LRUMap lRUMap = this.notAliasCache;
        synchronized (lRUMap) {
            if (this.notAliasCache.containsKey(oldDn.getNormName())) {
                this.notAliasCache.remove(oldDn.getNormName());
            }
        }
        this.next(moveAndRenameContext);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void rename(RenameOperationContext renameContext) throws LdapException {
        Dn dn = renameContext.getDn();
        if (dn.equals(this.subschemSubentryDn)) {
            throw new LdapUnwillingToPerformException(ResultCodeEnum.UNWILLING_TO_PERFORM, I18n.err(I18n.ERR_255, this.subschemSubentryDn, this.subschemSubentryDn));
        }
        Dn newDn = renameContext.getNewDn();
        if (this.nexus.hasEntry(new HasEntryOperationContext(renameContext.getSession(), newDn)) && !newDn.equals(dn)) {
            LdapEntryAlreadyExistsException e = new LdapEntryAlreadyExistsException(I18n.err(I18n.ERR_250_ENTRY_ALREADY_EXISTS, newDn.getName()));
            throw e;
        }
        LRUMap lRUMap = this.notAliasCache;
        synchronized (lRUMap) {
            if (this.notAliasCache.containsKey(dn.getNormName())) {
                this.notAliasCache.remove(dn.getNormName());
            }
        }
        this.next(renameContext);
    }

    private void assertHasEntry(OperationContext opContext, String msg) throws LdapException {
        Dn dn = opContext.getDn();
        if (this.subschemSubentryDn.equals(dn)) {
            return;
        }
        if (opContext.getEntry() == null) {
            LdapNoSuchObjectException e = msg != null ? new LdapNoSuchObjectException(msg + dn.getName()) : new LdapNoSuchObjectException(dn.getName());
            throw e;
        }
    }
}

