/*
 * Decompiled with CFR 0.152.
 */
package org.apache.directory.server.config.beans;

import java.util.ArrayList;
import java.util.List;
import org.apache.directory.server.config.ConfigurationElement;
import org.apache.directory.server.config.beans.AdsBaseBean;
import org.apache.directory.server.config.beans.ChangeLogBean;
import org.apache.directory.server.config.beans.ChangePasswordServerBean;
import org.apache.directory.server.config.beans.DhcpServerBean;
import org.apache.directory.server.config.beans.DnsServerBean;
import org.apache.directory.server.config.beans.HttpServerBean;
import org.apache.directory.server.config.beans.InterceptorBean;
import org.apache.directory.server.config.beans.JournalBean;
import org.apache.directory.server.config.beans.KdcServerBean;
import org.apache.directory.server.config.beans.LdapServerBean;
import org.apache.directory.server.config.beans.NtpServerBean;
import org.apache.directory.server.config.beans.PartitionBean;
import org.apache.directory.server.config.beans.ServerBean;

public class DirectoryServiceBean
extends AdsBaseBean {
    @ConfigurationElement(attributeType="ads-directoryServiceId", isRdn=true)
    private String directoryServiceId;
    @ConfigurationElement(attributeType="ads-dsReplicaId")
    private int dsReplicaId;
    @ConfigurationElement(attributeType="ads-dsAccessControlEnabled")
    private boolean dsAccessControlEnabled = true;
    @ConfigurationElement(attributeType="ads-dsAllowAnonymousAccess")
    private boolean dsAllowAnonymousAccess = false;
    @ConfigurationElement(attributeType="ads-dsDenormalizeOpAttrsEnabled")
    private boolean dsDenormalizeOpAttrsEnabled = true;
    @ConfigurationElement(attributeType="ads-dsMaxPDUSize")
    private int dsMaxPDUSize = 2048;
    @ConfigurationElement(attributeType="ads-dsPasswordHidden", isOptional=true, defaultValue="false")
    private boolean dsPasswordHidden = false;
    @ConfigurationElement(attributeType="ads-dsSyncPeriodMillis")
    private long dsSyncPeriodMillis = 15000L;
    @ConfigurationElement(attributeType="dsTestEntries")
    private String dsTestEntries;
    @ConfigurationElement
    private ChangeLogBean changeLog;
    @ConfigurationElement
    private JournalBean journal;
    @ConfigurationElement(attributeType="ads-servers", container="servers")
    private List<ServerBean> servers = new ArrayList<ServerBean>();
    @ConfigurationElement(attributeType="ads-interceptors", container="interceptors")
    private List<InterceptorBean> interceptors = new ArrayList<InterceptorBean>();
    @ConfigurationElement(attributeType="ads-partitions", container="partitions")
    private List<PartitionBean> partitions = new ArrayList<PartitionBean>();

    public void setDirectoryServiceId(String directoryServiceId) {
        this.directoryServiceId = directoryServiceId;
    }

    public String getDirectoryServiceId() {
        return this.directoryServiceId;
    }

    public int getDsReplicaId() {
        return this.dsReplicaId;
    }

    public void setDsReplicaId(int dsReplicaId) {
        this.dsReplicaId = dsReplicaId < 0 || dsReplicaId > 999 ? 0 : dsReplicaId;
    }

    public List<InterceptorBean> getInterceptors() {
        return this.interceptors;
    }

    public void setInterceptors(List<InterceptorBean> interceptors) {
        this.interceptors = interceptors;
    }

    public void addInterceptors(InterceptorBean ... interceptors) {
        for (InterceptorBean interceptor : interceptors) {
            this.interceptors.add(interceptor);
        }
    }

    public boolean isDsAccessControlEnabled() {
        return this.dsAccessControlEnabled;
    }

    public void setDsAccessControlEnabled(boolean dsAccessControlEnabled) {
        this.dsAccessControlEnabled = dsAccessControlEnabled;
    }

    public boolean isDsAllowAnonymousAccess() {
        return this.dsAllowAnonymousAccess;
    }

    public void setDsAllowAnonymousAccess(boolean dsAllowAnonymousAccess) {
        this.dsAllowAnonymousAccess = dsAllowAnonymousAccess;
    }

    public boolean isDsDenormalizeOpAttrsEnabled() {
        return this.dsDenormalizeOpAttrsEnabled;
    }

    public void setDsDenormalizeOpAttrsEnabled(boolean dsDenormalizeOpAttrsEnabled) {
        this.dsDenormalizeOpAttrsEnabled = dsDenormalizeOpAttrsEnabled;
    }

    public int getDsMaxPDUSize() {
        return this.dsMaxPDUSize;
    }

    public void setDsMaxPDUSize(int dsMaxPDUSize) {
        this.dsMaxPDUSize = dsMaxPDUSize;
    }

    public boolean isDsPasswordHidden() {
        return this.dsPasswordHidden;
    }

    public void setDsPasswordHidden(boolean dsPasswordHidden) {
        this.dsPasswordHidden = dsPasswordHidden;
    }

    public long getDsSyncPeriodMillis() {
        return this.dsSyncPeriodMillis;
    }

    public void setDsSyncPeriodMillis(long dsSyncPeriodMillis) {
        this.dsSyncPeriodMillis = dsSyncPeriodMillis;
    }

    public String getDsTestEntries() {
        return this.dsTestEntries;
    }

    public void setDsTestEntries(String dsTestEntries) {
        this.dsTestEntries = dsTestEntries;
    }

    public ChangeLogBean getChangeLog() {
        return this.changeLog;
    }

    public void setChangeLog(ChangeLogBean changeLog) {
        this.changeLog = changeLog;
    }

    public JournalBean getJournal() {
        return this.journal;
    }

    public void setJournal(JournalBean journal) {
        this.journal = journal;
    }

    public List<PartitionBean> getPartitions() {
        return this.partitions;
    }

    public void setPartitions(List<PartitionBean> partitions) {
        this.partitions = partitions;
    }

    public void addPartitions(PartitionBean ... partitions) {
        for (PartitionBean partition : partitions) {
            this.partitions.add(partition);
        }
    }

    public List<ServerBean> getServers() {
        return this.servers;
    }

    public LdapServerBean getLdapServerBean() {
        for (ServerBean server : this.servers) {
            if (!(server instanceof LdapServerBean)) continue;
            return (LdapServerBean)server;
        }
        return null;
    }

    public NtpServerBean getNtpServerBean() {
        for (ServerBean server : this.servers) {
            if (!(server instanceof NtpServerBean)) continue;
            return (NtpServerBean)server;
        }
        return null;
    }

    public DnsServerBean getDnsServerBean() {
        for (ServerBean server : this.servers) {
            if (!(server instanceof DnsServerBean)) continue;
            return (DnsServerBean)server;
        }
        return null;
    }

    public DhcpServerBean getDhcpServerBean() {
        for (ServerBean server : this.servers) {
            if (!(server instanceof DhcpServerBean)) continue;
            return (DhcpServerBean)server;
        }
        return null;
    }

    public HttpServerBean getHttpServerBean() {
        for (ServerBean server : this.servers) {
            if (!(server instanceof HttpServerBean)) continue;
            return (HttpServerBean)server;
        }
        return null;
    }

    public KdcServerBean getKdcServerBean() {
        for (ServerBean server : this.servers) {
            if (!(server instanceof KdcServerBean)) continue;
            return (KdcServerBean)server;
        }
        return null;
    }

    public ChangePasswordServerBean getChangePasswordServerBean() {
        for (ServerBean server : this.servers) {
            if (!(server instanceof ChangePasswordServerBean)) continue;
            return (ChangePasswordServerBean)server;
        }
        return null;
    }

    public void setServers(List<ServerBean> servers) {
        this.servers = servers;
    }

    public void addServers(ServerBean ... servers) {
        for (ServerBean server : servers) {
            this.servers.add(server);
        }
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("DirectoryServiceBean : \n");
        sb.append(super.toString("  "));
        sb.append("  directoryService ID : ").append(this.directoryServiceId).append('\n');
        sb.append("  replica ID : ").append(this.dsReplicaId).append('\n');
        sb.append(this.toString("  ", "accessControl enabled", this.dsAccessControlEnabled));
        sb.append(this.toString("  ", "allow anonymous access", this.dsAllowAnonymousAccess));
        sb.append(this.toString("  ", "denormalized attributes enabled", this.dsDenormalizeOpAttrsEnabled));
        sb.append(this.toString("  ", "password hidden", this.dsPasswordHidden));
        sb.append("  max PDU size : ").append(this.dsMaxPDUSize).append('\n');
        sb.append("  sync period millisecond : ").append(this.dsSyncPeriodMillis).append('\n');
        sb.append(this.toString("  ", "test entries", this.dsTestEntries));
        sb.append("  interceptors : \n");
        if (this.interceptors != null && this.interceptors.size() > 0) {
            for (InterceptorBean interceptor : this.interceptors) {
                sb.append(interceptor.toString("    "));
            }
        }
        sb.append("  partitions : \n");
        if (this.partitions != null && this.partitions.size() > 0) {
            for (PartitionBean partition : this.partitions) {
                sb.append(partition.toString("    "));
            }
        }
        if (this.journal != null) {
            sb.append(this.journal.toString("  "));
        }
        if (this.changeLog != null) {
            sb.append(this.changeLog.toString("  "));
        }
        sb.append("  servers : \n");
        if (this.servers != null && this.servers.size() > 0) {
            for (ServerBean server : this.servers) {
                sb.append(server.toString("    "));
            }
        }
        sb.append('\n');
        return sb.toString();
    }
}

