/*
 * Decompiled with CFR 0.152.
 */
package org.apache.directory.shared.kerberos.codec.checksum.actions;

import org.apache.directory.shared.asn1.DecoderException;
import org.apache.directory.shared.asn1.ber.grammar.GrammarAction;
import org.apache.directory.shared.asn1.ber.tlv.IntegerDecoder;
import org.apache.directory.shared.asn1.ber.tlv.IntegerDecoderException;
import org.apache.directory.shared.asn1.ber.tlv.TLV;
import org.apache.directory.shared.asn1.ber.tlv.Value;
import org.apache.directory.shared.i18n.I18n;
import org.apache.directory.shared.kerberos.codec.checksum.ChecksumContainer;
import org.apache.directory.shared.kerberos.components.Checksum;
import org.apache.directory.shared.kerberos.crypto.checksum.ChecksumType;
import org.apache.directory.shared.util.Strings;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class StoreCksumType
extends GrammarAction<ChecksumContainer> {
    private static final Logger LOG = LoggerFactory.getLogger(StoreCksumType.class);
    private static final boolean IS_DEBUG = LOG.isDebugEnabled();

    public StoreCksumType() {
        super("Checksum cksumtype");
    }

    @Override
    public void action(ChecksumContainer checksumContainer) throws DecoderException {
        TLV tlv = checksumContainer.getCurrentTLV();
        if (tlv.getLength() == 0) {
            LOG.error(I18n.err(I18n.ERR_04066, new Object[0]));
            throw new DecoderException(I18n.err(I18n.ERR_04067, new Object[0]));
        }
        Checksum checksum = checksumContainer.getChecksum();
        Value value = tlv.getValue();
        try {
            int cksumType = IntegerDecoder.parse(value);
            checksum.setChecksumType(ChecksumType.getTypeByValue(cksumType));
            if (IS_DEBUG) {
                LOG.debug("cksumType : " + cksumType);
            }
        }
        catch (IntegerDecoderException ide) {
            LOG.error(I18n.err(I18n.ERR_04070, Strings.dumpBytes(value.getData()), ide.getLocalizedMessage()));
            throw new DecoderException(ide.getMessage());
        }
    }
}

