/*
 * Decompiled with CFR 0.152.
 */
package org.apache.directory.server.core.api.schema.registries.synchronizers;

import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.directory.server.core.api.entry.ServerEntryUtils;
import org.apache.directory.server.core.api.interceptor.context.ModifyOperationContext;
import org.apache.directory.server.core.api.schema.registries.synchronizers.RegistrySynchronizer;
import org.apache.directory.server.i18n.I18n;
import org.apache.directory.shared.ldap.model.entry.Attribute;
import org.apache.directory.shared.ldap.model.entry.Entry;
import org.apache.directory.shared.ldap.model.entry.Modification;
import org.apache.directory.shared.ldap.model.entry.ModificationOperation;
import org.apache.directory.shared.ldap.model.entry.Value;
import org.apache.directory.shared.ldap.model.exception.LdapException;
import org.apache.directory.shared.ldap.model.exception.LdapInvalidDnException;
import org.apache.directory.shared.ldap.model.exception.LdapUnwillingToPerformException;
import org.apache.directory.shared.ldap.model.message.ResultCodeEnum;
import org.apache.directory.shared.ldap.model.name.Dn;
import org.apache.directory.shared.ldap.model.name.Rdn;
import org.apache.directory.shared.ldap.model.schema.AttributeType;
import org.apache.directory.shared.ldap.model.schema.SchemaManager;
import org.apache.directory.shared.ldap.model.schema.registries.Registries;
import org.apache.directory.shared.ldap.model.schema.registries.Schema;
import org.apache.directory.shared.ldap.schemaloader.SchemaEntityFactory;
import org.apache.directory.shared.util.Strings;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SchemaSynchronizer
implements RegistrySynchronizer {
    private static final Logger LOG = LoggerFactory.getLogger(SchemaSynchronizer.class);
    private final SchemaEntityFactory factory;
    private final SchemaManager schemaManager;
    private final Registries registries;
    private final AttributeType disabledAT;
    private final AttributeType cnAT;
    private final AttributeType dependenciesAT;
    private final Dn ouSchemaDn;

    public SchemaSynchronizer(SchemaManager schemaManager) throws Exception {
        this.registries = schemaManager.getRegistries();
        this.schemaManager = schemaManager;
        this.disabledAT = (AttributeType)this.registries.getAttributeTypeRegistry().lookup("m-disabled");
        this.factory = new SchemaEntityFactory();
        this.cnAT = (AttributeType)this.registries.getAttributeTypeRegistry().lookup("cn");
        this.dependenciesAT = (AttributeType)this.registries.getAttributeTypeRegistry().lookup("m-dependencies");
        this.ouSchemaDn = new Dn(schemaManager, "ou=schema");
    }

    @Override
    public boolean modify(ModifyOperationContext modifyContext, Entry targetEntry, boolean cascade) throws LdapException {
        Entry entry = modifyContext.getEntry();
        List<Modification> mods = modifyContext.getModItems();
        boolean hasModification = false;
        Attribute disabledInEntry = entry.get(this.disabledAT);
        Modification disabledModification = ServerEntryUtils.getModificationItem(mods, this.disabledAT);
        if (disabledModification != null) {
            ModificationOperation modification = disabledModification.getOperation();
            Attribute attribute = disabledModification.getAttribute();
            hasModification = this.modifyDisable(modifyContext, modification, attribute, disabledInEntry);
        } else if (disabledInEntry != null) {
            hasModification = this.modifyDisable(modifyContext, ModificationOperation.REMOVE_ATTRIBUTE, null, disabledInEntry);
        }
        return hasModification;
    }

    @Override
    public void moveAndRename(Dn oriChildName, Dn newParentName, Rdn newRn, boolean deleteOldRn, Entry entry, boolean cascaded) throws LdapException {
    }

    @Override
    public void add(Entry entry) throws LdapException {
        Dn dn = entry.getDn();
        Dn parentDn = dn.getParent();
        if (!parentDn.equals(this.ouSchemaDn)) {
            throw new LdapInvalidDnException(ResultCodeEnum.NAMING_VIOLATION, I18n.err(I18n.ERR_380, this.ouSchemaDn.getName(), parentDn.getNormName()));
        }
        boolean isEnabled = false;
        Attribute disabled = entry.get(this.disabledAT);
        if (disabled == null) {
            isEnabled = true;
        } else if (!disabled.contains("TRUE")) {
            isEnabled = true;
        }
        this.checkForDependencies(isEnabled, entry);
        if (isEnabled) {
            Schema schema = this.factory.getSchema(entry);
            this.schemaManager.load(schema);
        }
    }

    @Override
    public void delete(Entry entry, boolean cascade) throws LdapException {
        Attribute cn = entry.get(this.cnAT);
        String schemaName = cn.getString();
        Set<String> dependents = this.schemaManager.listDependentSchemaNames(schemaName);
        if (dependents != null && !dependents.isEmpty()) {
            String msg = I18n.err(I18n.ERR_381, dependents);
            LOG.warn(msg);
            throw new LdapUnwillingToPerformException(ResultCodeEnum.UNWILLING_TO_PERFORM, msg);
        }
        this.schemaManager.unload(schemaName);
    }

    @Override
    public void rename(Entry entry, Rdn newRdn, boolean cascade) throws LdapException {
        String rdnAttribute = newRdn.getUpType();
        String rdnAttributeOid = this.registries.getAttributeTypeRegistry().getOidByName(rdnAttribute);
        if (!rdnAttributeOid.equals(this.cnAT.getOid())) {
            throw new LdapUnwillingToPerformException(ResultCodeEnum.UNWILLING_TO_PERFORM, I18n.err(I18n.ERR_382, rdnAttribute));
        }
    }

    public void moveAndRename(Dn oriChildName, Dn newParentName, String newRn, boolean deleteOldRn, Entry entry, boolean cascade) throws LdapUnwillingToPerformException {
        throw new LdapUnwillingToPerformException(ResultCodeEnum.UNWILLING_TO_PERFORM, I18n.err(I18n.ERR_383, new Object[0]));
    }

    @Override
    public void move(Dn oriChildName, Dn newParentName, Entry entry, boolean cascade) throws LdapUnwillingToPerformException {
        throw new LdapUnwillingToPerformException(ResultCodeEnum.UNWILLING_TO_PERFORM, I18n.err(I18n.ERR_383, new Object[0]));
    }

    private boolean modifyDisable(ModifyOperationContext modifyContext, ModificationOperation modOp, Attribute disabledInMods, Attribute disabledInEntry) throws LdapException {
        Dn name = modifyContext.getDn();
        switch (modOp) {
            case ADD_ATTRIBUTE: {
                if (disabledInEntry != null || !"TRUE".equalsIgnoreCase(disabledInMods.getString())) break;
                return this.disableSchema(this.getSchemaName(name));
            }
            case REMOVE_ATTRIBUTE: {
                if (disabledInEntry == null || !"TRUE".equalsIgnoreCase(disabledInEntry.getString())) break;
                return this.enableSchema(this.getSchemaName(name));
            }
            case REPLACE_ATTRIBUTE: {
                boolean isCurrentlyDisabled = false;
                if (disabledInEntry != null) {
                    isCurrentlyDisabled = "TRUE".equalsIgnoreCase(disabledInEntry.getString());
                }
                boolean isNewStateDisabled = false;
                if (disabledInMods != null) {
                    Value<?> val = disabledInMods.get();
                    isNewStateDisabled = val == null ? false : "TRUE".equalsIgnoreCase(val.getString());
                }
                if (isCurrentlyDisabled && !isNewStateDisabled) {
                    return this.enableSchema(this.getSchemaName(name));
                }
                if (isCurrentlyDisabled || !isNewStateDisabled) break;
                return this.disableSchema(this.getSchemaName(name));
            }
            default: {
                throw new IllegalArgumentException(I18n.err(I18n.ERR_384, new Object[]{modOp}));
            }
        }
        return false;
    }

    private String getSchemaName(Dn schema) {
        return schema.getRdn().getNormValue().getString();
    }

    private boolean disableSchema(String schemaName) throws LdapException {
        Schema schema = this.registries.getLoadedSchema(schemaName);
        if (schema == null) {
            String msg = I18n.err(I18n.ERR_85, schemaName);
            LOG.error(msg);
            throw new LdapUnwillingToPerformException(ResultCodeEnum.UNWILLING_TO_PERFORM, msg);
        }
        return this.schemaManager.disable(schemaName);
    }

    private boolean enableSchema(String schemaName) throws LdapException {
        Schema schema = this.registries.getLoadedSchema(schemaName);
        if (schema == null) {
            this.schemaManager.loadDisabled(schemaName);
        }
        return this.schemaManager.enable(schemaName);
    }

    private void checkForDependencies(boolean isEnabled, Entry entry) throws LdapException {
        Attribute dependencies = entry.get(this.dependenciesAT);
        if (dependencies == null) {
            return;
        }
        if (isEnabled) {
            Map<String, Schema> loaded = this.registries.getLoadedSchemas();
            for (Value value : dependencies) {
                String dependency = value.getString();
                if (loaded.containsKey(dependency)) continue;
                throw new LdapUnwillingToPerformException(ResultCodeEnum.UNWILLING_TO_PERFORM, "Unwilling to perform operation on enabled schema with disabled or missing dependencies: " + dependency);
            }
        } else {
            for (Value value : dependencies) {
                String dependency = value.getString();
                if (this.schemaManager.getLoadedSchema(Strings.toLowerCase(dependency)) != null) continue;
                throw new LdapUnwillingToPerformException(ResultCodeEnum.UNWILLING_TO_PERFORM, I18n.err(I18n.ERR_385, dependency));
            }
        }
    }
}

