/*
 * Decompiled with CFR 0.152.
 */
package org.apache.directory.shared.kerberos.messages;

import java.nio.ByteBuffer;
import org.apache.directory.shared.asn1.EncoderException;
import org.apache.directory.shared.asn1.ber.tlv.TLV;
import org.apache.directory.shared.kerberos.KerberosMessageType;
import org.apache.directory.shared.kerberos.components.EncKdcRepPart;
import org.apache.directory.shared.kerberos.messages.KerberosMessage;

public class EncTgsRepPart
extends KerberosMessage {
    private EncKdcRepPart encKdcRepPart;
    private int encKdcRepPartLength;

    public EncTgsRepPart() {
        super(KerberosMessageType.ENC_TGS_REP_PART);
    }

    public EncKdcRepPart getEncKdcRepPart() {
        return this.encKdcRepPart;
    }

    public void setEncKdcRepPart(EncKdcRepPart encKdcRepPart) {
        this.encKdcRepPart = encKdcRepPart;
    }

    @Override
    public int computeLength() {
        this.encKdcRepPartLength = this.encKdcRepPart.computeLength();
        return 1 + TLV.getNbBytes(this.encKdcRepPartLength) + this.encKdcRepPartLength;
    }

    @Override
    public ByteBuffer encode(ByteBuffer buffer) throws EncoderException {
        if (buffer == null) {
            buffer = ByteBuffer.allocate(this.computeLength());
        }
        buffer.put((byte)122);
        buffer.put(TLV.getBytes(this.encKdcRepPartLength));
        this.encKdcRepPart.encode(buffer);
        return buffer;
    }
}

